@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VirtualBorderRouter].
 */
@PulumiTagMarker
public class VirtualBorderRouterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualBorderRouterArgs = VirtualBorderRouterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualBorderRouterArgsBuilder.() -> Unit) {
        val builder = VirtualBorderRouterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualBorderRouter {
        val builtJavaResource =
            com.pulumi.alicloud.expressconnect.VirtualBorderRouter(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualBorderRouter(builtJavaResource)
    }
}

/**
 * Provides a Express Connect Virtual Border Router resource.
 * For information about Express Connect Virtual Border Router and how to use it, see [What is Virtual Border Router](https://www.alibabacloud.com/help/en/doc-detail/44854.htm).
 * > **NOTE:** Available since v1.134.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = alicloud.expressconnect.getPhysicalConnections({
 *     nameRegex: "^preserved-NODELETING",
 * });
 * const vlanId = new random.index.Integer("vlan_id", {
 *     max: 2999,
 *     min: 1,
 * });
 * const exampleVirtualBorderRouter = new alicloud.expressconnect.VirtualBorderRouter("example", {
 *     localGatewayIp: "10.0.0.1",
 *     peerGatewayIp: "10.0.0.2",
 *     peeringSubnetMask: "255.255.255.252",
 *     physicalConnectionId: example.then(example => example.connections?.[0]?.id),
 *     virtualBorderRouterName: name,
 *     vlanId: vlanId.id,
 *     minRxInterval: 1000,
 *     minTxInterval: 1000,
 *     detectMultiplier: 10,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.expressconnect.get_physical_connections(name_regex="^preserved-NODELETING")
 * vlan_id = random.index.Integer("vlan_id",
 *     max=2999,
 *     min=1)
 * example_virtual_border_router = alicloud.expressconnect.VirtualBorderRouter("example",
 *     local_gateway_ip="10.0.0.1",
 *     peer_gateway_ip="10.0.0.2",
 *     peering_subnet_mask="255.255.255.252",
 *     physical_connection_id=example.connections[0].id,
 *     virtual_border_router_name=name,
 *     vlan_id=vlan_id["id"],
 *     min_rx_interval=1000,
 *     min_tx_interval=1000,
 *     detect_multiplier=10)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = AliCloud.ExpressConnect.GetPhysicalConnections.Invoke(new()
 *     {
 *         NameRegex = "^preserved-NODELETING",
 *     });
 *     var vlanId = new Random.Index.Integer("vlan_id", new()
 *     {
 *         Max = 2999,
 *         Min = 1,
 *     });
 *     var exampleVirtualBorderRouter = new AliCloud.ExpressConnect.VirtualBorderRouter("example", new()
 *     {
 *         LocalGatewayIp = "10.0.0.1",
 *         PeerGatewayIp = "10.0.0.2",
 *         PeeringSubnetMask = "255.255.255.252",
 *         PhysicalConnectionId = example.Apply(getPhysicalConnectionsResult => getPhysicalConnectionsResult.Connections[0]?.Id),
 *         VirtualBorderRouterName = name,
 *         VlanId = vlanId.Id,
 *         MinRxInterval = 1000,
 *         MinTxInterval = 1000,
 *         DetectMultiplier = 10,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		example, err := expressconnect.GetPhysicalConnections(ctx, &expressconnect.GetPhysicalConnectionsArgs{
 * 			NameRegex: pulumi.StringRef("^preserved-NODELETING"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		vlanId, err := random.NewInteger(ctx, "vlan_id", &random.IntegerArgs{
 * 			Max: 2999,
 * 			Min: 1,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = expressconnect.NewVirtualBorderRouter(ctx, "example", &expressconnect.VirtualBorderRouterArgs{
 * 			LocalGatewayIp:          pulumi.String("10.0.0.1"),
 * 			PeerGatewayIp:           pulumi.String("10.0.0.2"),
 * 			PeeringSubnetMask:       pulumi.String("255.255.255.252"),
 * 			PhysicalConnectionId:    pulumi.String(example.Connections[0].Id),
 * 			VirtualBorderRouterName: pulumi.String(name),
 * 			VlanId:                  vlanId.Id,
 * 			MinRxInterval:           pulumi.Int(1000),
 * 			MinTxInterval:           pulumi.Int(1000),
 * 			DetectMultiplier:        pulumi.Int(10),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions;
 * import com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionsArgs;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.expressconnect.VirtualBorderRouter;
 * import com.pulumi.alicloud.expressconnect.VirtualBorderRouterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var example = ExpressconnectFunctions.getPhysicalConnections(GetPhysicalConnectionsArgs.builder()
 *             .nameRegex("^preserved-NODELETING")
 *             .build());
 *         var vlanId = new Integer("vlanId", IntegerArgs.builder()
 *             .max(2999)
 *             .min(1)
 *             .build());
 *         var exampleVirtualBorderRouter = new VirtualBorderRouter("exampleVirtualBorderRouter", VirtualBorderRouterArgs.builder()
 *             .localGatewayIp("10.0.0.1")
 *             .peerGatewayIp("10.0.0.2")
 *             .peeringSubnetMask("255.255.255.252")
 *             .physicalConnectionId(example.applyValue(getPhysicalConnectionsResult -> getPhysicalConnectionsResult.connections()[0].id()))
 *             .virtualBorderRouterName(name)
 *             .vlanId(vlanId.id())
 *             .minRxInterval(1000)
 *             .minTxInterval(1000)
 *             .detectMultiplier(10)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   vlanId:
 *     type: random:integer
 *     name: vlan_id
 *     properties:
 *       max: 2999
 *       min: 1
 *   exampleVirtualBorderRouter:
 *     type: alicloud:expressconnect:VirtualBorderRouter
 *     name: example
 *     properties:
 *       localGatewayIp: 10.0.0.1
 *       peerGatewayIp: 10.0.0.2
 *       peeringSubnetMask: 255.255.255.252
 *       physicalConnectionId: ${example.connections[0].id}
 *       virtualBorderRouterName: ${name}
 *       vlanId: ${vlanId.id}
 *       minRxInterval: 1000
 *       minTxInterval: 1000
 *       detectMultiplier: 10
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:expressconnect:getPhysicalConnections
 *       Arguments:
 *         nameRegex: ^preserved-NODELETING
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Express Connect Virtual Border Router can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:expressconnect/virtualBorderRouter:VirtualBorderRouter example <id>
 * ```
 */
public class VirtualBorderRouter internal constructor(
    override val javaResource: com.pulumi.alicloud.expressconnect.VirtualBorderRouter,
) : KotlinCustomResource(javaResource, VirtualBorderRouterMapper) {
    /**
     * The associated physical connections.
     */
    public val associatedPhysicalConnections: Output<String>?
        get() = javaResource.associatedPhysicalConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The bandwidth.
     */
    public val bandwidth: Output<Int>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * Operators for physical connection circuit provided coding.
     */
    public val circuitCode: Output<String>?
        get() = javaResource.circuitCode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of VBR. Length is from 2 to 256 characters, must start with a letter or the Chinese at the beginning, but not at the http:// Or https:// at the beginning.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Detection time multiplier that recipient allows the sender to send a message of the maximum allowable connections for the number of packets, used to detect whether the link normal. Value: 3~10.
     */
    public val detectMultiplier: Output<Int>
        get() = javaResource.detectMultiplier().applyValue({ args0 -> args0 })

    /**
     * Whether to Enable IPv6. Valid values: `false`, `true`.
     */
    public val enableIpv6: Output<Boolean>
        get() = javaResource.enableIpv6().applyValue({ args0 -> args0 })

    /**
     * Whether cross account border routers are included. Valid values: `false`, `true`. Default: `true`.
     */
    public val includeCrossAccountVbr: Output<Boolean>
        get() = javaResource.includeCrossAccountVbr().applyValue({ args0 -> args0 })

    /**
     * Alibaba Cloud-Connected IPv4 address.
     */
    public val localGatewayIp: Output<String>
        get() = javaResource.localGatewayIp().applyValue({ args0 -> args0 })

    /**
     * Alibaba Cloud-Connected IPv6 Address.
     */
    public val localIpv6GatewayIp: Output<String>?
        get() = javaResource.localIpv6GatewayIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configure BFD packet reception interval of values include: 200~1000, unit: ms.
     */
    public val minRxInterval: Output<Int>
        get() = javaResource.minRxInterval().applyValue({ args0 -> args0 })

    /**
     * Configure BFD packet transmission interval maximum value: 200~1000, unit: ms.
     */
    public val minTxInterval: Output<Int>
        get() = javaResource.minTxInterval().applyValue({ args0 -> args0 })

    /**
     * The Client-Side Interconnection IPv4 Address.
     */
    public val peerGatewayIp: Output<String>
        get() = javaResource.peerGatewayIp().applyValue({ args0 -> args0 })

    /**
     * The Client-Side Interconnection IPv6 Address.
     */
    public val peerIpv6GatewayIp: Output<String>?
        get() = javaResource.peerIpv6GatewayIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Alibaba Cloud-Connected IPv6 with Client-Side Interconnection IPv6 of Subnet Mask.
     */
    public val peeringIpv6SubnetMask: Output<String>?
        get() = javaResource.peeringIpv6SubnetMask().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Alibaba Cloud-Connected IPv4 and Client-Side Interconnection IPv4 of Subnet Mask.
     */
    public val peeringSubnetMask: Output<String>
        get() = javaResource.peeringSubnetMask().applyValue({ args0 -> args0 })

    /**
     * The ID of the Physical Connection to Which the ID.
     */
    public val physicalConnectionId: Output<String>
        get() = javaResource.physicalConnectionId().applyValue({ args0 -> args0 })

    /**
     * (Available in v1.166.0+) The Route Table ID Of the Virtual Border Router.
     */
    public val routeTableId: Output<String>
        get() = javaResource.routeTableId().applyValue({ args0 -> args0 })

    /**
     * The instance state. Valid values: `active`, `deleting`, `recovering`, `terminated`, `terminating`, `unconfirmed`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The vbr owner id.
     */
    public val vbrOwnerId: Output<String>?
        get() = javaResource.vbrOwnerId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of VBR. Length is from 2 to 128 characters, must start with a letter or the Chinese at the beginning can contain numbers, the underscore character (_) and dash (-). But do not start with http:// or https:// at the beginning.
     */
    public val virtualBorderRouterName: Output<String>?
        get() = javaResource.virtualBorderRouterName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The VLAN ID of the VBR. Value range: 0~2999.
     */
    public val vlanId: Output<Int>
        get() = javaResource.vlanId().applyValue({ args0 -> args0 })
}

public object VirtualBorderRouterMapper : ResourceMapper<VirtualBorderRouter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.expressconnect.VirtualBorderRouter::class == javaResource::class

    override fun map(javaResource: Resource): VirtualBorderRouter = VirtualBorderRouter(
        javaResource
            as com.pulumi.alicloud.expressconnect.VirtualBorderRouter,
    )
}

/**
 * @see [VirtualBorderRouter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualBorderRouter].
 */
public suspend fun virtualBorderRouter(
    name: String,
    block: suspend VirtualBorderRouterResourceBuilder.() -> Unit,
): VirtualBorderRouter {
    val builder = VirtualBorderRouterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualBorderRouter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualBorderRouter(name: String): VirtualBorderRouter {
    val builder = VirtualBorderRouterResourceBuilder()
    builder.name(name)
    return builder.build()
}
