@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin

import com.pulumi.alicloud.expressconnect.VirtualBorderRouterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Express Connect Virtual Border Router resource.
 * For information about Express Connect Virtual Border Router and how to use it, see [What is Virtual Border Router](https://www.alibabacloud.com/help/en/doc-detail/44854.htm).
 * > **NOTE:** Available since v1.134.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = alicloud.expressconnect.getPhysicalConnections({
 *     nameRegex: "^preserved-NODELETING",
 * });
 * const vlanId = new random.index.Integer("vlan_id", {
 *     max: 2999,
 *     min: 1,
 * });
 * const exampleVirtualBorderRouter = new alicloud.expressconnect.VirtualBorderRouter("example", {
 *     localGatewayIp: "10.0.0.1",
 *     peerGatewayIp: "10.0.0.2",
 *     peeringSubnetMask: "255.255.255.252",
 *     physicalConnectionId: example.then(example => example.connections?.[0]?.id),
 *     virtualBorderRouterName: name,
 *     vlanId: vlanId.id,
 *     minRxInterval: 1000,
 *     minTxInterval: 1000,
 *     detectMultiplier: 10,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.expressconnect.get_physical_connections(name_regex="^preserved-NODELETING")
 * vlan_id = random.index.Integer("vlan_id",
 *     max=2999,
 *     min=1)
 * example_virtual_border_router = alicloud.expressconnect.VirtualBorderRouter("example",
 *     local_gateway_ip="10.0.0.1",
 *     peer_gateway_ip="10.0.0.2",
 *     peering_subnet_mask="255.255.255.252",
 *     physical_connection_id=example.connections[0].id,
 *     virtual_border_router_name=name,
 *     vlan_id=vlan_id["id"],
 *     min_rx_interval=1000,
 *     min_tx_interval=1000,
 *     detect_multiplier=10)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = AliCloud.ExpressConnect.GetPhysicalConnections.Invoke(new()
 *     {
 *         NameRegex = "^preserved-NODELETING",
 *     });
 *     var vlanId = new Random.Index.Integer("vlan_id", new()
 *     {
 *         Max = 2999,
 *         Min = 1,
 *     });
 *     var exampleVirtualBorderRouter = new AliCloud.ExpressConnect.VirtualBorderRouter("example", new()
 *     {
 *         LocalGatewayIp = "10.0.0.1",
 *         PeerGatewayIp = "10.0.0.2",
 *         PeeringSubnetMask = "255.255.255.252",
 *         PhysicalConnectionId = example.Apply(getPhysicalConnectionsResult => getPhysicalConnectionsResult.Connections[0]?.Id),
 *         VirtualBorderRouterName = name,
 *         VlanId = vlanId.Id,
 *         MinRxInterval = 1000,
 *         MinTxInterval = 1000,
 *         DetectMultiplier = 10,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		example, err := expressconnect.GetPhysicalConnections(ctx, &expressconnect.GetPhysicalConnectionsArgs{
 * 			NameRegex: pulumi.StringRef("^preserved-NODELETING"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		vlanId, err := random.NewInteger(ctx, "vlan_id", &random.IntegerArgs{
 * 			Max: 2999,
 * 			Min: 1,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = expressconnect.NewVirtualBorderRouter(ctx, "example", &expressconnect.VirtualBorderRouterArgs{
 * 			LocalGatewayIp:          pulumi.String("10.0.0.1"),
 * 			PeerGatewayIp:           pulumi.String("10.0.0.2"),
 * 			PeeringSubnetMask:       pulumi.String("255.255.255.252"),
 * 			PhysicalConnectionId:    pulumi.String(example.Connections[0].Id),
 * 			VirtualBorderRouterName: pulumi.String(name),
 * 			VlanId:                  vlanId.Id,
 * 			MinRxInterval:           pulumi.Int(1000),
 * 			MinTxInterval:           pulumi.Int(1000),
 * 			DetectMultiplier:        pulumi.Int(10),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions;
 * import com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionsArgs;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.expressconnect.VirtualBorderRouter;
 * import com.pulumi.alicloud.expressconnect.VirtualBorderRouterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var example = ExpressconnectFunctions.getPhysicalConnections(GetPhysicalConnectionsArgs.builder()
 *             .nameRegex("^preserved-NODELETING")
 *             .build());
 *         var vlanId = new Integer("vlanId", IntegerArgs.builder()
 *             .max(2999)
 *             .min(1)
 *             .build());
 *         var exampleVirtualBorderRouter = new VirtualBorderRouter("exampleVirtualBorderRouter", VirtualBorderRouterArgs.builder()
 *             .localGatewayIp("10.0.0.1")
 *             .peerGatewayIp("10.0.0.2")
 *             .peeringSubnetMask("255.255.255.252")
 *             .physicalConnectionId(example.applyValue(getPhysicalConnectionsResult -> getPhysicalConnectionsResult.connections()[0].id()))
 *             .virtualBorderRouterName(name)
 *             .vlanId(vlanId.id())
 *             .minRxInterval(1000)
 *             .minTxInterval(1000)
 *             .detectMultiplier(10)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   vlanId:
 *     type: random:integer
 *     name: vlan_id
 *     properties:
 *       max: 2999
 *       min: 1
 *   exampleVirtualBorderRouter:
 *     type: alicloud:expressconnect:VirtualBorderRouter
 *     name: example
 *     properties:
 *       localGatewayIp: 10.0.0.1
 *       peerGatewayIp: 10.0.0.2
 *       peeringSubnetMask: 255.255.255.252
 *       physicalConnectionId: ${example.connections[0].id}
 *       virtualBorderRouterName: ${name}
 *       vlanId: ${vlanId.id}
 *       minRxInterval: 1000
 *       minTxInterval: 1000
 *       detectMultiplier: 10
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:expressconnect:getPhysicalConnections
 *       Arguments:
 *         nameRegex: ^preserved-NODELETING
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Express Connect Virtual Border Router can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:expressconnect/virtualBorderRouter:VirtualBorderRouter example <id>
 * ```
 * @property associatedPhysicalConnections The associated physical connections.
 * @property bandwidth The bandwidth.
 * @property circuitCode Operators for physical connection circuit provided coding.
 * @property description The description of VBR. Length is from 2 to 256 characters, must start with a letter or the Chinese at the beginning, but not at the http:// Or https:// at the beginning.
 * @property detectMultiplier Detection time multiplier that recipient allows the sender to send a message of the maximum allowable connections for the number of packets, used to detect whether the link normal. Value: 3~10.
 * @property enableIpv6 Whether to Enable IPv6. Valid values: `false`, `true`.
 * @property includeCrossAccountVbr Whether cross account border routers are included. Valid values: `false`, `true`. Default: `true`.
 * @property localGatewayIp Alibaba Cloud-Connected IPv4 address.
 * @property localIpv6GatewayIp Alibaba Cloud-Connected IPv6 Address.
 * @property minRxInterval Configure BFD packet reception interval of values include: 200~1000, unit: ms.
 * @property minTxInterval Configure BFD packet transmission interval maximum value: 200~1000, unit: ms.
 * @property peerGatewayIp The Client-Side Interconnection IPv4 Address.
 * @property peerIpv6GatewayIp The Client-Side Interconnection IPv6 Address.
 * @property peeringIpv6SubnetMask Alibaba Cloud-Connected IPv6 with Client-Side Interconnection IPv6 of Subnet Mask.
 * @property peeringSubnetMask Alibaba Cloud-Connected IPv4 and Client-Side Interconnection IPv4 of Subnet Mask.
 * @property physicalConnectionId The ID of the Physical Connection to Which the ID.
 * @property status The instance state. Valid values: `active`, `deleting`, `recovering`, `terminated`, `terminating`, `unconfirmed`.
 * @property vbrOwnerId The vbr owner id.
 * @property virtualBorderRouterName The name of VBR. Length is from 2 to 128 characters, must start with a letter or the Chinese at the beginning can contain numbers, the underscore character (_) and dash (-). But do not start with http:// or https:// at the beginning.
 * @property vlanId The VLAN ID of the VBR. Value range: 0~2999.
 */
public data class VirtualBorderRouterArgs(
    public val associatedPhysicalConnections: Output<String>? = null,
    public val bandwidth: Output<Int>? = null,
    public val circuitCode: Output<String>? = null,
    public val description: Output<String>? = null,
    public val detectMultiplier: Output<Int>? = null,
    public val enableIpv6: Output<Boolean>? = null,
    public val includeCrossAccountVbr: Output<Boolean>? = null,
    public val localGatewayIp: Output<String>? = null,
    public val localIpv6GatewayIp: Output<String>? = null,
    public val minRxInterval: Output<Int>? = null,
    public val minTxInterval: Output<Int>? = null,
    public val peerGatewayIp: Output<String>? = null,
    public val peerIpv6GatewayIp: Output<String>? = null,
    public val peeringIpv6SubnetMask: Output<String>? = null,
    public val peeringSubnetMask: Output<String>? = null,
    public val physicalConnectionId: Output<String>? = null,
    public val status: Output<String>? = null,
    public val vbrOwnerId: Output<String>? = null,
    public val virtualBorderRouterName: Output<String>? = null,
    public val vlanId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.expressconnect.VirtualBorderRouterArgs> {
    override fun toJava(): com.pulumi.alicloud.expressconnect.VirtualBorderRouterArgs =
        com.pulumi.alicloud.expressconnect.VirtualBorderRouterArgs.builder()
            .associatedPhysicalConnections(associatedPhysicalConnections?.applyValue({ args0 -> args0 }))
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .circuitCode(circuitCode?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .detectMultiplier(detectMultiplier?.applyValue({ args0 -> args0 }))
            .enableIpv6(enableIpv6?.applyValue({ args0 -> args0 }))
            .includeCrossAccountVbr(includeCrossAccountVbr?.applyValue({ args0 -> args0 }))
            .localGatewayIp(localGatewayIp?.applyValue({ args0 -> args0 }))
            .localIpv6GatewayIp(localIpv6GatewayIp?.applyValue({ args0 -> args0 }))
            .minRxInterval(minRxInterval?.applyValue({ args0 -> args0 }))
            .minTxInterval(minTxInterval?.applyValue({ args0 -> args0 }))
            .peerGatewayIp(peerGatewayIp?.applyValue({ args0 -> args0 }))
            .peerIpv6GatewayIp(peerIpv6GatewayIp?.applyValue({ args0 -> args0 }))
            .peeringIpv6SubnetMask(peeringIpv6SubnetMask?.applyValue({ args0 -> args0 }))
            .peeringSubnetMask(peeringSubnetMask?.applyValue({ args0 -> args0 }))
            .physicalConnectionId(physicalConnectionId?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .vbrOwnerId(vbrOwnerId?.applyValue({ args0 -> args0 }))
            .virtualBorderRouterName(virtualBorderRouterName?.applyValue({ args0 -> args0 }))
            .vlanId(vlanId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualBorderRouterArgs].
 */
@PulumiTagMarker
public class VirtualBorderRouterArgsBuilder internal constructor() {
    private var associatedPhysicalConnections: Output<String>? = null

    private var bandwidth: Output<Int>? = null

    private var circuitCode: Output<String>? = null

    private var description: Output<String>? = null

    private var detectMultiplier: Output<Int>? = null

    private var enableIpv6: Output<Boolean>? = null

    private var includeCrossAccountVbr: Output<Boolean>? = null

    private var localGatewayIp: Output<String>? = null

    private var localIpv6GatewayIp: Output<String>? = null

    private var minRxInterval: Output<Int>? = null

    private var minTxInterval: Output<Int>? = null

    private var peerGatewayIp: Output<String>? = null

    private var peerIpv6GatewayIp: Output<String>? = null

    private var peeringIpv6SubnetMask: Output<String>? = null

    private var peeringSubnetMask: Output<String>? = null

    private var physicalConnectionId: Output<String>? = null

    private var status: Output<String>? = null

    private var vbrOwnerId: Output<String>? = null

    private var virtualBorderRouterName: Output<String>? = null

    private var vlanId: Output<Int>? = null

    /**
     * @param value The associated physical connections.
     */
    @JvmName("frlpyihquifaulul")
    public suspend fun associatedPhysicalConnections(`value`: Output<String>) {
        this.associatedPhysicalConnections = value
    }

    /**
     * @param value The bandwidth.
     */
    @JvmName("mugptaarcgohchvf")
    public suspend fun bandwidth(`value`: Output<Int>) {
        this.bandwidth = value
    }

    /**
     * @param value Operators for physical connection circuit provided coding.
     */
    @JvmName("ltgapxtkwsywvtca")
    public suspend fun circuitCode(`value`: Output<String>) {
        this.circuitCode = value
    }

    /**
     * @param value The description of VBR. Length is from 2 to 256 characters, must start with a letter or the Chinese at the beginning, but not at the http:// Or https:// at the beginning.
     */
    @JvmName("bbmcsdiayrgdmfha")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Detection time multiplier that recipient allows the sender to send a message of the maximum allowable connections for the number of packets, used to detect whether the link normal. Value: 3~10.
     */
    @JvmName("vleykqrprjkqfspy")
    public suspend fun detectMultiplier(`value`: Output<Int>) {
        this.detectMultiplier = value
    }

    /**
     * @param value Whether to Enable IPv6. Valid values: `false`, `true`.
     */
    @JvmName("bcsefiukagphdqnq")
    public suspend fun enableIpv6(`value`: Output<Boolean>) {
        this.enableIpv6 = value
    }

    /**
     * @param value Whether cross account border routers are included. Valid values: `false`, `true`. Default: `true`.
     */
    @JvmName("dovqflkmkoihykak")
    public suspend fun includeCrossAccountVbr(`value`: Output<Boolean>) {
        this.includeCrossAccountVbr = value
    }

    /**
     * @param value Alibaba Cloud-Connected IPv4 address.
     */
    @JvmName("vxqlopeviruybrnl")
    public suspend fun localGatewayIp(`value`: Output<String>) {
        this.localGatewayIp = value
    }

    /**
     * @param value Alibaba Cloud-Connected IPv6 Address.
     */
    @JvmName("hcbpurcivsophyld")
    public suspend fun localIpv6GatewayIp(`value`: Output<String>) {
        this.localIpv6GatewayIp = value
    }

    /**
     * @param value Configure BFD packet reception interval of values include: 200~1000, unit: ms.
     */
    @JvmName("isxcpuklknykfhey")
    public suspend fun minRxInterval(`value`: Output<Int>) {
        this.minRxInterval = value
    }

    /**
     * @param value Configure BFD packet transmission interval maximum value: 200~1000, unit: ms.
     */
    @JvmName("naervxshjlgitwwd")
    public suspend fun minTxInterval(`value`: Output<Int>) {
        this.minTxInterval = value
    }

    /**
     * @param value The Client-Side Interconnection IPv4 Address.
     */
    @JvmName("qhjnbjpifmbrvtla")
    public suspend fun peerGatewayIp(`value`: Output<String>) {
        this.peerGatewayIp = value
    }

    /**
     * @param value The Client-Side Interconnection IPv6 Address.
     */
    @JvmName("hmrcqsbmdswxhqva")
    public suspend fun peerIpv6GatewayIp(`value`: Output<String>) {
        this.peerIpv6GatewayIp = value
    }

    /**
     * @param value Alibaba Cloud-Connected IPv6 with Client-Side Interconnection IPv6 of Subnet Mask.
     */
    @JvmName("gdcpoxoxvojeenje")
    public suspend fun peeringIpv6SubnetMask(`value`: Output<String>) {
        this.peeringIpv6SubnetMask = value
    }

    /**
     * @param value Alibaba Cloud-Connected IPv4 and Client-Side Interconnection IPv4 of Subnet Mask.
     */
    @JvmName("vgsbtheyflvjkdcu")
    public suspend fun peeringSubnetMask(`value`: Output<String>) {
        this.peeringSubnetMask = value
    }

    /**
     * @param value The ID of the Physical Connection to Which the ID.
     */
    @JvmName("immyuqslydsxjhyu")
    public suspend fun physicalConnectionId(`value`: Output<String>) {
        this.physicalConnectionId = value
    }

    /**
     * @param value The instance state. Valid values: `active`, `deleting`, `recovering`, `terminated`, `terminating`, `unconfirmed`.
     */
    @JvmName("myfqglqtfsfintme")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The vbr owner id.
     */
    @JvmName("fgoglldhsqnfusyw")
    public suspend fun vbrOwnerId(`value`: Output<String>) {
        this.vbrOwnerId = value
    }

    /**
     * @param value The name of VBR. Length is from 2 to 128 characters, must start with a letter or the Chinese at the beginning can contain numbers, the underscore character (_) and dash (-). But do not start with http:// or https:// at the beginning.
     */
    @JvmName("cojgwcpwkkeuutrf")
    public suspend fun virtualBorderRouterName(`value`: Output<String>) {
        this.virtualBorderRouterName = value
    }

    /**
     * @param value The VLAN ID of the VBR. Value range: 0~2999.
     */
    @JvmName("drdxyfibjdujqrok")
    public suspend fun vlanId(`value`: Output<Int>) {
        this.vlanId = value
    }

    /**
     * @param value The associated physical connections.
     */
    @JvmName("bbpllgcxebslqujl")
    public suspend fun associatedPhysicalConnections(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associatedPhysicalConnections = mapped
    }

    /**
     * @param value The bandwidth.
     */
    @JvmName("smvprergukvmjqjv")
    public suspend fun bandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value Operators for physical connection circuit provided coding.
     */
    @JvmName("yhvwycmhqxrqxqie")
    public suspend fun circuitCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.circuitCode = mapped
    }

    /**
     * @param value The description of VBR. Length is from 2 to 256 characters, must start with a letter or the Chinese at the beginning, but not at the http:// Or https:// at the beginning.
     */
    @JvmName("ksjflucdsxkwpfxw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Detection time multiplier that recipient allows the sender to send a message of the maximum allowable connections for the number of packets, used to detect whether the link normal. Value: 3~10.
     */
    @JvmName("fsymwkcdetsolonl")
    public suspend fun detectMultiplier(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detectMultiplier = mapped
    }

    /**
     * @param value Whether to Enable IPv6. Valid values: `false`, `true`.
     */
    @JvmName("qwwkmxfnmgfxxasw")
    public suspend fun enableIpv6(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableIpv6 = mapped
    }

    /**
     * @param value Whether cross account border routers are included. Valid values: `false`, `true`. Default: `true`.
     */
    @JvmName("mnypixcwhcbkldpb")
    public suspend fun includeCrossAccountVbr(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeCrossAccountVbr = mapped
    }

    /**
     * @param value Alibaba Cloud-Connected IPv4 address.
     */
    @JvmName("bkxrwxmuhxhsnjhs")
    public suspend fun localGatewayIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localGatewayIp = mapped
    }

    /**
     * @param value Alibaba Cloud-Connected IPv6 Address.
     */
    @JvmName("vauicboqiqafvntq")
    public suspend fun localIpv6GatewayIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localIpv6GatewayIp = mapped
    }

    /**
     * @param value Configure BFD packet reception interval of values include: 200~1000, unit: ms.
     */
    @JvmName("dxomdhbdqthowoup")
    public suspend fun minRxInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minRxInterval = mapped
    }

    /**
     * @param value Configure BFD packet transmission interval maximum value: 200~1000, unit: ms.
     */
    @JvmName("qtjysvvhysivtfjv")
    public suspend fun minTxInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minTxInterval = mapped
    }

    /**
     * @param value The Client-Side Interconnection IPv4 Address.
     */
    @JvmName("cidscrkxtfhcsogx")
    public suspend fun peerGatewayIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerGatewayIp = mapped
    }

    /**
     * @param value The Client-Side Interconnection IPv6 Address.
     */
    @JvmName("gdetoqlxfsohbldr")
    public suspend fun peerIpv6GatewayIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerIpv6GatewayIp = mapped
    }

    /**
     * @param value Alibaba Cloud-Connected IPv6 with Client-Side Interconnection IPv6 of Subnet Mask.
     */
    @JvmName("whwlatmhkjsleoqd")
    public suspend fun peeringIpv6SubnetMask(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringIpv6SubnetMask = mapped
    }

    /**
     * @param value Alibaba Cloud-Connected IPv4 and Client-Side Interconnection IPv4 of Subnet Mask.
     */
    @JvmName("lylechfuxnslwqfq")
    public suspend fun peeringSubnetMask(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringSubnetMask = mapped
    }

    /**
     * @param value The ID of the Physical Connection to Which the ID.
     */
    @JvmName("hwkxgwdgraxldxjg")
    public suspend fun physicalConnectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.physicalConnectionId = mapped
    }

    /**
     * @param value The instance state. Valid values: `active`, `deleting`, `recovering`, `terminated`, `terminating`, `unconfirmed`.
     */
    @JvmName("fgsjcogpvufovciw")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The vbr owner id.
     */
    @JvmName("lsblkxiaveamfayo")
    public suspend fun vbrOwnerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vbrOwnerId = mapped
    }

    /**
     * @param value The name of VBR. Length is from 2 to 128 characters, must start with a letter or the Chinese at the beginning can contain numbers, the underscore character (_) and dash (-). But do not start with http:// or https:// at the beginning.
     */
    @JvmName("bvsqwcrtqkwslkxi")
    public suspend fun virtualBorderRouterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualBorderRouterName = mapped
    }

    /**
     * @param value The VLAN ID of the VBR. Value range: 0~2999.
     */
    @JvmName("knecyaakhbyxwrha")
    public suspend fun vlanId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlanId = mapped
    }

    internal fun build(): VirtualBorderRouterArgs = VirtualBorderRouterArgs(
        associatedPhysicalConnections = associatedPhysicalConnections,
        bandwidth = bandwidth,
        circuitCode = circuitCode,
        description = description,
        detectMultiplier = detectMultiplier,
        enableIpv6 = enableIpv6,
        includeCrossAccountVbr = includeCrossAccountVbr,
        localGatewayIp = localGatewayIp,
        localIpv6GatewayIp = localIpv6GatewayIp,
        minRxInterval = minRxInterval,
        minTxInterval = minTxInterval,
        peerGatewayIp = peerGatewayIp,
        peerIpv6GatewayIp = peerIpv6GatewayIp,
        peeringIpv6SubnetMask = peeringIpv6SubnetMask,
        peeringSubnetMask = peeringSubnetMask,
        physicalConnectionId = physicalConnectionId,
        status = status,
        vbrOwnerId = vbrOwnerId,
        virtualBorderRouterName = virtualBorderRouterName,
        vlanId = vlanId,
    )
}
