@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VirtualPhysicalConnection].
 */
@PulumiTagMarker
public class VirtualPhysicalConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualPhysicalConnectionArgs = VirtualPhysicalConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualPhysicalConnectionArgsBuilder.() -> Unit) {
        val builder = VirtualPhysicalConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualPhysicalConnection {
        val builtJavaResource =
            com.pulumi.alicloud.expressconnect.VirtualPhysicalConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualPhysicalConnection(builtJavaResource)
    }
}

/**
 * Provides a Express Connect Virtual Physical Connection resource.
 * For information about Express Connect Virtual Physical Connection and how to use it, see [What is Virtual Physical Connection](https://www.alibabacloud.com/help/en/express-connect/latest/createvirtualphysicalconnection#doc-api-Vpc-CreateVirtualPhysicalConnection).
 * > **NOTE:** Available since v1.196.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = alicloud.expressconnect.getPhysicalConnections({
 *     nameRegex: "^preserved-NODELETING",
 * });
 * const vlanId = new random.index.Integer("vlan_id", {
 *     max: 2999,
 *     min: 1,
 * });
 * const default = alicloud.getAccount({});
 * const exampleVirtualPhysicalConnection = new alicloud.expressconnect.VirtualPhysicalConnection("example", {
 *     virtualPhysicalConnectionName: name,
 *     description: name,
 *     orderMode: "PayByPhysicalConnectionOwner",
 *     parentPhysicalConnectionId: example.then(example => example.ids?.[0]),
 *     spec: "50M",
 *     vlanId: vlanId.id,
 *     vpconnAliUid: _default.then(_default => _default.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.expressconnect.get_physical_connections(name_regex="^preserved-NODELETING")
 * vlan_id = random.index.Integer("vlan_id",
 *     max=2999,
 *     min=1)
 * default = alicloud.get_account()
 * example_virtual_physical_connection = alicloud.expressconnect.VirtualPhysicalConnection("example",
 *     virtual_physical_connection_name=name,
 *     description=name,
 *     order_mode="PayByPhysicalConnectionOwner",
 *     parent_physical_connection_id=example.ids[0],
 *     spec="50M",
 *     vlan_id=vlan_id["id"],
 *     vpconn_ali_uid=default.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = AliCloud.ExpressConnect.GetPhysicalConnections.Invoke(new()
 *     {
 *         NameRegex = "^preserved-NODELETING",
 *     });
 *     var vlanId = new Random.Index.Integer("vlan_id", new()
 *     {
 *         Max = 2999,
 *         Min = 1,
 *     });
 *     var @default = AliCloud.GetAccount.Invoke();
 *     var exampleVirtualPhysicalConnection = new AliCloud.ExpressConnect.VirtualPhysicalConnection("example", new()
 *     {
 *         VirtualPhysicalConnectionName = name,
 *         Description = name,
 *         OrderMode = "PayByPhysicalConnectionOwner",
 *         ParentPhysicalConnectionId = example.Apply(getPhysicalConnectionsResult => getPhysicalConnectionsResult.Ids[0]),
 *         Spec = "50M",
 *         VlanId = vlanId.Id,
 *         VpconnAliUid = @default.Apply(@default => @default.Apply(getAccountResult => getAccountResult.Id)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		example, err := expressconnect.GetPhysicalConnections(ctx, &expressconnect.GetPhysicalConnectionsArgs{
 * 			NameRegex: pulumi.StringRef("^preserved-NODELETING"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		vlanId, err := random.NewInteger(ctx, "vlan_id", &random.IntegerArgs{
 * 			Max: 2999,
 * 			Min: 1,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = expressconnect.NewVirtualPhysicalConnection(ctx, "example", &expressconnect.VirtualPhysicalConnectionArgs{
 * 			VirtualPhysicalConnectionName: pulumi.String(name),
 * 			Description:                   pulumi.String(name),
 * 			OrderMode:                     pulumi.String("PayByPhysicalConnectionOwner"),
 * 			ParentPhysicalConnectionId:    pulumi.String(example.Ids[0]),
 * 			Spec:                          pulumi.String("50M"),
 * 			VlanId:                        vlanId.Id,
 * 			VpconnAliUid:                  pulumi.String(_default.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions;
 * import com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionsArgs;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.expressconnect.VirtualPhysicalConnection;
 * import com.pulumi.alicloud.expressconnect.VirtualPhysicalConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var example = ExpressconnectFunctions.getPhysicalConnections(GetPhysicalConnectionsArgs.builder()
 *             .nameRegex("^preserved-NODELETING")
 *             .build());
 *         var vlanId = new Integer("vlanId", IntegerArgs.builder()
 *             .max(2999)
 *             .min(1)
 *             .build());
 *         final var default = AlicloudFunctions.getAccount();
 *         var exampleVirtualPhysicalConnection = new VirtualPhysicalConnection("exampleVirtualPhysicalConnection", VirtualPhysicalConnectionArgs.builder()
 *             .virtualPhysicalConnectionName(name)
 *             .description(name)
 *             .orderMode("PayByPhysicalConnectionOwner")
 *             .parentPhysicalConnectionId(example.applyValue(getPhysicalConnectionsResult -> getPhysicalConnectionsResult.ids()[0]))
 *             .spec("50M")
 *             .vlanId(vlanId.id())
 *             .vpconnAliUid(default_.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   vlanId:
 *     type: random:integer
 *     name: vlan_id
 *     properties:
 *       max: 2999
 *       min: 1
 *   exampleVirtualPhysicalConnection:
 *     type: alicloud:expressconnect:VirtualPhysicalConnection
 *     name: example
 *     properties:
 *       virtualPhysicalConnectionName: ${name}
 *       description: ${name}
 *       orderMode: PayByPhysicalConnectionOwner
 *       parentPhysicalConnectionId: ${example.ids[0]}
 *       spec: 50M
 *       vlanId: ${vlanId.id}
 *       vpconnAliUid: ${default.id}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:expressconnect:getPhysicalConnections
 *       Arguments:
 *         nameRegex: ^preserved-NODELETING
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Express Connect Virtual Physical Connection can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:expressconnect/virtualPhysicalConnection:VirtualPhysicalConnection example <id>
 * ```
 */
public class VirtualPhysicalConnection internal constructor(
    override val javaResource: com.pulumi.alicloud.expressconnect.VirtualPhysicalConnection,
) : KotlinCustomResource(javaResource, VirtualPhysicalConnectionMapper) {
    /**
     * The ID of the access point of the physical connection.
     */
    public val accessPointId: Output<String>
        get() = javaResource.accessPointId().applyValue({ args0 -> args0 })

    /**
     * The physical location where the physical connection access device is located.
     */
    public val adLocation: Output<String>
        get() = javaResource.adLocation().applyValue({ args0 -> args0 })

    /**
     * The bandwidth of the physical connection. Unit: Mbps.
     */
    public val bandwidth: Output<String>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * The commercial status of the physical line. Value:-**Normal**: activated.-**Financialized**: Arrears locked.-**SecurityLocked**: locked for security reasons.
     */
    public val businessStatus: Output<String>
        get() = javaResource.businessStatus().applyValue({ args0 -> args0 })

    /**
     * The circuit code provided by the operator for the physical connection.
     */
    public val circuitCode: Output<String>
        get() = javaResource.circuitCode().applyValue({ args0 -> args0 })

    /**
     * The creation time of the resource
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The description of the physical connection.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to precheck the API request. Valid values: `true` and `false`.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The opening time of the physical connection.
     */
    public val enabledTime: Output<String>
        get() = javaResource.enabledTime().applyValue({ args0 -> args0 })

    /**
     * The expiration time of the shared line.Time is expressed according to ISO8601 standard and UTC time is used. The format is: YYYY-MM-DDThh:mm:ssZ.
     */
    public val endTime: Output<String>
        get() = javaResource.endTime().applyValue({ args0 -> args0 })

    /**
     * The estimated bandwidth value of the shared line. Valid values: `50M`, `100M`, `200M`, `300M`, `400M`, `500M`, `1G`, `2G`, `5G`, `8G`, and `10G`. **Note**: By default, the values of 2G, 5G, 8G, and 10G are unavailable. If you want to specify these values, contact your customer manager. Unit: **M** indicates Mbps, **G** indicates Gbps.
     */
    public val expectSpec: Output<String>?
        get() = javaResource.expectSpec().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Operators that provide access to physical lines. Value:-**CT**: China Telecom.-**CU**: China Unicom.-**CM**: China Mobile.-**CO**: China Other.-**Equinix**:Equinix.-**Other**: Other abroad.
     */
    public val lineOperator: Output<String>
        get() = javaResource.lineOperator().applyValue({ args0 -> args0 })

    /**
     * The state of LOA. Value:-**Applying**:LOA application.-**Accept**:LOA application passed.-**Available**:LOA is Available.-**Rejected**:LOA application Rejected.-**Completing**: The dedicated line is under construction.-**Complete**: The construction of the dedicated line is completed.-**Deleted**:LOA has been Deleted.
     */
    public val loaStatus: Output<String>
        get() = javaResource.loaStatus().applyValue({ args0 -> args0 })

    /**
     * The payment method of shared dedicated line. Value:
     * - **PayByPhysicalConnectionOwner**: indicates that the owner of the physical line associated with the shared line pays.
     * - **PayByVirtualPhysicalConnectionOwner**: indicates that the owner of the shared line pays.
     */
    public val orderMode: Output<String>
        get() = javaResource.orderMode().applyValue({ args0 -> args0 })

    /**
     * The ID of the Alibaba Cloud account (primary account) to which the physical connection belongs.
     */
    public val parentPhysicalConnectionAliUid: Output<String>
        get() = javaResource.parentPhysicalConnectionAliUid().applyValue({ args0 -> args0 })

    /**
     * The ID of the instance of the physical connection.
     */
    public val parentPhysicalConnectionId: Output<String>
        get() = javaResource.parentPhysicalConnectionId().applyValue({ args0 -> args0 })

    /**
     * The geographic location of the local data center.
     */
    public val peerLocation: Output<String>
        get() = javaResource.peerLocation().applyValue({ args0 -> args0 })

    /**
     * The port number of the physical connection device.
     */
    public val portNumber: Output<String>
        get() = javaResource.portNumber().applyValue({ args0 -> args0 })

    /**
     * Physical connection port type. Value:-**100Base-T**: 100 megabytes port.-**1000Base-T**: Gigabit port.-**1000Base-LX**: Gigabit single mode optical port (10km).-**10GBase-T**: 10 Gigabit port.-**10GBase-LR**: 10 Gigabit single mode optical port (10km).-**40GBase-LR**: 40 megabytes single-mode optical port.-**100GBase-LR**: 100,000 megabytes single-mode optical port.
     */
    public val portType: Output<String>
        get() = javaResource.portType().applyValue({ args0 -> args0 })

    /**
     * The ID of the redundant physical connection.
     */
    public val redundantPhysicalConnectionId: Output<String>
        get() = javaResource.redundantPhysicalConnectionId().applyValue({ args0 -> args0 })

    /**
     * The resource group id.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The bandwidth value of the shared line. Valid values: `50M`, `100M`, `200M`, `300M`, `400M`, `500M`, `1G`, `2G`, `5G`, `8G`, and `10G`. **Note**: By default, the values of 2G, 5G, 8G, and 10G are unavailable. If you want to specify these values, contact your customer manager. Unit: **M** indicates Mbps, **G** indicates Gbps.
     */
    public val spec: Output<String>
        get() = javaResource.spec().applyValue({ args0 -> args0 })

    /**
     * The status of the resource
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The name of the physical connection.
     */
    public val virtualPhysicalConnectionName: Output<String>?
        get() = javaResource.virtualPhysicalConnectionName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The business status of the shared line. Value:-**Confirmed**: The shared line has been Confirmed to receive.-**UnConfirmed**: The shared line has not been confirmed to be received.-**Deleted**: The shared line has been Deleted.
     */
    public val virtualPhysicalConnectionStatus: Output<String>
        get() = javaResource.virtualPhysicalConnectionStatus().applyValue({ args0 -> args0 })

    /**
     * The VLAN ID of the shared leased line. Valid values: `0` to `2999`.
     */
    public val vlanId: Output<Int>
        get() = javaResource.vlanId().applyValue({ args0 -> args0 })

    /**
     * The ID of the Alibaba Cloud account (primary account) of the owner of the shared line.
     */
    public val vpconnAliUid: Output<String>
        get() = javaResource.vpconnAliUid().applyValue({ args0 -> args0 })
}

public object VirtualPhysicalConnectionMapper : ResourceMapper<VirtualPhysicalConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.expressconnect.VirtualPhysicalConnection::class == javaResource::class

    override fun map(javaResource: Resource): VirtualPhysicalConnection =
        VirtualPhysicalConnection(
            javaResource as
                com.pulumi.alicloud.expressconnect.VirtualPhysicalConnection,
        )
}

/**
 * @see [VirtualPhysicalConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualPhysicalConnection].
 */
public suspend fun virtualPhysicalConnection(
    name: String,
    block: suspend VirtualPhysicalConnectionResourceBuilder.() -> Unit,
): VirtualPhysicalConnection {
    val builder = VirtualPhysicalConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualPhysicalConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualPhysicalConnection(name: String): VirtualPhysicalConnection {
    val builder = VirtualPhysicalConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
