@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin

import com.pulumi.alicloud.expressconnect.VirtualPhysicalConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Express Connect Virtual Physical Connection resource.
 * For information about Express Connect Virtual Physical Connection and how to use it, see [What is Virtual Physical Connection](https://www.alibabacloud.com/help/en/express-connect/latest/createvirtualphysicalconnection#doc-api-Vpc-CreateVirtualPhysicalConnection).
 * > **NOTE:** Available since v1.196.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = alicloud.expressconnect.getPhysicalConnections({
 *     nameRegex: "^preserved-NODELETING",
 * });
 * const vlanId = new random.index.Integer("vlan_id", {
 *     max: 2999,
 *     min: 1,
 * });
 * const default = alicloud.getAccount({});
 * const exampleVirtualPhysicalConnection = new alicloud.expressconnect.VirtualPhysicalConnection("example", {
 *     virtualPhysicalConnectionName: name,
 *     description: name,
 *     orderMode: "PayByPhysicalConnectionOwner",
 *     parentPhysicalConnectionId: example.then(example => example.ids?.[0]),
 *     spec: "50M",
 *     vlanId: vlanId.id,
 *     vpconnAliUid: _default.then(_default => _default.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.expressconnect.get_physical_connections(name_regex="^preserved-NODELETING")
 * vlan_id = random.index.Integer("vlan_id",
 *     max=2999,
 *     min=1)
 * default = alicloud.get_account()
 * example_virtual_physical_connection = alicloud.expressconnect.VirtualPhysicalConnection("example",
 *     virtual_physical_connection_name=name,
 *     description=name,
 *     order_mode="PayByPhysicalConnectionOwner",
 *     parent_physical_connection_id=example.ids[0],
 *     spec="50M",
 *     vlan_id=vlan_id["id"],
 *     vpconn_ali_uid=default.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = AliCloud.ExpressConnect.GetPhysicalConnections.Invoke(new()
 *     {
 *         NameRegex = "^preserved-NODELETING",
 *     });
 *     var vlanId = new Random.Index.Integer("vlan_id", new()
 *     {
 *         Max = 2999,
 *         Min = 1,
 *     });
 *     var @default = AliCloud.GetAccount.Invoke();
 *     var exampleVirtualPhysicalConnection = new AliCloud.ExpressConnect.VirtualPhysicalConnection("example", new()
 *     {
 *         VirtualPhysicalConnectionName = name,
 *         Description = name,
 *         OrderMode = "PayByPhysicalConnectionOwner",
 *         ParentPhysicalConnectionId = example.Apply(getPhysicalConnectionsResult => getPhysicalConnectionsResult.Ids[0]),
 *         Spec = "50M",
 *         VlanId = vlanId.Id,
 *         VpconnAliUid = @default.Apply(@default => @default.Apply(getAccountResult => getAccountResult.Id)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		example, err := expressconnect.GetPhysicalConnections(ctx, &expressconnect.GetPhysicalConnectionsArgs{
 * 			NameRegex: pulumi.StringRef("^preserved-NODELETING"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		vlanId, err := random.NewInteger(ctx, "vlan_id", &random.IntegerArgs{
 * 			Max: 2999,
 * 			Min: 1,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = expressconnect.NewVirtualPhysicalConnection(ctx, "example", &expressconnect.VirtualPhysicalConnectionArgs{
 * 			VirtualPhysicalConnectionName: pulumi.String(name),
 * 			Description:                   pulumi.String(name),
 * 			OrderMode:                     pulumi.String("PayByPhysicalConnectionOwner"),
 * 			ParentPhysicalConnectionId:    pulumi.String(example.Ids[0]),
 * 			Spec:                          pulumi.String("50M"),
 * 			VlanId:                        vlanId.Id,
 * 			VpconnAliUid:                  pulumi.String(_default.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions;
 * import com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionsArgs;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.expressconnect.VirtualPhysicalConnection;
 * import com.pulumi.alicloud.expressconnect.VirtualPhysicalConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var example = ExpressconnectFunctions.getPhysicalConnections(GetPhysicalConnectionsArgs.builder()
 *             .nameRegex("^preserved-NODELETING")
 *             .build());
 *         var vlanId = new Integer("vlanId", IntegerArgs.builder()
 *             .max(2999)
 *             .min(1)
 *             .build());
 *         final var default = AlicloudFunctions.getAccount();
 *         var exampleVirtualPhysicalConnection = new VirtualPhysicalConnection("exampleVirtualPhysicalConnection", VirtualPhysicalConnectionArgs.builder()
 *             .virtualPhysicalConnectionName(name)
 *             .description(name)
 *             .orderMode("PayByPhysicalConnectionOwner")
 *             .parentPhysicalConnectionId(example.applyValue(getPhysicalConnectionsResult -> getPhysicalConnectionsResult.ids()[0]))
 *             .spec("50M")
 *             .vlanId(vlanId.id())
 *             .vpconnAliUid(default_.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   vlanId:
 *     type: random:integer
 *     name: vlan_id
 *     properties:
 *       max: 2999
 *       min: 1
 *   exampleVirtualPhysicalConnection:
 *     type: alicloud:expressconnect:VirtualPhysicalConnection
 *     name: example
 *     properties:
 *       virtualPhysicalConnectionName: ${name}
 *       description: ${name}
 *       orderMode: PayByPhysicalConnectionOwner
 *       parentPhysicalConnectionId: ${example.ids[0]}
 *       spec: 50M
 *       vlanId: ${vlanId.id}
 *       vpconnAliUid: ${default.id}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:expressconnect:getPhysicalConnections
 *       Arguments:
 *         nameRegex: ^preserved-NODELETING
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Express Connect Virtual Physical Connection can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:expressconnect/virtualPhysicalConnection:VirtualPhysicalConnection example <id>
 * ```
 * @property description The description of the physical connection.
 * @property dryRun Specifies whether to precheck the API request. Valid values: `true` and `false`.
 * @property expectSpec The estimated bandwidth value of the shared line. Valid values: `50M`, `100M`, `200M`, `300M`, `400M`, `500M`, `1G`, `2G`, `5G`, `8G`, and `10G`. **Note**: By default, the values of 2G, 5G, 8G, and 10G are unavailable. If you want to specify these values, contact your customer manager. Unit: **M** indicates Mbps, **G** indicates Gbps.
 * @property orderMode The payment method of shared dedicated line. Value:
 * - **PayByPhysicalConnectionOwner**: indicates that the owner of the physical line associated with the shared line pays.
 * - **PayByVirtualPhysicalConnectionOwner**: indicates that the owner of the shared line pays.
 * @property parentPhysicalConnectionId The ID of the instance of the physical connection.
 * @property resourceGroupId The resource group id.
 * @property spec The bandwidth value of the shared line. Valid values: `50M`, `100M`, `200M`, `300M`, `400M`, `500M`, `1G`, `2G`, `5G`, `8G`, and `10G`. **Note**: By default, the values of 2G, 5G, 8G, and 10G are unavailable. If you want to specify these values, contact your customer manager. Unit: **M** indicates Mbps, **G** indicates Gbps.
 * @property virtualPhysicalConnectionName The name of the physical connection.
 * @property vlanId The VLAN ID of the shared leased line. Valid values: `0` to `2999`.
 * @property vpconnAliUid The ID of the Alibaba Cloud account (primary account) of the owner of the shared line.
 */
public data class VirtualPhysicalConnectionArgs(
    public val description: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val expectSpec: Output<String>? = null,
    public val orderMode: Output<String>? = null,
    public val parentPhysicalConnectionId: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val spec: Output<String>? = null,
    public val virtualPhysicalConnectionName: Output<String>? = null,
    public val vlanId: Output<Int>? = null,
    public val vpconnAliUid: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.expressconnect.VirtualPhysicalConnectionArgs> {
    override fun toJava(): com.pulumi.alicloud.expressconnect.VirtualPhysicalConnectionArgs =
        com.pulumi.alicloud.expressconnect.VirtualPhysicalConnectionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .expectSpec(expectSpec?.applyValue({ args0 -> args0 }))
            .orderMode(orderMode?.applyValue({ args0 -> args0 }))
            .parentPhysicalConnectionId(parentPhysicalConnectionId?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .spec(spec?.applyValue({ args0 -> args0 }))
            .virtualPhysicalConnectionName(virtualPhysicalConnectionName?.applyValue({ args0 -> args0 }))
            .vlanId(vlanId?.applyValue({ args0 -> args0 }))
            .vpconnAliUid(vpconnAliUid?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualPhysicalConnectionArgs].
 */
@PulumiTagMarker
public class VirtualPhysicalConnectionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var expectSpec: Output<String>? = null

    private var orderMode: Output<String>? = null

    private var parentPhysicalConnectionId: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var spec: Output<String>? = null

    private var virtualPhysicalConnectionName: Output<String>? = null

    private var vlanId: Output<Int>? = null

    private var vpconnAliUid: Output<String>? = null

    /**
     * @param value The description of the physical connection.
     */
    @JvmName("veiobcwgvellatca")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies whether to precheck the API request. Valid values: `true` and `false`.
     */
    @JvmName("sssywwiyokwmakgw")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The estimated bandwidth value of the shared line. Valid values: `50M`, `100M`, `200M`, `300M`, `400M`, `500M`, `1G`, `2G`, `5G`, `8G`, and `10G`. **Note**: By default, the values of 2G, 5G, 8G, and 10G are unavailable. If you want to specify these values, contact your customer manager. Unit: **M** indicates Mbps, **G** indicates Gbps.
     */
    @JvmName("pfivoytmjcujliyb")
    public suspend fun expectSpec(`value`: Output<String>) {
        this.expectSpec = value
    }

    /**
     * @param value The payment method of shared dedicated line. Value:
     * - **PayByPhysicalConnectionOwner**: indicates that the owner of the physical line associated with the shared line pays.
     * - **PayByVirtualPhysicalConnectionOwner**: indicates that the owner of the shared line pays.
     */
    @JvmName("obxhkeobupnfcknt")
    public suspend fun orderMode(`value`: Output<String>) {
        this.orderMode = value
    }

    /**
     * @param value The ID of the instance of the physical connection.
     */
    @JvmName("hlnchxosyihmxbmt")
    public suspend fun parentPhysicalConnectionId(`value`: Output<String>) {
        this.parentPhysicalConnectionId = value
    }

    /**
     * @param value The resource group id.
     */
    @JvmName("wxckdnejgxainjmq")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The bandwidth value of the shared line. Valid values: `50M`, `100M`, `200M`, `300M`, `400M`, `500M`, `1G`, `2G`, `5G`, `8G`, and `10G`. **Note**: By default, the values of 2G, 5G, 8G, and 10G are unavailable. If you want to specify these values, contact your customer manager. Unit: **M** indicates Mbps, **G** indicates Gbps.
     */
    @JvmName("dysjjbrqjeqwurvf")
    public suspend fun spec(`value`: Output<String>) {
        this.spec = value
    }

    /**
     * @param value The name of the physical connection.
     */
    @JvmName("deephboyiggaldhs")
    public suspend fun virtualPhysicalConnectionName(`value`: Output<String>) {
        this.virtualPhysicalConnectionName = value
    }

    /**
     * @param value The VLAN ID of the shared leased line. Valid values: `0` to `2999`.
     */
    @JvmName("oqupaneksiegjofv")
    public suspend fun vlanId(`value`: Output<Int>) {
        this.vlanId = value
    }

    /**
     * @param value The ID of the Alibaba Cloud account (primary account) of the owner of the shared line.
     */
    @JvmName("ubctqsnseitrnagk")
    public suspend fun vpconnAliUid(`value`: Output<String>) {
        this.vpconnAliUid = value
    }

    /**
     * @param value The description of the physical connection.
     */
    @JvmName("fglemhdkwhmelcvp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies whether to precheck the API request. Valid values: `true` and `false`.
     */
    @JvmName("deaxgpjrwkpjqkvr")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The estimated bandwidth value of the shared line. Valid values: `50M`, `100M`, `200M`, `300M`, `400M`, `500M`, `1G`, `2G`, `5G`, `8G`, and `10G`. **Note**: By default, the values of 2G, 5G, 8G, and 10G are unavailable. If you want to specify these values, contact your customer manager. Unit: **M** indicates Mbps, **G** indicates Gbps.
     */
    @JvmName("daokqowkukggldyx")
    public suspend fun expectSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expectSpec = mapped
    }

    /**
     * @param value The payment method of shared dedicated line. Value:
     * - **PayByPhysicalConnectionOwner**: indicates that the owner of the physical line associated with the shared line pays.
     * - **PayByVirtualPhysicalConnectionOwner**: indicates that the owner of the shared line pays.
     */
    @JvmName("waqurpnioeiadnvc")
    public suspend fun orderMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orderMode = mapped
    }

    /**
     * @param value The ID of the instance of the physical connection.
     */
    @JvmName("hkydqkwswcmjtyin")
    public suspend fun parentPhysicalConnectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentPhysicalConnectionId = mapped
    }

    /**
     * @param value The resource group id.
     */
    @JvmName("frbeccomdhkhkafe")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The bandwidth value of the shared line. Valid values: `50M`, `100M`, `200M`, `300M`, `400M`, `500M`, `1G`, `2G`, `5G`, `8G`, and `10G`. **Note**: By default, the values of 2G, 5G, 8G, and 10G are unavailable. If you want to specify these values, contact your customer manager. Unit: **M** indicates Mbps, **G** indicates Gbps.
     */
    @JvmName("gbrtmqyluvkssfrj")
    public suspend fun spec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spec = mapped
    }

    /**
     * @param value The name of the physical connection.
     */
    @JvmName("kkealttknjkujmrr")
    public suspend fun virtualPhysicalConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualPhysicalConnectionName = mapped
    }

    /**
     * @param value The VLAN ID of the shared leased line. Valid values: `0` to `2999`.
     */
    @JvmName("iivofuxjdiqvqiuq")
    public suspend fun vlanId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlanId = mapped
    }

    /**
     * @param value The ID of the Alibaba Cloud account (primary account) of the owner of the shared line.
     */
    @JvmName("bxkoxwnbmmthepuj")
    public suspend fun vpconnAliUid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpconnAliUid = mapped
    }

    internal fun build(): VirtualPhysicalConnectionArgs = VirtualPhysicalConnectionArgs(
        description = description,
        dryRun = dryRun,
        expectSpec = expectSpec,
        orderMode = orderMode,
        parentPhysicalConnectionId = parentPhysicalConnectionId,
        resourceGroupId = resourceGroupId,
        spec = spec,
        virtualPhysicalConnectionName = virtualPhysicalConnectionName,
        vlanId = vlanId,
        vpconnAliUid = vpconnAliUid,
    )
}
