@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.inputs

import com.pulumi.alicloud.expressconnect.inputs.GetAccessPointsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAccessPoints.
 * @property ids A list of Access Point IDs.
 * @property nameRegex A regex string to filter results by Access Point name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The Physical Connection to Which the Access Point State. Valid values: `disabled`, `full`, `hot`, `recommended`.
 */
public data class GetAccessPointsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.expressconnect.inputs.GetAccessPointsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.expressconnect.inputs.GetAccessPointsPlainArgs =
        com.pulumi.alicloud.expressconnect.inputs.GetAccessPointsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccessPointsPlainArgs].
 */
@PulumiTagMarker
public class GetAccessPointsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value A list of Access Point IDs.
     */
    @JvmName("rnutmicxsdbaadee")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Access Point IDs.
     */
    @JvmName("uewiuhqqalyrigsm")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Access Point name.
     */
    @JvmName("wdcdbykgcfbpgcmr")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("osftfmlboxoujwuo")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The Physical Connection to Which the Access Point State. Valid values: `disabled`, `full`, `hot`, `recommended`.
     */
    @JvmName("pheyybljxowddoie")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetAccessPointsPlainArgs = GetAccessPointsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
