@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.inputs

import com.pulumi.alicloud.expressconnect.inputs.GetGrantRuleToCensPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGrantRuleToCens.
 * @property ids A list of Grant Rule To Cen IDs.
 * @property instanceId The ID of the VBR.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 */
public data class GetGrantRuleToCensPlainArgs(
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.expressconnect.inputs.GetGrantRuleToCensPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.expressconnect.inputs.GetGrantRuleToCensPlainArgs =
        com.pulumi.alicloud.expressconnect.inputs.GetGrantRuleToCensPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGrantRuleToCensPlainArgs].
 */
@PulumiTagMarker
public class GetGrantRuleToCensPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    /**
     * @param value A list of Grant Rule To Cen IDs.
     */
    @JvmName("jfjhpfvudulndmjr")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Grant Rule To Cen IDs.
     */
    @JvmName("ngrafypwxonscbqt")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the VBR.
     */
    @JvmName("wvgnefuvrebviboh")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("qkymgrrchyonibih")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("yhmlkselhckdcmri")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("vjyxigijnionplmq")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    internal fun build(): GetGrantRuleToCensPlainArgs = GetGrantRuleToCensPlainArgs(
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
    )
}
