@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.inputs

import com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPhysicalConnectionService.
 * @property enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
 * > **NOTE:** Setting `enable = "On"` to enable outbound traffic for an Express Connect circuit that means you have read and agreed the [Express Connect Terms of Service](https://terms.aliyun.com/legal-agreement/terms/suit_bu1_ali_cloud/suit_bu1_ali_cloud201803060947_16271.html). The service can not closed once it is opened.
 */
public data class GetPhysicalConnectionServicePlainArgs(
    public val enable: String? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionServicePlainArgs> {
    override fun toJava(): com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionServicePlainArgs =
        com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionServicePlainArgs.builder()
            .enable(enable?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPhysicalConnectionServicePlainArgs].
 */
@PulumiTagMarker
public class GetPhysicalConnectionServicePlainArgsBuilder internal constructor() {
    private var enable: String? = null

    /**
     * @param value Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
     * > **NOTE:** Setting `enable = "On"` to enable outbound traffic for an Express Connect circuit that means you have read and agreed the [Express Connect Terms of Service](https://terms.aliyun.com/legal-agreement/terms/suit_bu1_ali_cloud/suit_bu1_ali_cloud201803060947_16271.html). The service can not closed once it is opened.
     */
    @JvmName("fhqfhumpdynjsguf")
    public suspend fun enable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enable = mapped
    }

    internal fun build(): GetPhysicalConnectionServicePlainArgs =
        GetPhysicalConnectionServicePlainArgs(
            enable = enable,
        )
}
