@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.inputs

import com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPhysicalConnections.
 * @property ids A list of Physical Connection IDs.
 * @property includeReservationData The include reservation data.
 * @property nameRegex A regex string to filter results by Physical Connection name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status Resources on Behalf of a State of the Resource Attribute Field. Valid values: `Canceled`, `Enabled`, `Terminated`.
 */
public data class GetPhysicalConnectionsPlainArgs(
    public val ids: List<String>? = null,
    public val includeReservationData: Boolean? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionsPlainArgs =
        com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .includeReservationData(includeReservationData?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPhysicalConnectionsPlainArgs].
 */
@PulumiTagMarker
public class GetPhysicalConnectionsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var includeReservationData: Boolean? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value A list of Physical Connection IDs.
     */
    @JvmName("gwvwjjqyppimqbqg")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Physical Connection IDs.
     */
    @JvmName("ctkvkhvcpgeqcjsl")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The include reservation data.
     */
    @JvmName("rctqbhpwrnpplrhc")
    public suspend fun includeReservationData(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeReservationData = mapped
    }

    /**
     * @param value A regex string to filter results by Physical Connection name.
     */
    @JvmName("bolvutbryafqnbej")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ifurlhfyhkwdnibt")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Resources on Behalf of a State of the Resource Attribute Field. Valid values: `Canceled`, `Enabled`, `Terminated`.
     */
    @JvmName("ogmmnkmwkluybuwk")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetPhysicalConnectionsPlainArgs = GetPhysicalConnectionsPlainArgs(
        ids = ids,
        includeReservationData = includeReservationData,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
