@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.inputs

import com.pulumi.alicloud.expressconnect.inputs.GetRouterInterfacesFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property key
 * @property values
 */
public data class GetRouterInterfacesFilter(
    public val key: String? = null,
    public val values: List<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.expressconnect.inputs.GetRouterInterfacesFilter> {
    override fun toJava(): com.pulumi.alicloud.expressconnect.inputs.GetRouterInterfacesFilter =
        com.pulumi.alicloud.expressconnect.inputs.GetRouterInterfacesFilter.builder()
            .key(key?.let({ args0 -> args0 }))
            .values(values?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetRouterInterfacesFilter].
 */
@PulumiTagMarker
public class GetRouterInterfacesFilterBuilder internal constructor() {
    private var key: String? = null

    private var values: List<String>? = null

    /**
     * @param value
     */
    @JvmName("irroryswpqpclogm")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.key = mapped
    }

    /**
     * @param value
     */
    @JvmName("bbphicuomroehtjk")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values
     */
    @JvmName("enwhdsqcjftmscjq")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): GetRouterInterfacesFilter = GetRouterInterfacesFilter(
        key = key,
        values = values,
    )
}
