@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.inputs

import com.pulumi.alicloud.expressconnect.inputs.GetRouterInterfacesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRouterInterfaces.
 * @property filters
 * @property ids A list of Router Interface IDs.
 * @property includeReservationData Does it contain renewal data. Valid values: `true`, `false`.
 * @property nameRegex A regex string to filter results by Group Metric Rule name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 */
public data class GetRouterInterfacesPlainArgs(
    public val filters: List<GetRouterInterfacesFilter>? = null,
    public val ids: List<String>? = null,
    public val includeReservationData: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.expressconnect.inputs.GetRouterInterfacesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.expressconnect.inputs.GetRouterInterfacesPlainArgs =
        com.pulumi.alicloud.expressconnect.inputs.GetRouterInterfacesPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .includeReservationData(includeReservationData?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRouterInterfacesPlainArgs].
 */
@PulumiTagMarker
public class GetRouterInterfacesPlainArgsBuilder internal constructor() {
    private var filters: List<GetRouterInterfacesFilter>? = null

    private var ids: List<String>? = null

    private var includeReservationData: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    /**
     * @param value
     */
    @JvmName("xfukbfacbyhjbojn")
    public suspend fun filters(`value`: List<GetRouterInterfacesFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wwqatnavdyhcjdry")
    public suspend fun filters(argument: List<suspend GetRouterInterfacesFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetRouterInterfacesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yerdweddchayqkop")
    public suspend fun filters(vararg argument: suspend GetRouterInterfacesFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetRouterInterfacesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("psjnxsavdwelrusb")
    public suspend fun filters(argument: suspend GetRouterInterfacesFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetRouterInterfacesFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values
     */
    @JvmName("sxahmyuxservphcx")
    public suspend fun filters(vararg values: GetRouterInterfacesFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value A list of Router Interface IDs.
     */
    @JvmName("hedbowutfwsfghtu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Router Interface IDs.
     */
    @JvmName("fpddpblmmfnempwu")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Does it contain renewal data. Valid values: `true`, `false`.
     */
    @JvmName("gbhcbpvjrdnsjujq")
    public suspend fun includeReservationData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeReservationData = mapped
    }

    /**
     * @param value A regex string to filter results by Group Metric Rule name.
     */
    @JvmName("rbeercyjiqtwokkt")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("crqiwoynxdvmjbcw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("qvkcewwhfdcyhtbn")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("twncrscrlqlmuiah")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    internal fun build(): GetRouterInterfacesPlainArgs = GetRouterInterfacesPlainArgs(
        filters = filters,
        ids = ids,
        includeReservationData = includeReservationData,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
    )
}
