@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.inputs

import com.pulumi.alicloud.expressconnect.inputs.GetVbrPconnAssociationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVbrPconnAssociations.
 * @property ids A list of Vbr Pconn Association IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property vbrId The ID of the VBR instance.
 */
public data class GetVbrPconnAssociationsPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val vbrId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.expressconnect.inputs.GetVbrPconnAssociationsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.expressconnect.inputs.GetVbrPconnAssociationsPlainArgs = com.pulumi.alicloud.expressconnect.inputs.GetVbrPconnAssociationsPlainArgs.builder()
        .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
        .outputFile(outputFile?.let({ args0 -> args0 }))
        .pageNumber(pageNumber?.let({ args0 -> args0 }))
        .pageSize(pageSize?.let({ args0 -> args0 }))
        .vbrId(vbrId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVbrPconnAssociationsPlainArgs].
 */
@PulumiTagMarker
public class GetVbrPconnAssociationsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var vbrId: String? = null

    /**
     * @param value A list of Vbr Pconn Association IDs.
     */
    @JvmName("ibkrsaompexdqvcp")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Vbr Pconn Association IDs.
     */
    @JvmName("igyjgoxaismdxskd")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ssptenpjxcncwgyt")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("gxvkovsnjsthtfkl")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("yfijyiyyelhomclq")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The ID of the VBR instance.
     */
    @JvmName("gojmvnklbgkqafrk")
    public suspend fun vbrId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vbrId = mapped
    }

    internal fun build(): GetVbrPconnAssociationsPlainArgs = GetVbrPconnAssociationsPlainArgs(
        ids = ids,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        vbrId = vbrId,
    )
}
