@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.inputs

import com.pulumi.alicloud.expressconnect.inputs.GetVirtualBorderRoutersFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property key The key of the field to filter by, as defined by
 * [Alibaba Cloud API](https://www.alibabacloud.com/help/en/doc-detail/124791.htm).
 * @property values Set of values that are accepted for the given field.
 */
public data class GetVirtualBorderRoutersFilter(
    public val key: String? = null,
    public val values: List<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.expressconnect.inputs.GetVirtualBorderRoutersFilter> {
    override fun toJava(): com.pulumi.alicloud.expressconnect.inputs.GetVirtualBorderRoutersFilter =
        com.pulumi.alicloud.expressconnect.inputs.GetVirtualBorderRoutersFilter.builder()
            .key(key?.let({ args0 -> args0 }))
            .values(values?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetVirtualBorderRoutersFilter].
 */
@PulumiTagMarker
public class GetVirtualBorderRoutersFilterBuilder internal constructor() {
    private var key: String? = null

    private var values: List<String>? = null

    /**
     * @param value The key of the field to filter by, as defined by
     * [Alibaba Cloud API](https://www.alibabacloud.com/help/en/doc-detail/124791.htm).
     */
    @JvmName("owfetycjptvwpqrf")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.key = mapped
    }

    /**
     * @param value Set of values that are accepted for the given field.
     */
    @JvmName("arfsxvaovsmdbgff")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values Set of values that are accepted for the given field.
     */
    @JvmName("glyldjebnxkxkmjp")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): GetVirtualBorderRoutersFilter = GetVirtualBorderRoutersFilter(
        key = key,
        values = values,
    )
}
