@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.inputs

import com.pulumi.alicloud.expressconnect.inputs.GetVirtualBorderRoutersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVirtualBorderRouters.
 * @property filters Custom filter block as described below.
 * @property ids A list of Virtual Border Router IDs.
 * @property nameRegex A regex string to filter results by Virtual Border Router name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The instance state with. Valid values: `active`, `deleting`, `recovering`, `terminated`, `terminating`, `unconfirmed`.
 */
public data class GetVirtualBorderRoutersPlainArgs(
    public val filters: List<GetVirtualBorderRoutersFilter>? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.expressconnect.inputs.GetVirtualBorderRoutersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.expressconnect.inputs.GetVirtualBorderRoutersPlainArgs = com.pulumi.alicloud.expressconnect.inputs.GetVirtualBorderRoutersPlainArgs.builder()
        .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
        .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
        .nameRegex(nameRegex?.let({ args0 -> args0 }))
        .outputFile(outputFile?.let({ args0 -> args0 }))
        .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualBorderRoutersPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualBorderRoutersPlainArgsBuilder internal constructor() {
    private var filters: List<GetVirtualBorderRoutersFilter>? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("jxalirchfkqbevbn")
    public suspend fun filters(`value`: List<GetVirtualBorderRoutersFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("borxhcmydahqynab")
    public suspend fun filters(argument: List<suspend GetVirtualBorderRoutersFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetVirtualBorderRoutersFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("smkxwvalgaegaoev")
    public suspend fun filters(vararg argument: suspend GetVirtualBorderRoutersFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetVirtualBorderRoutersFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("oejrnhgeguhaxhdc")
    public suspend fun filters(argument: suspend GetVirtualBorderRoutersFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetVirtualBorderRoutersFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("gwybopmxplibneuk")
    public suspend fun filters(vararg values: GetVirtualBorderRoutersFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value A list of Virtual Border Router IDs.
     */
    @JvmName("hgjcctimoxjggfdl")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Virtual Border Router IDs.
     */
    @JvmName("vpynqhjxjidpokyq")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Virtual Border Router name.
     */
    @JvmName("vgpicdqlpladqmqt")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("aqatontqsulxibqt")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The instance state with. Valid values: `active`, `deleting`, `recovering`, `terminated`, `terminating`, `unconfirmed`.
     */
    @JvmName("qieskmwporxoiheb")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetVirtualBorderRoutersPlainArgs = GetVirtualBorderRoutersPlainArgs(
        filters = filters,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
