@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.inputs

import com.pulumi.alicloud.expressconnect.inputs.GetVirtualPhysicalConnectionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVirtualPhysicalConnections.
 * @property businessStatus The commercial status of the physical line. Value:
 * - **Normal**: activated.
 * - **Financialized**: Arrears locked.
 * - **SecurityLocked**: locked for security reasons.
 * @property ids A list of Virtual Physical Connection IDs.
 * @property isConfirmed
 * @property nameRegex A regex string to filter results by Group Metric Rule name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property parentPhysicalConnectionId The ID of the instance of the physical connection.
 * @property virtualPhysicalConnectionIds The ID of the hosted connection. You can specify multiple hosted connection IDs.
 * @property virtualPhysicalConnectionStatus The business status of the shared line. Value:
 * - **Confirmed**: The shared line has been Confirmed to receive.
 * - **UnConfirmed**: The shared line has not been confirmed to be received.
 * - **Deleted**: The shared line has been Deleted.
 * @property vlanIds The VLAN ID of the hosted connection. You can specify multiple VLAN IDs.
 * @property vpconnAliUid The ID of the Alibaba Cloud account (primary account) of the owner of the shared line.
 */
public data class GetVirtualPhysicalConnectionsPlainArgs(
    public val businessStatus: String? = null,
    public val ids: List<String>? = null,
    public val isConfirmed: Boolean? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val parentPhysicalConnectionId: String? = null,
    public val virtualPhysicalConnectionIds: List<String>? = null,
    public val virtualPhysicalConnectionStatus: String? = null,
    public val vlanIds: List<Int>? = null,
    public val vpconnAliUid: String? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.expressconnect.inputs.GetVirtualPhysicalConnectionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.expressconnect.inputs.GetVirtualPhysicalConnectionsPlainArgs =
        com.pulumi.alicloud.expressconnect.inputs.GetVirtualPhysicalConnectionsPlainArgs.builder()
            .businessStatus(businessStatus?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .isConfirmed(isConfirmed?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .parentPhysicalConnectionId(parentPhysicalConnectionId?.let({ args0 -> args0 }))
            .virtualPhysicalConnectionIds(
                virtualPhysicalConnectionIds?.let({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .virtualPhysicalConnectionStatus(virtualPhysicalConnectionStatus?.let({ args0 -> args0 }))
            .vlanIds(vlanIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpconnAliUid(vpconnAliUid?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualPhysicalConnectionsPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualPhysicalConnectionsPlainArgsBuilder internal constructor() {
    private var businessStatus: String? = null

    private var ids: List<String>? = null

    private var isConfirmed: Boolean? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var parentPhysicalConnectionId: String? = null

    private var virtualPhysicalConnectionIds: List<String>? = null

    private var virtualPhysicalConnectionStatus: String? = null

    private var vlanIds: List<Int>? = null

    private var vpconnAliUid: String? = null

    /**
     * @param value The commercial status of the physical line. Value:
     * - **Normal**: activated.
     * - **Financialized**: Arrears locked.
     * - **SecurityLocked**: locked for security reasons.
     */
    @JvmName("txeoiwyiqlkksool")
    public suspend fun businessStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.businessStatus = mapped
    }

    /**
     * @param value A list of Virtual Physical Connection IDs.
     */
    @JvmName("suvmebxtvmarobsl")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Virtual Physical Connection IDs.
     */
    @JvmName("gcpdecbnfkpfytbj")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("xvdmokwrqjgdgrwi")
    public suspend fun isConfirmed(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.isConfirmed = mapped
    }

    /**
     * @param value A regex string to filter results by Group Metric Rule name.
     */
    @JvmName("dwwwtytjlxhfohdr")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("wxgqcyjtmdkyaaqb")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the instance of the physical connection.
     */
    @JvmName("aqbydyifylegswsu")
    public suspend fun parentPhysicalConnectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.parentPhysicalConnectionId = mapped
    }

    /**
     * @param value The ID of the hosted connection. You can specify multiple hosted connection IDs.
     */
    @JvmName("asoeprnrakrmbjmb")
    public suspend fun virtualPhysicalConnectionIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.virtualPhysicalConnectionIds = mapped
    }

    /**
     * @param values The ID of the hosted connection. You can specify multiple hosted connection IDs.
     */
    @JvmName("pfxfoovrwbkjickk")
    public suspend fun virtualPhysicalConnectionIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualPhysicalConnectionIds = mapped
    }

    /**
     * @param value The business status of the shared line. Value:
     * - **Confirmed**: The shared line has been Confirmed to receive.
     * - **UnConfirmed**: The shared line has not been confirmed to be received.
     * - **Deleted**: The shared line has been Deleted.
     */
    @JvmName("eshijcoslxidopdf")
    public suspend fun virtualPhysicalConnectionStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.virtualPhysicalConnectionStatus = mapped
    }

    /**
     * @param value The VLAN ID of the hosted connection. You can specify multiple VLAN IDs.
     */
    @JvmName("nlbuwaodnxjgfxym")
    public suspend fun vlanIds(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vlanIds = mapped
    }

    /**
     * @param values The VLAN ID of the hosted connection. You can specify multiple VLAN IDs.
     */
    @JvmName("ctsrgwekpvwjjlet")
    public suspend fun vlanIds(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vlanIds = mapped
    }

    /**
     * @param value The ID of the Alibaba Cloud account (primary account) of the owner of the shared line.
     */
    @JvmName("mujobdecdefhencm")
    public suspend fun vpconnAliUid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpconnAliUid = mapped
    }

    internal fun build(): GetVirtualPhysicalConnectionsPlainArgs =
        GetVirtualPhysicalConnectionsPlainArgs(
            businessStatus = businessStatus,
            ids = ids,
            isConfirmed = isConfirmed,
            nameRegex = nameRegex,
            outputFile = outputFile,
            parentPhysicalConnectionId = parentPhysicalConnectionId,
            virtualPhysicalConnectionIds = virtualPhysicalConnectionIds,
            virtualPhysicalConnectionStatus = virtualPhysicalConnectionStatus,
            vlanIds = vlanIds,
            vpconnAliUid = vpconnAliUid,
        )
}
