@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.inputs

import com.pulumi.alicloud.expressconnect.inputs.RouterExpressConnectRouterRegionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property regionId Representative region ID.
 * @property transitMode Represents the forwarding mode of the current region.
 */
public data class RouterExpressConnectRouterRegionArgs(
    public val regionId: Output<String>? = null,
    public val transitMode: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.expressconnect.inputs.RouterExpressConnectRouterRegionArgs> {
    override fun toJava(): com.pulumi.alicloud.expressconnect.inputs.RouterExpressConnectRouterRegionArgs =
        com.pulumi.alicloud.expressconnect.inputs.RouterExpressConnectRouterRegionArgs.builder()
            .regionId(regionId?.applyValue({ args0 -> args0 }))
            .transitMode(transitMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouterExpressConnectRouterRegionArgs].
 */
@PulumiTagMarker
public class RouterExpressConnectRouterRegionArgsBuilder internal constructor() {
    private var regionId: Output<String>? = null

    private var transitMode: Output<String>? = null

    /**
     * @param value Representative region ID.
     */
    @JvmName("ssdqfxyugurnohga")
    public suspend fun regionId(`value`: Output<String>) {
        this.regionId = value
    }

    /**
     * @param value Represents the forwarding mode of the current region.
     */
    @JvmName("ejhautpdewlkmywi")
    public suspend fun transitMode(`value`: Output<String>) {
        this.transitMode = value
    }

    /**
     * @param value Representative region ID.
     */
    @JvmName("bmlibgpfkmswattd")
    public suspend fun regionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionId = mapped
    }

    /**
     * @param value Represents the forwarding mode of the current region.
     */
    @JvmName("fgrguhmmmwexfwqb")
    public suspend fun transitMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitMode = mapped
    }

    internal fun build(): RouterExpressConnectRouterRegionArgs = RouterExpressConnectRouterRegionArgs(
        regionId = regionId,
        transitMode = transitMode,
    )
}
