@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accessPointFeatureModels Query to the Access Point Feature Model.
 * @property accessPointId The Access Point ID.
 * @property accessPointName Access Point Name.
 * @property attachedRegionNo The Access Point Is Located an ID.
 * @property description The Access Point Description.
 * @property hostOperator The Access Point Belongs to the Operator.
 * @property id The ID of the Access Point.
 * @property location The Location of the Access Point.
 * @property status The Physical Connection to Which the Access Point State.
 * @property type The Physical Connection to Which the Network Type.
 */
public data class GetAccessPointsPoint(
    public val accessPointFeatureModels: List<GetAccessPointsPointAccessPointFeatureModel>,
    public val accessPointId: String,
    public val accessPointName: String,
    public val attachedRegionNo: String,
    public val description: String,
    public val hostOperator: String,
    public val id: String,
    public val location: String,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.expressconnect.outputs.GetAccessPointsPoint): GetAccessPointsPoint = GetAccessPointsPoint(
            accessPointFeatureModels = javaType.accessPointFeatureModels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.expressconnect.kotlin.outputs.GetAccessPointsPointAccessPointFeatureModel.Companion.toKotlin(args0)
                })
            }),
            accessPointId = javaType.accessPointId(),
            accessPointName = javaType.accessPointName(),
            attachedRegionNo = javaType.attachedRegionNo(),
            description = javaType.description(),
            hostOperator = javaType.hostOperator(),
            id = javaType.id(),
            location = javaType.location(),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
