@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cenId The ID of the authorized CEN instance.
 * @property cenOwnerId The user ID (UID) of the Alibaba Cloud account to which the CEN instance belongs.
 * @property createTime The time when the instance was created.
 * @property id The ID of the Grant Rule To Cen. It formats as `<cen_id>:<cen_owner_id>:<instance_id>`.
 */
public data class GetGrantRuleToCensCen(
    public val cenId: String,
    public val cenOwnerId: Int,
    public val createTime: String,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.expressconnect.outputs.GetGrantRuleToCensCen): GetGrantRuleToCensCen = GetGrantRuleToCensCen(
            cenId = javaType.cenId(),
            cenOwnerId = javaType.cenOwnerId(),
            createTime = javaType.createTime(),
            id = javaType.id(),
        )
    }
}
