@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessPointId The Physical Leased Line Access Point ID.
 * @property adLocation To Connect a Device Physical Location.
 * @property bandwidth On the Bandwidth of the ECC Service and Physical Connection.
 * @property businessStatus The Physical Connection to Which the Payment Status: Normal, financiallocked, securitylocked.
 * @property circuitCode Operators for Physical Connection Circuit Provided Coding.
 * @property createTime The Representative of the Creation Time Resources Attribute Field.
 * @property description The Physical Connection to Which the Description.
 * @property enabledTime The Physical Connection to Which the Activation Time.
 * @property endTime The Expiration Time.
 * @property hasReservationData HasReservationData.
 * @property id The ID of the Physical Connection.
 * @property lineOperator Provides Access to the Physical Line Operator Value CT: China Telecom, CU: China Unicom, CM: china Mobile, CO: Other Chinese, Equinix:Equinix, Other: Other Overseas.
 * @property loaStatus Loa State.
 * @property paymentType on Behalf of the Pay-as-You-Type of Resource Attribute Field.
 * @property peerLocation and an on-Premises Data Center Location.
 * @property physicalConnectionId on Behalf of the Resource Level Id of the Resources Property Fields.
 * @property physicalConnectionName on Behalf of the Resource Name of the Resources-Attribute Field.
 * @property portNumber To Connect a Device Port: The Port Number of.
 * @property portType The Physical Leased Line Access Port Type Value 100Base-T: Fast Electrical Ports, 1000Base-T (the Default): gigabit Electrical Ports, 1000Base-LX: Gigabit Singlemode Optical Ports (10Km), 10GBase-T: Gigabit Electrical Port, 10GBase-LR: Gigabit Singlemode Optical Ports (10Km).
 * @property redundantPhysicalConnectionId Redundant Physical Connection to Which the ID.
 * @property reservationActiveTime The Renewal of the Entry into Force of the Time.
 * @property reservationInternetChargeType Renewal Type.
 * @property reservationOrderType Renewal Order Type.
 * @property spec The Physical Connection to Which the Specifications.
 * @property status Resources on Behalf of a State of the Resource Attribute Field.
 * @property type Physical Private Line of Type. Default Value: VPC.
 */
public data class GetPhysicalConnectionsConnection(
    public val accessPointId: String,
    public val adLocation: String,
    public val bandwidth: String,
    public val businessStatus: String,
    public val circuitCode: String,
    public val createTime: String,
    public val description: String,
    public val enabledTime: String,
    public val endTime: String,
    public val hasReservationData: String,
    public val id: String,
    public val lineOperator: String,
    public val loaStatus: String,
    public val paymentType: String,
    public val peerLocation: String,
    public val physicalConnectionId: String,
    public val physicalConnectionName: String,
    public val portNumber: String,
    public val portType: String,
    public val redundantPhysicalConnectionId: String,
    public val reservationActiveTime: String,
    public val reservationInternetChargeType: String,
    public val reservationOrderType: String,
    public val spec: String,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.expressconnect.outputs.GetPhysicalConnectionsConnection): GetPhysicalConnectionsConnection = GetPhysicalConnectionsConnection(
            accessPointId = javaType.accessPointId(),
            adLocation = javaType.adLocation(),
            bandwidth = javaType.bandwidth(),
            businessStatus = javaType.businessStatus(),
            circuitCode = javaType.circuitCode(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            enabledTime = javaType.enabledTime(),
            endTime = javaType.endTime(),
            hasReservationData = javaType.hasReservationData(),
            id = javaType.id(),
            lineOperator = javaType.lineOperator(),
            loaStatus = javaType.loaStatus(),
            paymentType = javaType.paymentType(),
            peerLocation = javaType.peerLocation(),
            physicalConnectionId = javaType.physicalConnectionId(),
            physicalConnectionName = javaType.physicalConnectionName(),
            portNumber = javaType.portNumber(),
            portType = javaType.portType(),
            redundantPhysicalConnectionId = javaType.redundantPhysicalConnectionId(),
            reservationActiveTime = javaType.reservationActiveTime(),
            reservationInternetChargeType = javaType.reservationInternetChargeType(),
            reservationOrderType = javaType.reservationOrderType(),
            spec = javaType.spec(),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
