@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPhysicalConnections.
 * @property connections
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property includeReservationData
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property status
 */
public data class GetPhysicalConnectionsResult(
    public val connections: List<GetPhysicalConnectionsConnection>,
    public val id: String,
    public val ids: List<String>,
    public val includeReservationData: Boolean? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.expressconnect.outputs.GetPhysicalConnectionsResult): GetPhysicalConnectionsResult = GetPhysicalConnectionsResult(
            connections = javaType.connections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.expressconnect.kotlin.outputs.GetPhysicalConnectionsConnection.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            includeReservationData = javaType.includeReservationData().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
