@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessPointId The access point ID to which the VBR belongs.
 * @property bandwidth The bandwidth of the resource.
 * @property businessStatus The businessStatus of the resource. Valid Values: `Normal`, `FinancialLocked`, `SecurityLocked`.
 * @property connectedTime The connected time of the resource.
 * @property createTime The creation time of the resource
 * @property crossBorder The cross border of the resource.
 * @property description The description of the router interface.
 * @property endTime The end time of the resource.
 * @property hasReservationData The has reservation data of the resource.
 * @property hcRate The hc rate of the resource.
 * @property hcThreshold The hc threshold of the resource.
 * @property healthCheckSourceIp The health check source IP address, must be an unused IP within the local VPC.
 * @property healthCheckTargetIp The IP address for health screening purposes.
 * @property id
 * @property oppositeAccessPointId The Access point ID to which the other end belongs.
 * @property oppositeBandwidth The opposite bandwidth of the router on the other side.
 * @property oppositeInterfaceBusinessStatus The opposite interface business status of the router on the other side. Valid Values: `Normal`, `FinancialLocked`, `SecurityLocked`.
 * @property oppositeInterfaceId The Interface ID of the router at the other end.
 * @property oppositeInterfaceOwnerId The AliCloud account ID of the owner of the router interface on the other end.
 * @property oppositeInterfaceSpec The opposite interface spec of the router on the other side. Valid Values: `Mini.2`, `Mini.5`, `Mini.5`, `Small.2`, `Small.5`, `Middle.1`, `Middle.2`, `Middle.5`, `Large.1`, `Large.2`, `Large.5`, `XLarge.1`, `Negative`.
 * @property oppositeInterfaceStatus The opposite interface status of the router on the other side. Valid Values: `Idle`, `AcceptingConnecting`, `Connecting`, `Activating`, `Active`, `Modifying`, `Deactivating`, `Inactive`, `Deleting`.
 * @property oppositeRegionId The geographical ID of the location of the receiving end of the connection.
 * @property oppositeRouterId The id of the router at the other end.
 * @property oppositeRouterType The opposite router type of the router on the other side. Valid Values: `VRouter`, `VBR`.
 * @property oppositeVpcInstanceId The opposite vpc instance id of the router on the other side.
 * @property paymentType The payment methods for router interfaces. Valid Values: `PrePaid`, `PostPaid`.
 * @property reservationActiveTime The reservation active time of the resource.
 * @property reservationBandwidth The reservation bandwidth of the resource.
 * @property reservationInternetChargeType The reservation internet charge type of the resource.
 * @property reservationOrderType The reservation order type of the resource.
 * @property role The role of the router interface. Valid Values: `InitiatingSide`, `AcceptingSide`.
 * @property routerId The router id associated with the router interface.
 * @property routerInterfaceId The first ID of the resource.
 * @property routerInterfaceName The name of the resource.
 * @property routerType The type of router associated with the router interface. Valid Values: `VRouter`, `VBR`.
 * @property spec The specification of the router interface. Valid Values: `Mini.2`, `Mini.5`, `Mini.5`, `Small.2`, `Small.5`, `Middle.1`, `Middle.2`, `Middle.5`, `Large.1`, `Large.2`, `Large.5`, `XLarge.1`, `Negative`.
 * @property status The status of the resource. Valid Values: `Idle`, `AcceptingConnecting`, `Connecting`, `Activating`, `Active`, `Modifying`, `Deactivating`, `Inactive`, `Deleting`.
 * @property vpcInstanceId The vpc instance id of the resource.
 */
public data class GetRouterInterfacesInterface(
    public val accessPointId: String,
    public val bandwidth: Int,
    public val businessStatus: String,
    public val connectedTime: String,
    public val createTime: String,
    public val crossBorder: Boolean,
    public val description: String,
    public val endTime: String,
    public val hasReservationData: String,
    public val hcRate: Int,
    public val hcThreshold: String,
    public val healthCheckSourceIp: String,
    public val healthCheckTargetIp: String,
    public val id: String,
    public val oppositeAccessPointId: String,
    public val oppositeBandwidth: Int,
    public val oppositeInterfaceBusinessStatus: String,
    public val oppositeInterfaceId: String,
    public val oppositeInterfaceOwnerId: String,
    public val oppositeInterfaceSpec: String,
    public val oppositeInterfaceStatus: String,
    public val oppositeRegionId: String,
    public val oppositeRouterId: String,
    public val oppositeRouterType: String,
    public val oppositeVpcInstanceId: String,
    public val paymentType: String,
    public val reservationActiveTime: String,
    public val reservationBandwidth: String,
    public val reservationInternetChargeType: String,
    public val reservationOrderType: String,
    public val role: String,
    public val routerId: String,
    public val routerInterfaceId: String,
    public val routerInterfaceName: String,
    public val routerType: String,
    public val spec: String,
    public val status: String,
    public val vpcInstanceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.expressconnect.outputs.GetRouterInterfacesInterface): GetRouterInterfacesInterface = GetRouterInterfacesInterface(
            accessPointId = javaType.accessPointId(),
            bandwidth = javaType.bandwidth(),
            businessStatus = javaType.businessStatus(),
            connectedTime = javaType.connectedTime(),
            createTime = javaType.createTime(),
            crossBorder = javaType.crossBorder(),
            description = javaType.description(),
            endTime = javaType.endTime(),
            hasReservationData = javaType.hasReservationData(),
            hcRate = javaType.hcRate(),
            hcThreshold = javaType.hcThreshold(),
            healthCheckSourceIp = javaType.healthCheckSourceIp(),
            healthCheckTargetIp = javaType.healthCheckTargetIp(),
            id = javaType.id(),
            oppositeAccessPointId = javaType.oppositeAccessPointId(),
            oppositeBandwidth = javaType.oppositeBandwidth(),
            oppositeInterfaceBusinessStatus = javaType.oppositeInterfaceBusinessStatus(),
            oppositeInterfaceId = javaType.oppositeInterfaceId(),
            oppositeInterfaceOwnerId = javaType.oppositeInterfaceOwnerId(),
            oppositeInterfaceSpec = javaType.oppositeInterfaceSpec(),
            oppositeInterfaceStatus = javaType.oppositeInterfaceStatus(),
            oppositeRegionId = javaType.oppositeRegionId(),
            oppositeRouterId = javaType.oppositeRouterId(),
            oppositeRouterType = javaType.oppositeRouterType(),
            oppositeVpcInstanceId = javaType.oppositeVpcInstanceId(),
            paymentType = javaType.paymentType(),
            reservationActiveTime = javaType.reservationActiveTime(),
            reservationBandwidth = javaType.reservationBandwidth(),
            reservationInternetChargeType = javaType.reservationInternetChargeType(),
            reservationOrderType = javaType.reservationOrderType(),
            role = javaType.role(),
            routerId = javaType.routerId(),
            routerInterfaceId = javaType.routerInterfaceId(),
            routerInterfaceName = javaType.routerInterfaceName(),
            routerType = javaType.routerType(),
            spec = javaType.spec(),
            status = javaType.status(),
            vpcInstanceId = javaType.vpcInstanceId(),
        )
    }
}
