@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRouterInterfaces.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Router Interface IDs.
 * @property includeReservationData
 * @property interfaces A list of Router Interface Entries. Each element contains the following attributes:
 * @property nameRegex
 * @property names A list of name of Router Interfaces.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 */
public data class GetRouterInterfacesResult(
    public val filters: List<GetRouterInterfacesFilter>? = null,
    public val id: String,
    public val ids: List<String>,
    public val includeReservationData: String? = null,
    public val interfaces: List<GetRouterInterfacesInterface>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.expressconnect.outputs.GetRouterInterfacesResult): GetRouterInterfacesResult = GetRouterInterfacesResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.expressconnect.kotlin.outputs.GetRouterInterfacesFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            includeReservationData = javaType.includeReservationData().map({ args0 -> args0 }).orElse(null),
            interfaces = javaType.interfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.expressconnect.kotlin.outputs.GetRouterInterfacesInterface.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
