@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property circuitCode The circuit code provided by the operator for the physical connection.
 * @property enableIpv6 Whether IPv6 is enabled.
 * @property id The ID of the Vbr Pconn Association.
 * @property localGatewayIp The Alibaba cloud IP address of the VBR instance.
 * @property localIpv6GatewayIp The IPv6 address on the Alibaba Cloud side of the VBR instance.
 * @property peerGatewayIp The client IP address of the VBR instance.
 * @property peerIpv6GatewayIp The IPv6 address of the client side of the VBR instance.
 * @property peeringIpv6SubnetMask The subnet mask of the Alibaba Cloud side and the client side of the VBR instance.Two IPv6 addresses must be in the same subnet.
 * @property peeringSubnetMask The subnet mask of the Alibaba Cloud side and the client side of the VBR instance.The two IP addresses must be in the same subnet.
 * @property physicalConnectionId The ID of the leased line instance.
 * @property status The status of the resource
 * @property vbrId The ID of the VBR instance.
 * @property vlanId VLAN ID of the VBR.
 */
public data class GetVbrPconnAssociationsAssociation(
    public val circuitCode: String,
    public val enableIpv6: Boolean,
    public val id: String,
    public val localGatewayIp: String,
    public val localIpv6GatewayIp: String,
    public val peerGatewayIp: String,
    public val peerIpv6GatewayIp: String,
    public val peeringIpv6SubnetMask: String,
    public val peeringSubnetMask: String,
    public val physicalConnectionId: String,
    public val status: String,
    public val vbrId: String,
    public val vlanId: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.expressconnect.outputs.GetVbrPconnAssociationsAssociation): GetVbrPconnAssociationsAssociation = GetVbrPconnAssociationsAssociation(
            circuitCode = javaType.circuitCode(),
            enableIpv6 = javaType.enableIpv6(),
            id = javaType.id(),
            localGatewayIp = javaType.localGatewayIp(),
            localIpv6GatewayIp = javaType.localIpv6GatewayIp(),
            peerGatewayIp = javaType.peerGatewayIp(),
            peerIpv6GatewayIp = javaType.peerIpv6GatewayIp(),
            peeringIpv6SubnetMask = javaType.peeringIpv6SubnetMask(),
            peeringSubnetMask = javaType.peeringSubnetMask(),
            physicalConnectionId = javaType.physicalConnectionId(),
            status = javaType.status(),
            vbrId = javaType.vbrId(),
            vlanId = javaType.vlanId(),
        )
    }
}
