@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getVbrPconnAssociations.
 * @property associations A list of Vbr Pconn Association Entries. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property vbrId The ID of the VBR instance.
 */
public data class GetVbrPconnAssociationsResult(
    public val associations: List<GetVbrPconnAssociationsAssociation>,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val vbrId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.expressconnect.outputs.GetVbrPconnAssociationsResult): GetVbrPconnAssociationsResult = GetVbrPconnAssociationsResult(
            associations = javaType.associations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.expressconnect.kotlin.outputs.GetVbrPconnAssociationsAssociation.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            vbrId = javaType.vbrId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
