@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property key The key of the field to filter by, as defined by
 * [Alibaba Cloud API](https://www.alibabacloud.com/help/en/doc-detail/124791.htm).
 * @property values Set of values that are accepted for the given field.
 */
public data class GetVirtualBorderRoutersFilter(
    public val key: String? = null,
    public val values: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.expressconnect.outputs.GetVirtualBorderRoutersFilter): GetVirtualBorderRoutersFilter = GetVirtualBorderRoutersFilter(
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
