@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getVirtualBorderRouters.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property routers
 * @property status
 */
public data class GetVirtualBorderRoutersResult(
    public val filters: List<GetVirtualBorderRoutersFilter>? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val routers: List<GetVirtualBorderRoutersRouter>,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.expressconnect.outputs.GetVirtualBorderRoutersResult): GetVirtualBorderRoutersResult = GetVirtualBorderRoutersResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.expressconnect.kotlin.outputs.GetVirtualBorderRoutersFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            routers = javaType.routers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.expressconnect.kotlin.outputs.GetVirtualBorderRoutersRouter.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
