@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessPointId The physical leased line access point ID.
 * @property activationTime The first activation time of VBR.
 * @property circuitCode Operators for physical connection circuit provided coding.
 * @property cloudBoxInstanceId Box Instance Id.
 * @property createTime The representative of the creation time resources attribute field.
 * @property description The description of VBR. Length is from 2 to 256 characters, must start with a letter or the Chinese at the beginning, but not at the http:// Or https:// at the beginning.
 * @property detectMultiplier Detection time multiplier that recipient allows the sender to send a message of the maximum allowable connections for the number of packets, used to detect whether the link normal. Value: 3~10.
 * @property eccId High Speed Migration Service Instance Id.
 * @property enableIpv6 Whether to Enable IPv6.
 * @property id The ID of the Virtual Border Router.
 * @property localGatewayIp Alibaba Cloud-Connected IPv4 address.
 * @property localIpv6GatewayIp Alibaba Cloud-Connected IPv6 Address.
 * @property minRxInterval Configure BFD packet reception interval of values include: 200~1000, unit: ms.
 * @property minTxInterval Configure BFD packet transmission interval maximum value: 200~1000, unit: ms.
 * @property paymentVbrExpireTime The Billing of the Extended Time.
 * @property peerGatewayIp The Client-Side Interconnection IPv4 Address.
 * @property peerIpv6GatewayIp The Client-Side Interconnection IPv6 Address.
 * @property peeringIpv6SubnetMask Alibaba Cloud-Connected IPv6 with Client-Side Interconnection IPv6 of Subnet Mask.
 * @property peeringSubnetMask Alibaba Cloud-Connected IPv4 and Client-Side Interconnection IPv4 of Subnet Mask.
 * @property physicalConnectionBusinessStatus Physical Private Line Service Status Value Normal: Normal, financiallocked: If You Lock.
 * @property physicalConnectionId The ID of the Physical Connection to Which the ID.
 * @property physicalConnectionOwnerUid Physical Private Line Where the Account ID.
 * @property physicalConnectionStatus Physical Private Line State.
 * @property recoveryTime The Last from a Terminated State to the Active State of the Time.
 * @property routeTableId Route Table ID.
 * @property status The VBR state.
 * @property terminationTime The Most Recent Was Aborted by the Time.
 * @property type VBR Type.
 * @property virtualBorderRouterId The VBR ID.
 * @property virtualBorderRouterName The name of VBR. Length is from 2 to 128 characters, must start with a letter or the Chinese at the beginning can contain numbers, the underscore character (_) and dash (-). But do not start with http:// or https:// at the beginning.
 * @property vlanId The VLAN ID of the VBR. Value range: 0~2999.
 * @property vlanInterfaceId The ID of the Router Interface.
 */
public data class GetVirtualBorderRoutersRouter(
    public val accessPointId: String,
    public val activationTime: String,
    public val circuitCode: String,
    public val cloudBoxInstanceId: String,
    public val createTime: String,
    public val description: String,
    public val detectMultiplier: Int,
    public val eccId: String,
    public val enableIpv6: Boolean,
    public val id: String,
    public val localGatewayIp: String,
    public val localIpv6GatewayIp: String,
    public val minRxInterval: Int,
    public val minTxInterval: Int,
    public val paymentVbrExpireTime: String,
    public val peerGatewayIp: String,
    public val peerIpv6GatewayIp: String,
    public val peeringIpv6SubnetMask: String,
    public val peeringSubnetMask: String,
    public val physicalConnectionBusinessStatus: String,
    public val physicalConnectionId: String,
    public val physicalConnectionOwnerUid: String,
    public val physicalConnectionStatus: String,
    public val recoveryTime: String,
    public val routeTableId: String,
    public val status: String,
    public val terminationTime: String,
    public val type: String,
    public val virtualBorderRouterId: String,
    public val virtualBorderRouterName: String,
    public val vlanId: Int,
    public val vlanInterfaceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.expressconnect.outputs.GetVirtualBorderRoutersRouter): GetVirtualBorderRoutersRouter = GetVirtualBorderRoutersRouter(
            accessPointId = javaType.accessPointId(),
            activationTime = javaType.activationTime(),
            circuitCode = javaType.circuitCode(),
            cloudBoxInstanceId = javaType.cloudBoxInstanceId(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            detectMultiplier = javaType.detectMultiplier(),
            eccId = javaType.eccId(),
            enableIpv6 = javaType.enableIpv6(),
            id = javaType.id(),
            localGatewayIp = javaType.localGatewayIp(),
            localIpv6GatewayIp = javaType.localIpv6GatewayIp(),
            minRxInterval = javaType.minRxInterval(),
            minTxInterval = javaType.minTxInterval(),
            paymentVbrExpireTime = javaType.paymentVbrExpireTime(),
            peerGatewayIp = javaType.peerGatewayIp(),
            peerIpv6GatewayIp = javaType.peerIpv6GatewayIp(),
            peeringIpv6SubnetMask = javaType.peeringIpv6SubnetMask(),
            peeringSubnetMask = javaType.peeringSubnetMask(),
            physicalConnectionBusinessStatus = javaType.physicalConnectionBusinessStatus(),
            physicalConnectionId = javaType.physicalConnectionId(),
            physicalConnectionOwnerUid = javaType.physicalConnectionOwnerUid(),
            physicalConnectionStatus = javaType.physicalConnectionStatus(),
            recoveryTime = javaType.recoveryTime(),
            routeTableId = javaType.routeTableId(),
            status = javaType.status(),
            terminationTime = javaType.terminationTime(),
            type = javaType.type(),
            virtualBorderRouterId = javaType.virtualBorderRouterId(),
            virtualBorderRouterName = javaType.virtualBorderRouterName(),
            vlanId = javaType.vlanId(),
            vlanInterfaceId = javaType.vlanInterfaceId(),
        )
    }
}
