@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessPointId The ID of the access point of the physical connection.
 * @property adLocation The physical location where the physical connection access device is located.
 * @property bandwidth The bandwidth of the physical connection. Unit: Mbps.
 * @property businessStatus The commercial status of the physical line. Value:
 * - **Normal**: activated.
 * - **Financialized**: Arrears locked.
 * - **SecurityLocked**: locked for security reasons.
 * @property circuitCode The circuit code provided by the operator for the physical connection.
 * @property createTime The creation time of the resource
 * @property description The description of the physical connection.
 * @property enabledTime The opening time of the physical connection.
 * @property endTime The expiration time of the shared line.Time is expressed according to ISO8601 standard and UTC time is used. The format is: YYYY-MM-DDThh:mm:ssZ.
 * @property expectSpec The estimated bandwidth value of the shared line. The expected bandwidth value will not take effect until the payment is completed.Unit: **M** indicates Mbps,**G** indicates Gbps.
 * @property id The ID of the Virtual Physical Connection.
 * @property lineOperator Operators that provide access to physical lines. Value:-**CT**: China Telecom.-**CU**: China Unicom.-**CM**: China Mobile.-**CO**: China Other.-**Equinix**:Equinix.-**Other**: Other abroad.
 * @property loaStatus The state of LOA. Value:-**Applying**:LOA application.-**Accept**:LOA application passed.-**Available**:LOA is Available.-**Rejected**:LOA application Rejected.-**Completing**: The dedicated line is under construction.-**Complete**: The construction of the dedicated line is completed.-**Deleted**:LOA has been Deleted.
 * @property orderMode The payment method of shared dedicated line. Value:-**PayByPhysicalConnectionOwner**: indicates that the owner of the physical line associated with the shared line pays.-**PayByVirtualPhysicalConnectionOwner**: indicates that the owner of the shared line pays.
 * @property parentPhysicalConnectionAliUid The ID of the Alibaba Cloud account (primary account) to which the physical connection belongs.
 * @property parentPhysicalConnectionId The ID of the instance of the physical connection.
 * @property peerLocation The geographic location of the local data center.
 * @property portNumber The port number of the physical connection device.
 * @property portType Physical connection port type. Value:-**100Base-T**: 100 megabytes port.-**1000Base-T**: Gigabit port.-**1000Base-LX**: Gigabit single mode optical port (10km).-**10GBase-T**: 10 Gigabit port.-**10GBase-LR**: 10 Gigabit single mode optical port (10km).-**40GBase-LR**: 40 megabytes single-mode optical port.-**100GBase-LR**: 100,000 megabytes single-mode optical port.
 * @property redundantPhysicalConnectionId The ID of the redundant physical connection.
 * @property resourceGroupId The resource group id
 * @property spec The bandwidth value of the shared line.Unit: **M** indicates Mbps,**G** indicates Gbps.
 * @property status The status of the resource
 * @property virtualPhysicalConnectionId The ID of the hosted connection
 * @property virtualPhysicalConnectionName The name of the physical connection.
 * @property virtualPhysicalConnectionStatus The business status of the shared line. Value:
 * - **Confirmed**: The shared line has been Confirmed to receive.
 * - **UnConfirmed**: The shared line has not been confirmed to be received.
 * - **Deleted**: The shared line has been Deleted.
 * @property vlanId The VLAN ID of the shared leased line.
 * @property vpconnAliUid The ID of the Alibaba Cloud account (primary account) of the owner of the shared line.
 */
public data class GetVirtualPhysicalConnectionsConnection(
    public val accessPointId: String,
    public val adLocation: String,
    public val bandwidth: String,
    public val businessStatus: String,
    public val circuitCode: String,
    public val createTime: String,
    public val description: String,
    public val enabledTime: String,
    public val endTime: String,
    public val expectSpec: String,
    public val id: String,
    public val lineOperator: String,
    public val loaStatus: String,
    public val orderMode: String,
    public val parentPhysicalConnectionAliUid: String,
    public val parentPhysicalConnectionId: String,
    public val peerLocation: String,
    public val portNumber: String,
    public val portType: String,
    public val redundantPhysicalConnectionId: String,
    public val resourceGroupId: String,
    public val spec: String,
    public val status: String,
    public val virtualPhysicalConnectionId: String,
    public val virtualPhysicalConnectionName: String,
    public val virtualPhysicalConnectionStatus: String,
    public val vlanId: Int,
    public val vpconnAliUid: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.expressconnect.outputs.GetVirtualPhysicalConnectionsConnection): GetVirtualPhysicalConnectionsConnection = GetVirtualPhysicalConnectionsConnection(
            accessPointId = javaType.accessPointId(),
            adLocation = javaType.adLocation(),
            bandwidth = javaType.bandwidth(),
            businessStatus = javaType.businessStatus(),
            circuitCode = javaType.circuitCode(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            enabledTime = javaType.enabledTime(),
            endTime = javaType.endTime(),
            expectSpec = javaType.expectSpec(),
            id = javaType.id(),
            lineOperator = javaType.lineOperator(),
            loaStatus = javaType.loaStatus(),
            orderMode = javaType.orderMode(),
            parentPhysicalConnectionAliUid = javaType.parentPhysicalConnectionAliUid(),
            parentPhysicalConnectionId = javaType.parentPhysicalConnectionId(),
            peerLocation = javaType.peerLocation(),
            portNumber = javaType.portNumber(),
            portType = javaType.portType(),
            redundantPhysicalConnectionId = javaType.redundantPhysicalConnectionId(),
            resourceGroupId = javaType.resourceGroupId(),
            spec = javaType.spec(),
            status = javaType.status(),
            virtualPhysicalConnectionId = javaType.virtualPhysicalConnectionId(),
            virtualPhysicalConnectionName = javaType.virtualPhysicalConnectionName(),
            virtualPhysicalConnectionStatus = javaType.virtualPhysicalConnectionStatus(),
            vlanId = javaType.vlanId(),
            vpconnAliUid = javaType.vpconnAliUid(),
        )
    }
}
