@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.expressconnect.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getVirtualPhysicalConnections.
 * @property businessStatus The commercial status of the physical line. Value:-**Normal**: activated.-**Financialized**: Arrears locked.-**SecurityLocked**: locked for security reasons.
 * @property connections A list of Virtual Physical Connection Entries. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Virtual Physical Connection IDs.
 * @property isConfirmed
 * @property nameRegex
 * @property names A list of name of Virtual Physical Connections.
 * @property outputFile
 * @property parentPhysicalConnectionId The ID of the instance of the physical connection.
 * @property virtualPhysicalConnectionIds
 * @property virtualPhysicalConnectionStatus The business status of the shared line. Value:-**Confirmed**: The shared line has been Confirmed to receive.-**UnConfirmed**: The shared line has not been confirmed to be received.-**Deleted**: The shared line has been Deleted.
 * @property vlanIds
 * @property vpconnAliUid The ID of the Alibaba Cloud account (primary account) of the owner of the shared line.
 */
public data class GetVirtualPhysicalConnectionsResult(
    public val businessStatus: String? = null,
    public val connections: List<GetVirtualPhysicalConnectionsConnection>,
    public val id: String,
    public val ids: List<String>,
    public val isConfirmed: Boolean? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val parentPhysicalConnectionId: String? = null,
    public val virtualPhysicalConnectionIds: List<String>? = null,
    public val virtualPhysicalConnectionStatus: String? = null,
    public val vlanIds: List<Int>? = null,
    public val vpconnAliUid: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.expressconnect.outputs.GetVirtualPhysicalConnectionsResult): GetVirtualPhysicalConnectionsResult = GetVirtualPhysicalConnectionsResult(
            businessStatus = javaType.businessStatus().map({ args0 -> args0 }).orElse(null),
            connections = javaType.connections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.expressconnect.kotlin.outputs.GetVirtualPhysicalConnectionsConnection.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            isConfirmed = javaType.isConfirmed().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            parentPhysicalConnectionId = javaType.parentPhysicalConnectionId().map({ args0 ->
                args0
            }).orElse(null),
            virtualPhysicalConnectionIds = javaType.virtualPhysicalConnectionIds().map({ args0 -> args0 }),
            virtualPhysicalConnectionStatus = javaType.virtualPhysicalConnectionStatus().map({ args0 ->
                args0
            }).orElse(null),
            vlanIds = javaType.vlanIds().map({ args0 -> args0 }),
            vpconnAliUid = javaType.vpconnAliUid().map({ args0 -> args0 }).orElse(null),
        )
    }
}
