@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin

import com.pulumi.alicloud.fc.kotlin.outputs.AliasRoutingConfig
import com.pulumi.alicloud.fc.kotlin.outputs.AliasRoutingConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Alias].
 */
@PulumiTagMarker
public class AliasResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AliasArgs = AliasArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AliasArgsBuilder.() -> Unit) {
        val builder = AliasArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Alias {
        val builtJavaResource = com.pulumi.alicloud.fc.Alias(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Alias(builtJavaResource)
    }
}

/**
 * Creates a Function Compute service alias. Creates an alias that points to the specified Function Compute service version.
 *  For the detailed information, please refer to the [developer guide](https://www.alibabacloud.com/help/en/fc/developer-reference/api-createalias).
 * > **NOTE:** Available since v1.104.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const defaultService = new alicloud.fc.Service("default", {
 *     name: `example-value-${_default.result}`,
 *     description: "example-value",
 *     publish: true,
 * });
 * const example = new alicloud.fc.Alias("example", {
 *     aliasName: "example-value",
 *     description: "example-value",
 *     serviceName: defaultService.name,
 *     serviceVersion: "1",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * default_service = alicloud.fc.Service("default",
 *     name=f"example-value-{default['result']}",
 *     description="example-value",
 *     publish=True)
 * example = alicloud.fc.Alias("example",
 *     alias_name="example-value",
 *     description="example-value",
 *     service_name=default_service.name,
 *     service_version="1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var defaultService = new AliCloud.FC.Service("default", new()
 *     {
 *         Name = $"example-value-{@default.Result}",
 *         Description = "example-value",
 *         Publish = true,
 *     });
 *     var example = new AliCloud.FC.Alias("example", new()
 *     {
 *         AliasName = "example-value",
 *         Description = "example-value",
 *         ServiceName = defaultService.Name,
 *         ServiceVersion = "1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultService, err := fc.NewService(ctx, "default", &fc.ServiceArgs{
 * 			Name:        pulumi.Sprintf("example-value-%v", _default.Result),
 * 			Description: pulumi.String("example-value"),
 * 			Publish:     pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = fc.NewAlias(ctx, "example", &fc.AliasArgs{
 * 			AliasName:      pulumi.String("example-value"),
 * 			Description:    pulumi.String("example-value"),
 * 			ServiceName:    defaultService.Name,
 * 			ServiceVersion: pulumi.String("1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.fc.Service;
 * import com.pulumi.alicloud.fc.ServiceArgs;
 * import com.pulumi.alicloud.fc.Alias;
 * import com.pulumi.alicloud.fc.AliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var defaultService = new Service("defaultService", ServiceArgs.builder()
 *             .name(String.format("example-value-%s", default_.result()))
 *             .description("example-value")
 *             .publish("true")
 *             .build());
 *         var example = new Alias("example", AliasArgs.builder()
 *             .aliasName("example-value")
 *             .description("example-value")
 *             .serviceName(defaultService.name())
 *             .serviceVersion("1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   defaultService:
 *     type: alicloud:fc:Service
 *     name: default
 *     properties:
 *       name: example-value-${default.result}
 *       description: example-value
 *       publish: 'true'
 *   example:
 *     type: alicloud:fc:Alias
 *     properties:
 *       aliasName: example-value
 *       description: example-value
 *       serviceName: ${defaultService.name}
 *       serviceVersion: '1'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Function Compute alias can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:fc/alias:Alias example my_alias_id
 * ```
 */
public class Alias internal constructor(
    override val javaResource: com.pulumi.alicloud.fc.Alias,
) : KotlinCustomResource(javaResource, AliasMapper) {
    /**
     * Name for the alias you are creating.
     */
    public val aliasName: Output<String>
        get() = javaResource.aliasName().applyValue({ args0 -> args0 })

    /**
     * Description of the alias.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Function Compute alias' route configuration settings. See `routing_config` below.
     */
    public val routingConfig: Output<AliasRoutingConfig>?
        get() = javaResource.routingConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The Function Compute service name.
     */
    public val serviceName: Output<String>
        get() = javaResource.serviceName().applyValue({ args0 -> args0 })

    /**
     * The Function Compute service version for which you are creating the alias. Pattern: (LATEST|[0-9]+).
     */
    public val serviceVersion: Output<String>
        get() = javaResource.serviceVersion().applyValue({ args0 -> args0 })
}

public object AliasMapper : ResourceMapper<Alias> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.fc.Alias::class == javaResource::class

    override fun map(javaResource: Resource): Alias = Alias(
        javaResource as
            com.pulumi.alicloud.fc.Alias,
    )
}

/**
 * @see [Alias].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Alias].
 */
public suspend fun alias(name: String, block: suspend AliasResourceBuilder.() -> Unit): Alias {
    val builder = AliasResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Alias].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alias(name: String): Alias {
    val builder = AliasResourceBuilder()
    builder.name(name)
    return builder.build()
}
