@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin

import com.pulumi.alicloud.fc.AliasArgs.builder
import com.pulumi.alicloud.fc.kotlin.inputs.AliasRoutingConfigArgs
import com.pulumi.alicloud.fc.kotlin.inputs.AliasRoutingConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Creates a Function Compute service alias. Creates an alias that points to the specified Function Compute service version.
 *  For the detailed information, please refer to the [developer guide](https://www.alibabacloud.com/help/en/fc/developer-reference/api-createalias).
 * > **NOTE:** Available since v1.104.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const defaultService = new alicloud.fc.Service("default", {
 *     name: `example-value-${_default.result}`,
 *     description: "example-value",
 *     publish: true,
 * });
 * const example = new alicloud.fc.Alias("example", {
 *     aliasName: "example-value",
 *     description: "example-value",
 *     serviceName: defaultService.name,
 *     serviceVersion: "1",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * default_service = alicloud.fc.Service("default",
 *     name=f"example-value-{default['result']}",
 *     description="example-value",
 *     publish=True)
 * example = alicloud.fc.Alias("example",
 *     alias_name="example-value",
 *     description="example-value",
 *     service_name=default_service.name,
 *     service_version="1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var defaultService = new AliCloud.FC.Service("default", new()
 *     {
 *         Name = $"example-value-{@default.Result}",
 *         Description = "example-value",
 *         Publish = true,
 *     });
 *     var example = new AliCloud.FC.Alias("example", new()
 *     {
 *         AliasName = "example-value",
 *         Description = "example-value",
 *         ServiceName = defaultService.Name,
 *         ServiceVersion = "1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultService, err := fc.NewService(ctx, "default", &fc.ServiceArgs{
 * 			Name:        pulumi.Sprintf("example-value-%v", _default.Result),
 * 			Description: pulumi.String("example-value"),
 * 			Publish:     pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = fc.NewAlias(ctx, "example", &fc.AliasArgs{
 * 			AliasName:      pulumi.String("example-value"),
 * 			Description:    pulumi.String("example-value"),
 * 			ServiceName:    defaultService.Name,
 * 			ServiceVersion: pulumi.String("1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.fc.Service;
 * import com.pulumi.alicloud.fc.ServiceArgs;
 * import com.pulumi.alicloud.fc.Alias;
 * import com.pulumi.alicloud.fc.AliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var defaultService = new Service("defaultService", ServiceArgs.builder()
 *             .name(String.format("example-value-%s", default_.result()))
 *             .description("example-value")
 *             .publish("true")
 *             .build());
 *         var example = new Alias("example", AliasArgs.builder()
 *             .aliasName("example-value")
 *             .description("example-value")
 *             .serviceName(defaultService.name())
 *             .serviceVersion("1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   defaultService:
 *     type: alicloud:fc:Service
 *     name: default
 *     properties:
 *       name: example-value-${default.result}
 *       description: example-value
 *       publish: 'true'
 *   example:
 *     type: alicloud:fc:Alias
 *     properties:
 *       aliasName: example-value
 *       description: example-value
 *       serviceName: ${defaultService.name}
 *       serviceVersion: '1'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Function Compute alias can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:fc/alias:Alias example my_alias_id
 * ```
 * @property aliasName Name for the alias you are creating.
 * @property description Description of the alias.
 * @property routingConfig The Function Compute alias' route configuration settings. See `routing_config` below.
 * @property serviceName The Function Compute service name.
 * @property serviceVersion The Function Compute service version for which you are creating the alias. Pattern: (LATEST|[0-9]+).
 */
public data class AliasArgs(
    public val aliasName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val routingConfig: Output<AliasRoutingConfigArgs>? = null,
    public val serviceName: Output<String>? = null,
    public val serviceVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.AliasArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.AliasArgs =
        com.pulumi.alicloud.fc.AliasArgs.builder()
            .aliasName(aliasName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .routingConfig(routingConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .serviceVersion(serviceVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AliasArgs].
 */
@PulumiTagMarker
public class AliasArgsBuilder internal constructor() {
    private var aliasName: Output<String>? = null

    private var description: Output<String>? = null

    private var routingConfig: Output<AliasRoutingConfigArgs>? = null

    private var serviceName: Output<String>? = null

    private var serviceVersion: Output<String>? = null

    /**
     * @param value Name for the alias you are creating.
     */
    @JvmName("aytheoqjdcrjprwg")
    public suspend fun aliasName(`value`: Output<String>) {
        this.aliasName = value
    }

    /**
     * @param value Description of the alias.
     */
    @JvmName("eaitocvsdiaxbmss")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The Function Compute alias' route configuration settings. See `routing_config` below.
     */
    @JvmName("heuyjomfwlydmxur")
    public suspend fun routingConfig(`value`: Output<AliasRoutingConfigArgs>) {
        this.routingConfig = value
    }

    /**
     * @param value The Function Compute service name.
     */
    @JvmName("ufduicfkcopuetdp")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The Function Compute service version for which you are creating the alias. Pattern: (LATEST|[0-9]+).
     */
    @JvmName("frgmvldrmxhshkeb")
    public suspend fun serviceVersion(`value`: Output<String>) {
        this.serviceVersion = value
    }

    /**
     * @param value Name for the alias you are creating.
     */
    @JvmName("ihshjyaiqpvrxnyh")
    public suspend fun aliasName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aliasName = mapped
    }

    /**
     * @param value Description of the alias.
     */
    @JvmName("qwpuoxvdwepodbtu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The Function Compute alias' route configuration settings. See `routing_config` below.
     */
    @JvmName("qmowkmsbqoptgono")
    public suspend fun routingConfig(`value`: AliasRoutingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingConfig = mapped
    }

    /**
     * @param argument The Function Compute alias' route configuration settings. See `routing_config` below.
     */
    @JvmName("purbgtwhhbvlqfai")
    public suspend fun routingConfig(argument: suspend AliasRoutingConfigArgsBuilder.() -> Unit) {
        val toBeMapped = AliasRoutingConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routingConfig = mapped
    }

    /**
     * @param value The Function Compute service name.
     */
    @JvmName("kssoyedjalrxffek")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value The Function Compute service version for which you are creating the alias. Pattern: (LATEST|[0-9]+).
     */
    @JvmName("mkskbarryrbmpjoe")
    public suspend fun serviceVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceVersion = mapped
    }

    internal fun build(): AliasArgs = AliasArgs(
        aliasName = aliasName,
        description = description,
        routingConfig = routingConfig,
        serviceName = serviceName,
        serviceVersion = serviceVersion,
    )
}
