@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin

import com.pulumi.alicloud.fc.FcFunctions.getCustomDomainsPlain
import com.pulumi.alicloud.fc.FcFunctions.getFunctionsPlain
import com.pulumi.alicloud.fc.FcFunctions.getServicePlain
import com.pulumi.alicloud.fc.FcFunctions.getServicesPlain
import com.pulumi.alicloud.fc.FcFunctions.getTriggersPlain
import com.pulumi.alicloud.fc.FcFunctions.getZonesPlain
import com.pulumi.alicloud.fc.kotlin.inputs.GetCustomDomainsPlainArgs
import com.pulumi.alicloud.fc.kotlin.inputs.GetCustomDomainsPlainArgsBuilder
import com.pulumi.alicloud.fc.kotlin.inputs.GetFunctionsPlainArgs
import com.pulumi.alicloud.fc.kotlin.inputs.GetFunctionsPlainArgsBuilder
import com.pulumi.alicloud.fc.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.fc.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.fc.kotlin.inputs.GetServicesPlainArgs
import com.pulumi.alicloud.fc.kotlin.inputs.GetServicesPlainArgsBuilder
import com.pulumi.alicloud.fc.kotlin.inputs.GetTriggersPlainArgs
import com.pulumi.alicloud.fc.kotlin.inputs.GetTriggersPlainArgsBuilder
import com.pulumi.alicloud.fc.kotlin.inputs.GetZonesPlainArgs
import com.pulumi.alicloud.fc.kotlin.inputs.GetZonesPlainArgsBuilder
import com.pulumi.alicloud.fc.kotlin.outputs.GetCustomDomainsResult
import com.pulumi.alicloud.fc.kotlin.outputs.GetFunctionsResult
import com.pulumi.alicloud.fc.kotlin.outputs.GetServiceResult
import com.pulumi.alicloud.fc.kotlin.outputs.GetServicesResult
import com.pulumi.alicloud.fc.kotlin.outputs.GetTriggersResult
import com.pulumi.alicloud.fc.kotlin.outputs.GetZonesResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.fc.kotlin.outputs.GetCustomDomainsResult.Companion.toKotlin as getCustomDomainsResultToKotlin
import com.pulumi.alicloud.fc.kotlin.outputs.GetFunctionsResult.Companion.toKotlin as getFunctionsResultToKotlin
import com.pulumi.alicloud.fc.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.alicloud.fc.kotlin.outputs.GetServicesResult.Companion.toKotlin as getServicesResultToKotlin
import com.pulumi.alicloud.fc.kotlin.outputs.GetTriggersResult.Companion.toKotlin as getTriggersResultToKotlin
import com.pulumi.alicloud.fc.kotlin.outputs.GetZonesResult.Companion.toKotlin as getZonesResultToKotlin

public object FcFunctions {
    /**
     * This data source provides the Function Compute custom domains of the current Alibaba Cloud user.
     * > **NOTE:** Available in 1.98.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const fcDomains = alicloud.fc.getCustomDomains({
     *     nameRegex: "sample_fc_custom_domain",
     * });
     * export const firstFcCustomDomainName = fcDomainsDs.domains[0].domainName;
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * fc_domains = alicloud.fc.get_custom_domains(name_regex="sample_fc_custom_domain")
     * pulumi.export("firstFcCustomDomainName", fc_domains_ds["domains"][0]["domainName"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var fcDomains = AliCloud.FC.GetCustomDomains.Invoke(new()
     *     {
     *         NameRegex = "sample_fc_custom_domain",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstFcCustomDomainName"] = fcDomainsDs&#46;Domains[0].DomainName,
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := fc.GetCustomDomains(ctx, &fc.GetCustomDomainsArgs{
     * 			NameRegex: pulumi.StringRef("sample_fc_custom_domain"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstFcCustomDomainName", fcDomainsDs.Domains[0].DomainName)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.fc.FcFunctions;
     * import com.pulumi.alicloud.fc.inputs.GetCustomDomainsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var fcDomains = FcFunctions.getCustomDomains(GetCustomDomainsArgs.builder()
     *             .nameRegex("sample_fc_custom_domain")
     *             .build());
     *         ctx.export("firstFcCustomDomainName", fcDomainsDs.domains()[0].domainName());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   fcDomains:
     *     fn::invoke:
     *       Function: alicloud:fc:getCustomDomains
     *       Arguments:
     *         nameRegex: sample_fc_custom_domain
     * outputs:
     *   firstFcCustomDomainName: ${fcDomainsDs.domains[0].domainName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCustomDomains.
     * @return A collection of values returned by getCustomDomains.
     */
    public suspend fun getCustomDomains(argument: GetCustomDomainsPlainArgs): GetCustomDomainsResult =
        getCustomDomainsResultToKotlin(getCustomDomainsPlain(argument.toJava()).await())

    /**
     * @see [getCustomDomains].
     * @param ids A list of functions ids.
     * @param nameRegex A regex string to filter results by Function Compute custom domain name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getCustomDomains.
     */
    public suspend fun getCustomDomains(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetCustomDomainsResult {
        val argument = GetCustomDomainsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getCustomDomainsResultToKotlin(getCustomDomainsPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomDomains].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;fc&#46;kotlin&#46;inputs&#46;GetCustomDomainsPlainArgs].
     * @return A collection of values returned by getCustomDomains.
     */
    public suspend fun getCustomDomains(argument: suspend GetCustomDomainsPlainArgsBuilder.() -> Unit): GetCustomDomainsResult {
        val builder = GetCustomDomainsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomDomainsResultToKotlin(getCustomDomainsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Function Compute functions of the current Alibaba Cloud user.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const functionsDs = alicloud.fc.getFunctions({
     *     serviceName: "sample_service",
     *     nameRegex: "sample_fc_function",
     * });
     * export const firstFcFunctionName = functionsDs.then(functionsDs => functionsDs.functions?.[0]?.name);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * functions_ds = alicloud.fc.get_functions(service_name="sample_service",
     *     name_regex="sample_fc_function")
     * pulumi.export("firstFcFunctionName", functions_ds.functions[0].name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var functionsDs = AliCloud.FC.GetFunctions.Invoke(new()
     *     {
     *         ServiceName = "sample_service",
     *         NameRegex = "sample_fc_function",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstFcFunctionName"] = functionsDs&#46;Apply(getFunctionsResult => getFunctionsResult&#46;Functions[0]?.Name),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		functionsDs, err := fc.GetFunctions(ctx, &fc.GetFunctionsArgs{
     * 			ServiceName: "sample_service",
     * 			NameRegex:   pulumi.StringRef("sample_fc_function"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstFcFunctionName", functionsDs.Functions[0].Name)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.fc.FcFunctions;
     * import com.pulumi.alicloud.fc.inputs.GetFunctionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var functionsDs = FcFunctions.getFunctions(GetFunctionsArgs.builder()
     *             .serviceName("sample_service")
     *             .nameRegex("sample_fc_function")
     *             .build());
     *         ctx.export("firstFcFunctionName", functionsDs.applyValue(getFunctionsResult -> getFunctionsResult.functions()[0].name()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   functionsDs:
     *     fn::invoke:
     *       Function: alicloud:fc:getFunctions
     *       Arguments:
     *         serviceName: sample_service
     *         nameRegex: sample_fc_function
     * outputs:
     *   firstFcFunctionName: ${functionsDs.functions[0].name}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getFunctions.
     * @return A collection of values returned by getFunctions.
     */
    public suspend fun getFunctions(argument: GetFunctionsPlainArgs): GetFunctionsResult =
        getFunctionsResultToKotlin(getFunctionsPlain(argument.toJava()).await())

    /**
     * @see [getFunctions].
     * @param ids A list of functions ids.
     * @param nameRegex A regex string to filter results by function name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param serviceName Name of the service that contains the functions to find.
     * @return A collection of values returned by getFunctions.
     */
    public suspend fun getFunctions(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        serviceName: String,
    ): GetFunctionsResult {
        val argument = GetFunctionsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            serviceName = serviceName,
        )
        return getFunctionsResultToKotlin(getFunctionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getFunctions].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;fc&#46;kotlin&#46;inputs&#46;GetFunctionsPlainArgs].
     * @return A collection of values returned by getFunctions.
     */
    public suspend fun getFunctions(argument: suspend GetFunctionsPlainArgsBuilder.() -> Unit): GetFunctionsResult {
        val builder = GetFunctionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFunctionsResultToKotlin(getFunctionsPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can open FC service automatically. If the service has been opened, it will return opened.
     * For information about FC and how to use it, see [What is FC](https://www.alibabacloud.com/help/en/product/50980.htm).
     * > **NOTE:** Available since v1.112.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.fc.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.fc.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.FC.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := fc.LookupService(ctx, &fc.LookupServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.fc.FcFunctions;
     * import com.pulumi.alicloud.fc.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = FcFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:fc:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
     * > **NOTE:** Setting `enable = "On"` to open the FC service that means you have read and agreed the [FC Terms of Service](https://help.aliyun.com/document_detail/52972.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;fc&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Function Compute services of the current Alibaba Cloud user.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const fcServicesDs = alicloud.fc.getServices({
     *     nameRegex: "sample_fc_service",
     * });
     * export const firstFcServiceName = fcServicesDs.then(fcServicesDs => fcServicesDs.services?.[0]?.name);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * fc_services_ds = alicloud.fc.get_services(name_regex="sample_fc_service")
     * pulumi.export("firstFcServiceName", fc_services_ds.services[0].name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var fcServicesDs = AliCloud.FC.GetServices.Invoke(new()
     *     {
     *         NameRegex = "sample_fc_service",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstFcServiceName"] = fcServicesDs&#46;Apply(getServicesResult => getServicesResult&#46;Services[0]?.Name),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		fcServicesDs, err := fc.GetServices(ctx, &fc.GetServicesArgs{
     * 			NameRegex: pulumi.StringRef("sample_fc_service"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstFcServiceName", fcServicesDs.Services[0].Name)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.fc.FcFunctions;
     * import com.pulumi.alicloud.fc.inputs.GetServicesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var fcServicesDs = FcFunctions.getServices(GetServicesArgs.builder()
     *             .nameRegex("sample_fc_service")
     *             .build());
     *         ctx.export("firstFcServiceName", fcServicesDs.applyValue(getServicesResult -> getServicesResult.services()[0].name()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   fcServicesDs:
     *     fn::invoke:
     *       Function: alicloud:fc:getServices
     *       Arguments:
     *         nameRegex: sample_fc_service
     * outputs:
     *   firstFcServiceName: ${fcServicesDs.services[0].name}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServices.
     * @return A collection of values returned by getServices.
     */
    public suspend fun getServices(argument: GetServicesPlainArgs): GetServicesResult =
        getServicesResultToKotlin(getServicesPlain(argument.toJava()).await())

    /**
     * @see [getServices].
     * @param ids A list of FC services ids.
     * @param nameRegex A regex string to filter results by FC service name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getServices.
     */
    public suspend fun getServices(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetServicesResult {
        val argument = GetServicesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getServicesResultToKotlin(getServicesPlain(argument.toJava()).await())
    }

    /**
     * @see [getServices].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;fc&#46;kotlin&#46;inputs&#46;GetServicesPlainArgs].
     * @return A collection of values returned by getServices.
     */
    public suspend fun getServices(argument: suspend GetServicesPlainArgsBuilder.() -> Unit): GetServicesResult {
        val builder = GetServicesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServicesResultToKotlin(getServicesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Function Compute triggers of the current Alibaba Cloud user.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const fcTriggersDs = alicloud.fc.getTriggers({
     *     serviceName: "sample_service",
     *     functionName: "sample_function",
     *     nameRegex: "sample_fc_trigger",
     * });
     * export const firstFcTriggerName = fcTriggersDs.then(fcTriggersDs => fcTriggersDs.triggers?.[0]?.name);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * fc_triggers_ds = alicloud.fc.get_triggers(service_name="sample_service",
     *     function_name="sample_function",
     *     name_regex="sample_fc_trigger")
     * pulumi.export("firstFcTriggerName", fc_triggers_ds.triggers[0].name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var fcTriggersDs = AliCloud.FC.GetTriggers.Invoke(new()
     *     {
     *         ServiceName = "sample_service",
     *         FunctionName = "sample_function",
     *         NameRegex = "sample_fc_trigger",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstFcTriggerName"] = fcTriggersDs&#46;Apply(getTriggersResult => getTriggersResult&#46;Triggers[0]?.Name),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		fcTriggersDs, err := fc.GetTriggers(ctx, &fc.GetTriggersArgs{
     * 			ServiceName:  "sample_service",
     * 			FunctionName: "sample_function",
     * 			NameRegex:    pulumi.StringRef("sample_fc_trigger"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstFcTriggerName", fcTriggersDs.Triggers[0].Name)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.fc.FcFunctions;
     * import com.pulumi.alicloud.fc.inputs.GetTriggersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var fcTriggersDs = FcFunctions.getTriggers(GetTriggersArgs.builder()
     *             .serviceName("sample_service")
     *             .functionName("sample_function")
     *             .nameRegex("sample_fc_trigger")
     *             .build());
     *         ctx.export("firstFcTriggerName", fcTriggersDs.applyValue(getTriggersResult -> getTriggersResult.triggers()[0].name()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   fcTriggersDs:
     *     fn::invoke:
     *       Function: alicloud:fc:getTriggers
     *       Arguments:
     *         serviceName: sample_service
     *         functionName: sample_function
     *         nameRegex: sample_fc_trigger
     * outputs:
     *   firstFcTriggerName: ${fcTriggersDs.triggers[0].name}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTriggers.
     * @return A collection of values returned by getTriggers.
     */
    public suspend fun getTriggers(argument: GetTriggersPlainArgs): GetTriggersResult =
        getTriggersResultToKotlin(getTriggersPlain(argument.toJava()).await())

    /**
     * @see [getTriggers].
     * @param functionName FC function name.
     * @param ids A list of FC triggers ids.
     * @param nameRegex A regex string to filter results by FC trigger name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param serviceName FC service name.
     * @return A collection of values returned by getTriggers.
     */
    public suspend fun getTriggers(
        functionName: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        serviceName: String,
    ): GetTriggersResult {
        val argument = GetTriggersPlainArgs(
            functionName = functionName,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            serviceName = serviceName,
        )
        return getTriggersResultToKotlin(getTriggersPlain(argument.toJava()).await())
    }

    /**
     * @see [getTriggers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;fc&#46;kotlin&#46;inputs&#46;GetTriggersPlainArgs].
     * @return A collection of values returned by getTriggers.
     */
    public suspend fun getTriggers(argument: suspend GetTriggersPlainArgsBuilder.() -> Unit): GetTriggersResult {
        val builder = GetTriggersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTriggersResultToKotlin(getTriggersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides availability zones for FunctionCompute that can be accessed by an Alibaba Cloud account within the region configured in the provider.
     * > **NOTE:** Available in v1.74.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const zonesIds = alicloud.fc.getZones({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * zones_ids = alicloud.fc.get_zones()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var zonesIds = AliCloud.FC.GetZones.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		_, err := fc.GetZones(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.fc.FcFunctions;
     * import com.pulumi.alicloud.fc.inputs.GetZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var zonesIds = FcFunctions.getZones();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   zonesIds:
     *     fn::invoke:
     *       Function: alicloud:fc:getZones
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZones.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: GetZonesPlainArgs): GetZonesResult =
        getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())

    /**
     * @see [getZones].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(outputFile: String? = null): GetZonesResult {
        val argument = GetZonesPlainArgs(
            outputFile = outputFile,
        )
        return getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;fc&#46;kotlin&#46;inputs&#46;GetZonesPlainArgs].
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: suspend GetZonesPlainArgsBuilder.() -> Unit): GetZonesResult {
        val builder = GetZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZonesResultToKotlin(getZonesPlain(builtArgument.toJava()).await())
    }
}
