@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin

import com.pulumi.alicloud.fc.FunctionArgs.builder
import com.pulumi.alicloud.fc.kotlin.inputs.FunctionCustomContainerConfigArgs
import com.pulumi.alicloud.fc.kotlin.inputs.FunctionCustomContainerConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Alicloud Function Compute Function resource. Function allows you to trigger execution of code in response to events in Alibaba Cloud. The Function itself includes source code and runtime configuration.
 *  For information about Service and how to use it, see [What is Function Compute](https://www.alibabacloud.com/help/en/fc/developer-reference/api-createfunction).
 * > **NOTE:** The resource requires a provider field 'account_id'. See account_id.
 * > **NOTE:** Available since v1.10.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const defaultProject = new alicloud.log.Project("default", {projectName: `example-value-${_default.result}`});
 * const defaultStore = new alicloud.log.Store("default", {
 *     projectName: defaultProject.name,
 *     logstoreName: "example-value",
 * });
 * const defaultRole = new alicloud.ram.Role("default", {
 *     name: `fcservicerole-${_default.result}`,
 *     document: `  {
 *       "Statement": [
 *         {
 *           "Action": "sts:AssumeRole",
 *           "Effect": "Allow",
 *           "Principal": {
 *             "Service": [
 *               "fc.aliyuncs.com"
 *             ]
 *           }
 *         }
 *       ],
 *       "Version": "1"
 *   }
 * `,
 *     description: "this is a example",
 *     force: true,
 * });
 * const defaultRolePolicyAttachment = new alicloud.ram.RolePolicyAttachment("default", {
 *     roleName: defaultRole.name,
 *     policyName: "AliyunLogFullAccess",
 *     policyType: "System",
 * });
 * const defaultService = new alicloud.fc.Service("default", {
 *     name: `example-value-${_default.result}`,
 *     description: "example-value",
 *     role: defaultRole.arn,
 *     logConfig: {
 *         project: defaultProject.name,
 *         logstore: defaultStore.name,
 *         enableInstanceMetrics: true,
 *         enableRequestMetrics: true,
 *     },
 * });
 * const defaultBucket = new alicloud.oss.Bucket("default", {bucket: `terraform-example-${_default.result}`});
 * // If you upload the function by OSS Bucket, you need to specify path can't upload by content.
 * const defaultBucketObject = new alicloud.oss.BucketObject("default", {
 *     bucket: defaultBucket.id,
 *     key: "index.py",
 *     content: `import logging
 * def handler(event, context):
 * logger = logging.getLogger()
 * logger.info('hello world')
 * return 'hello world'`,
 * });
 * const foo = new alicloud.fc.Function("foo", {
 *     service: defaultService.name,
 *     name: "terraform-example",
 *     description: "example",
 *     ossBucket: defaultBucket.id,
 *     ossKey: defaultBucketObject.key,
 *     memorySize: 512,
 *     runtime: "python3.10",
 *     handler: "hello.handler",
 *     environmentVariables: {
 *         prefix: "terraform",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * default_project = alicloud.log.Project("default", project_name=f"example-value-{default['result']}")
 * default_store = alicloud.log.Store("default",
 *     project_name=default_project.name,
 *     logstore_name="example-value")
 * default_role = alicloud.ram.Role("default",
 *     name=f"fcservicerole-{default['result']}",
 *     document="""  {
 *       "Statement": [
 *         {
 *           "Action": "sts:AssumeRole",
 *           "Effect": "Allow",
 *           "Principal": {
 *             "Service": [
 *               "fc.aliyuncs.com"
 *             ]
 *           }
 *         }
 *       ],
 *       "Version": "1"
 *   }
 * """,
 *     description="this is a example",
 *     force=True)
 * default_role_policy_attachment = alicloud.ram.RolePolicyAttachment("default",
 *     role_name=default_role.name,
 *     policy_name="AliyunLogFullAccess",
 *     policy_type="System")
 * default_service = alicloud.fc.Service("default",
 *     name=f"example-value-{default['result']}",
 *     description="example-value",
 *     role=default_role.arn,
 *     log_config={
 *         "project": default_project.name,
 *         "logstore": default_store.name,
 *         "enable_instance_metrics": True,
 *         "enable_request_metrics": True,
 *     })
 * default_bucket = alicloud.oss.Bucket("default", bucket=f"terraform-example-{default['result']}")
 * # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
 * default_bucket_object = alicloud.oss.BucketObject("default",
 *     bucket=default_bucket.id,
 *     key="index.py",
 *     content="""import logging
 * def handler(event, context):
 * logger = logging.getLogger()
 * logger.info('hello world')
 * return 'hello world'""")
 * foo = alicloud.fc.Function("foo",
 *     service=default_service.name,
 *     name="terraform-example",
 *     description="example",
 *     oss_bucket=default_bucket.id,
 *     oss_key=default_bucket_object.key,
 *     memory_size=512,
 *     runtime="python3.10",
 *     handler="hello.handler",
 *     environment_variables={
 *         "prefix": "terraform",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var defaultProject = new AliCloud.Log.Project("default", new()
 *     {
 *         ProjectName = $"example-value-{@default.Result}",
 *     });
 *     var defaultStore = new AliCloud.Log.Store("default", new()
 *     {
 *         ProjectName = defaultProject.Name,
 *         LogstoreName = "example-value",
 *     });
 *     var defaultRole = new AliCloud.Ram.Role("default", new()
 *     {
 *         Name = $"fcservicerole-{@default.Result}",
 *         Document = @"  {
 *       ""Statement"": [
 *         {
 *           ""Action"": ""sts:AssumeRole"",
 *           ""Effect"": ""Allow"",
 *           ""Principal"": {
 *             ""Service"": [
 *               ""fc.aliyuncs.com""
 *             ]
 *           }
 *         }
 *       ],
 *       ""Version"": ""1""
 *   }
 * ",
 *         Description = "this is a example",
 *         Force = true,
 *     });
 *     var defaultRolePolicyAttachment = new AliCloud.Ram.RolePolicyAttachment("default", new()
 *     {
 *         RoleName = defaultRole.Name,
 *         PolicyName = "AliyunLogFullAccess",
 *         PolicyType = "System",
 *     });
 *     var defaultService = new AliCloud.FC.Service("default", new()
 *     {
 *         Name = $"example-value-{@default.Result}",
 *         Description = "example-value",
 *         Role = defaultRole.Arn,
 *         LogConfig = new AliCloud.FC.Inputs.ServiceLogConfigArgs
 *         {
 *             Project = defaultProject.Name,
 *             Logstore = defaultStore.Name,
 *             EnableInstanceMetrics = true,
 *             EnableRequestMetrics = true,
 *         },
 *     });
 *     var defaultBucket = new AliCloud.Oss.Bucket("default", new()
 *     {
 *         BucketName = $"terraform-example-{@default.Result}",
 *     });
 *     // If you upload the function by OSS Bucket, you need to specify path can't upload by content.
 *     var defaultBucketObject = new AliCloud.Oss.BucketObject("default", new()
 *     {
 *         Bucket = defaultBucket.Id,
 *         Key = "index.py",
 *         Content = @"import logging
 * def handler(event, context):
 * logger = logging.getLogger()
 * logger.info('hello world')
 * return 'hello world'",
 *     });
 *     var foo = new AliCloud.FC.Function("foo", new()
 *     {
 *         Service = defaultService.Name,
 *         Name = "terraform-example",
 *         Description = "example",
 *         OssBucket = defaultBucket.Id,
 *         OssKey = defaultBucketObject.Key,
 *         MemorySize = 512,
 *         Runtime = "python3.10",
 *         Handler = "hello.handler",
 *         EnvironmentVariables =
 *         {
 *             { "prefix", "terraform" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fc"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultProject, err := log.NewProject(ctx, "default", &log.ProjectArgs{
 * 			ProjectName: pulumi.Sprintf("example-value-%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultStore, err := log.NewStore(ctx, "default", &log.StoreArgs{
 * 			ProjectName:  defaultProject.Name,
 * 			LogstoreName: pulumi.String("example-value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultRole, err := ram.NewRole(ctx, "default", &ram.RoleArgs{
 * 			Name: pulumi.Sprintf("fcservicerole-%v", _default.Result),
 * 			Document: pulumi.String(`  {
 *       "Statement": [
 *         {
 *           "Action": "sts:AssumeRole",
 *           "Effect": "Allow",
 *           "Principal": {
 *             "Service": [
 *               "fc.aliyuncs.com"
 *             ]
 *           }
 *         }
 *       ],
 *       "Version": "1"
 *   }
 * `),
 * 			Description: pulumi.String("this is a example"),
 * 			Force:       pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ram.NewRolePolicyAttachment(ctx, "default", &ram.RolePolicyAttachmentArgs{
 * 			RoleName:   defaultRole.Name,
 * 			PolicyName: pulumi.String("AliyunLogFullAccess"),
 * 			PolicyType: pulumi.String("System"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultService, err := fc.NewService(ctx, "default", &fc.ServiceArgs{
 * 			Name:        pulumi.Sprintf("example-value-%v", _default.Result),
 * 			Description: pulumi.String("example-value"),
 * 			Role:        defaultRole.Arn,
 * 			LogConfig: &fc.ServiceLogConfigArgs{
 * 				Project:               defaultProject.Name,
 * 				Logstore:              defaultStore.Name,
 * 				EnableInstanceMetrics: pulumi.Bool(true),
 * 				EnableRequestMetrics:  pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBucket, err := oss.NewBucket(ctx, "default", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// If you upload the function by OSS Bucket, you need to specify path can't upload by content.
 * 		defaultBucketObject, err := oss.NewBucketObject(ctx, "default", &oss.BucketObjectArgs{
 * 			Bucket:  defaultBucket.ID(),
 * 			Key:     pulumi.String("index.py"),
 * 			Content: pulumi.String("import logging \ndef handler(event, context): \nlogger = logging.getLogger() \nlogger.info('hello world') \nreturn 'hello world'"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = fc.NewFunction(ctx, "foo", &fc.FunctionArgs{
 * 			Service:     defaultService.Name,
 * 			Name:        pulumi.String("terraform-example"),
 * 			Description: pulumi.String("example"),
 * 			OssBucket:   defaultBucket.ID(),
 * 			OssKey:      defaultBucketObject.Key,
 * 			MemorySize:  pulumi.Int(512),
 * 			Runtime:     pulumi.String("python3.10"),
 * 			Handler:     pulumi.String("hello.handler"),
 * 			EnvironmentVariables: pulumi.StringMap{
 * 				"prefix": pulumi.String("terraform"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.ram.Role;
 * import com.pulumi.alicloud.ram.RoleArgs;
 * import com.pulumi.alicloud.ram.RolePolicyAttachment;
 * import com.pulumi.alicloud.ram.RolePolicyAttachmentArgs;
 * import com.pulumi.alicloud.fc.Service;
 * import com.pulumi.alicloud.fc.ServiceArgs;
 * import com.pulumi.alicloud.fc.inputs.ServiceLogConfigArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.oss.BucketObject;
 * import com.pulumi.alicloud.oss.BucketObjectArgs;
 * import com.pulumi.alicloud.fc.Function;
 * import com.pulumi.alicloud.fc.FunctionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var defaultProject = new Project("defaultProject", ProjectArgs.builder()
 *             .projectName(String.format("example-value-%s", default_.result()))
 *             .build());
 *         var defaultStore = new Store("defaultStore", StoreArgs.builder()
 *             .projectName(defaultProject.name())
 *             .logstoreName("example-value")
 *             .build());
 *         var defaultRole = new Role("defaultRole", RoleArgs.builder()
 *             .name(String.format("fcservicerole-%s", default_.result()))
 *             .document("""
 *   {
 *       "Statement": [
 *         {
 *           "Action": "sts:AssumeRole",
 *           "Effect": "Allow",
 *           "Principal": {
 *             "Service": [
 *               "fc.aliyuncs.com"
 *             ]
 *           }
 *         }
 *       ],
 *       "Version": "1"
 *   }
 *             """)
 *             .description("this is a example")
 *             .force(true)
 *             .build());
 *         var defaultRolePolicyAttachment = new RolePolicyAttachment("defaultRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .roleName(defaultRole.name())
 *             .policyName("AliyunLogFullAccess")
 *             .policyType("System")
 *             .build());
 *         var defaultService = new Service("defaultService", ServiceArgs.builder()
 *             .name(String.format("example-value-%s", default_.result()))
 *             .description("example-value")
 *             .role(defaultRole.arn())
 *             .logConfig(ServiceLogConfigArgs.builder()
 *                 .project(defaultProject.name())
 *                 .logstore(defaultStore.name())
 *                 .enableInstanceMetrics(true)
 *                 .enableRequestMetrics(true)
 *                 .build())
 *             .build());
 *         var defaultBucket = new Bucket("defaultBucket", BucketArgs.builder()
 *             .bucket(String.format("terraform-example-%s", default_.result()))
 *             .build());
 *         // If you upload the function by OSS Bucket, you need to specify path can't upload by content.
 *         var defaultBucketObject = new BucketObject("defaultBucketObject", BucketObjectArgs.builder()
 *             .bucket(defaultBucket.id())
 *             .key("index.py")
 *             .content("""
 * import logging
 * def handler(event, context):
 * logger = logging.getLogger()
 * logger.info('hello world')
 * return 'hello world'            """)
 *             .build());
 *         var foo = new Function("foo", FunctionArgs.builder()
 *             .service(defaultService.name())
 *             .name("terraform-example")
 *             .description("example")
 *             .ossBucket(defaultBucket.id())
 *             .ossKey(defaultBucketObject.key())
 *             .memorySize("512")
 *             .runtime("python3.10")
 *             .handler("hello.handler")
 *             .environmentVariables(Map.of("prefix", "terraform"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   defaultProject:
 *     type: alicloud:log:Project
 *     name: default
 *     properties:
 *       projectName: example-value-${default.result}
 *   defaultStore:
 *     type: alicloud:log:Store
 *     name: default
 *     properties:
 *       projectName: ${defaultProject.name}
 *       logstoreName: example-value
 *   defaultRole:
 *     type: alicloud:ram:Role
 *     name: default
 *     properties:
 *       name: fcservicerole-${default.result}
 *       document: |2
 *           {
 *               "Statement": [
 *                 {
 *                   "Action": "sts:AssumeRole",
 *                   "Effect": "Allow",
 *                   "Principal": {
 *                     "Service": [
 *                       "fc.aliyuncs.com"
 *                     ]
 *                   }
 *                 }
 *               ],
 *               "Version": "1"
 *           }
 *       description: this is a example
 *       force: true
 *   defaultRolePolicyAttachment:
 *     type: alicloud:ram:RolePolicyAttachment
 *     name: default
 *     properties:
 *       roleName: ${defaultRole.name}
 *       policyName: AliyunLogFullAccess
 *       policyType: System
 *   defaultService:
 *     type: alicloud:fc:Service
 *     name: default
 *     properties:
 *       name: example-value-${default.result}
 *       description: example-value
 *       role: ${defaultRole.arn}
 *       logConfig:
 *         project: ${defaultProject.name}
 *         logstore: ${defaultStore.name}
 *         enableInstanceMetrics: true
 *         enableRequestMetrics: true
 *   defaultBucket:
 *     type: alicloud:oss:Bucket
 *     name: default
 *     properties:
 *       bucket: terraform-example-${default.result}
 *   # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
 *   defaultBucketObject:
 *     type: alicloud:oss:BucketObject
 *     name: default
 *     properties:
 *       bucket: ${defaultBucket.id}
 *       key: index.py
 *       content: "import logging \ndef handler(event, context): \nlogger = logging.getLogger() \nlogger.info('hello world') \nreturn 'hello world'"
 *   foo:
 *     type: alicloud:fc:Function
 *     properties:
 *       service: ${defaultService.name}
 *       name: terraform-example
 *       description: example
 *       ossBucket: ${defaultBucket.id}
 *       ossKey: ${defaultBucketObject.key}
 *       memorySize: '512'
 *       runtime: python3.10
 *       handler: hello.handler
 *       environmentVariables:
 *         prefix: terraform
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use to the existing fc module
 * to create a function quickly and set several triggers for it.
 * ## Import
 * Function Compute function can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:fc/function:Function foo my-fc-service:hello-world
 * ```
 * @property caPort The port that the function listen to, only valid for [custom runtime](https://www&#46;alibabacloud&#46;com/help/doc-detail/132044&#46;htm) and [custom container runtime](https://www.alibabacloud.com/help/doc-detail/179368.htm).
 * @property codeChecksum The checksum (crc64) of the function code.Used to trigger updates.The value can be generated by data source alicloud_file_crc64_checksum.
 * > **NOTE:** For more information, see [Limits](https://www.alibabacloud.com/help/doc-detail/51907.htm).
 * @property customContainerConfig The configuration for custom container runtime.See `custom_container_config` below.
 * @property description The Function Compute function description.
 * @property environmentVariables A map that defines environment variables for the function.
 * @property filename The path to the function's deployment package within the local filesystem. It is conflict with the `oss_`-prefixed options.
 * @property handler The function [entry point](https://www.alibabacloud.com/help/doc-detail/157704.htm) in your code.
 * @property initializationTimeout The maximum length of time, in seconds, that the function's initialization should be run for.
 * @property initializer The entry point of the function's [initialization](https://www.alibabacloud.com/help/doc-detail/157704.htm).
 * @property instanceConcurrency The maximum number of requests can be executed concurrently within the single function instance.
 * @property instanceType The instance type of the function.
 * @property layers The configuration for layers.
 * @property memorySize Amount of memory in MB your function can use at runtime. Defaults to `128`. Limits to [128, 32768].
 * @property name The Function Compute function name. It is the only in one service and is conflict with "name_prefix".
 * @property namePrefix Setting a prefix to get a only function name. It is conflict with "name".
 * @property ossBucket The OSS bucket location containing the function's deployment package. Conflicts with `filename`. This bucket must reside in the same Alibaba Cloud region where you are creating the function.
 * @property ossKey The OSS key of an object containing the function's deployment package. Conflicts with `filename`.
 * @property runtime See [Runtimes][https://www&#46;alibabacloud&#46;com/help/zh/function-compute/latest/manage-functions#multiTask3514] for valid values.
 * @property service The Function Compute service name.
 * @property timeout The amount of time your function has to run in seconds.
 */
public data class FunctionArgs(
    public val caPort: Output<Int>? = null,
    public val codeChecksum: Output<String>? = null,
    public val customContainerConfig: Output<FunctionCustomContainerConfigArgs>? = null,
    public val description: Output<String>? = null,
    public val environmentVariables: Output<Map<String, String>>? = null,
    public val filename: Output<String>? = null,
    public val handler: Output<String>? = null,
    public val initializationTimeout: Output<Int>? = null,
    public val initializer: Output<String>? = null,
    public val instanceConcurrency: Output<Int>? = null,
    public val instanceType: Output<String>? = null,
    public val layers: Output<List<String>>? = null,
    public val memorySize: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val ossBucket: Output<String>? = null,
    public val ossKey: Output<String>? = null,
    public val runtime: Output<String>? = null,
    public val service: Output<String>? = null,
    public val timeout: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.FunctionArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.FunctionArgs =
        com.pulumi.alicloud.fc.FunctionArgs.builder()
            .caPort(caPort?.applyValue({ args0 -> args0 }))
            .codeChecksum(codeChecksum?.applyValue({ args0 -> args0 }))
            .customContainerConfig(
                customContainerConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .filename(filename?.applyValue({ args0 -> args0 }))
            .handler(handler?.applyValue({ args0 -> args0 }))
            .initializationTimeout(initializationTimeout?.applyValue({ args0 -> args0 }))
            .initializer(initializer?.applyValue({ args0 -> args0 }))
            .instanceConcurrency(instanceConcurrency?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .layers(layers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .memorySize(memorySize?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .ossBucket(ossBucket?.applyValue({ args0 -> args0 }))
            .ossKey(ossKey?.applyValue({ args0 -> args0 }))
            .runtime(runtime?.applyValue({ args0 -> args0 }))
            .service(service?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionArgs].
 */
@PulumiTagMarker
public class FunctionArgsBuilder internal constructor() {
    private var caPort: Output<Int>? = null

    private var codeChecksum: Output<String>? = null

    private var customContainerConfig: Output<FunctionCustomContainerConfigArgs>? = null

    private var description: Output<String>? = null

    private var environmentVariables: Output<Map<String, String>>? = null

    private var filename: Output<String>? = null

    private var handler: Output<String>? = null

    private var initializationTimeout: Output<Int>? = null

    private var initializer: Output<String>? = null

    private var instanceConcurrency: Output<Int>? = null

    private var instanceType: Output<String>? = null

    private var layers: Output<List<String>>? = null

    private var memorySize: Output<Int>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var ossBucket: Output<String>? = null

    private var ossKey: Output<String>? = null

    private var runtime: Output<String>? = null

    private var service: Output<String>? = null

    private var timeout: Output<Int>? = null

    /**
     * @param value The port that the function listen to, only valid for [custom runtime](https://www&#46;alibabacloud&#46;com/help/doc-detail/132044&#46;htm) and [custom container runtime](https://www.alibabacloud.com/help/doc-detail/179368.htm).
     */
    @JvmName("smrmcmxkgcgneobs")
    public suspend fun caPort(`value`: Output<Int>) {
        this.caPort = value
    }

    /**
     * @param value The checksum (crc64) of the function code.Used to trigger updates.The value can be generated by data source alicloud_file_crc64_checksum.
     * > **NOTE:** For more information, see [Limits](https://www.alibabacloud.com/help/doc-detail/51907.htm).
     */
    @JvmName("trhsoqegtljwmiok")
    public suspend fun codeChecksum(`value`: Output<String>) {
        this.codeChecksum = value
    }

    /**
     * @param value The configuration for custom container runtime.See `custom_container_config` below.
     */
    @JvmName("ohwrdmooutcfkbls")
    public suspend fun customContainerConfig(`value`: Output<FunctionCustomContainerConfigArgs>) {
        this.customContainerConfig = value
    }

    /**
     * @param value The Function Compute function description.
     */
    @JvmName("soqfigmmtrrlagas")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A map that defines environment variables for the function.
     */
    @JvmName("euccryqorhwkkutf")
    public suspend fun environmentVariables(`value`: Output<Map<String, String>>) {
        this.environmentVariables = value
    }

    /**
     * @param value The path to the function's deployment package within the local filesystem. It is conflict with the `oss_`-prefixed options.
     */
    @JvmName("uoyjnimbnrcnambh")
    public suspend fun filename(`value`: Output<String>) {
        this.filename = value
    }

    /**
     * @param value The function [entry point](https://www.alibabacloud.com/help/doc-detail/157704.htm) in your code.
     */
    @JvmName("raovajpqptwqjdnb")
    public suspend fun handler(`value`: Output<String>) {
        this.handler = value
    }

    /**
     * @param value The maximum length of time, in seconds, that the function's initialization should be run for.
     */
    @JvmName("ageuejwltlgelmff")
    public suspend fun initializationTimeout(`value`: Output<Int>) {
        this.initializationTimeout = value
    }

    /**
     * @param value The entry point of the function's [initialization](https://www.alibabacloud.com/help/doc-detail/157704.htm).
     */
    @JvmName("njntqkjfpjrmmgst")
    public suspend fun initializer(`value`: Output<String>) {
        this.initializer = value
    }

    /**
     * @param value The maximum number of requests can be executed concurrently within the single function instance.
     */
    @JvmName("rupwurjjdsttpmts")
    public suspend fun instanceConcurrency(`value`: Output<Int>) {
        this.instanceConcurrency = value
    }

    /**
     * @param value The instance type of the function.
     */
    @JvmName("uqvwotfqxoccexog")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The configuration for layers.
     */
    @JvmName("pylmcemperogjxaq")
    public suspend fun layers(`value`: Output<List<String>>) {
        this.layers = value
    }

    @JvmName("nbelxqtrywpklotu")
    public suspend fun layers(vararg values: Output<String>) {
        this.layers = Output.all(values.asList())
    }

    /**
     * @param values The configuration for layers.
     */
    @JvmName("dsxfoyjcxuibcsku")
    public suspend fun layers(values: List<Output<String>>) {
        this.layers = Output.all(values)
    }

    /**
     * @param value Amount of memory in MB your function can use at runtime. Defaults to `128`. Limits to [128, 32768].
     */
    @JvmName("pbuilbchvcuuvtku")
    public suspend fun memorySize(`value`: Output<Int>) {
        this.memorySize = value
    }

    /**
     * @param value The Function Compute function name. It is the only in one service and is conflict with "name_prefix".
     */
    @JvmName("rxoyboobiestiskt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Setting a prefix to get a only function name. It is conflict with "name".
     */
    @JvmName("gogthgmvkdlpcahh")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value The OSS bucket location containing the function's deployment package. Conflicts with `filename`. This bucket must reside in the same Alibaba Cloud region where you are creating the function.
     */
    @JvmName("oelvfhkbooydwdxi")
    public suspend fun ossBucket(`value`: Output<String>) {
        this.ossBucket = value
    }

    /**
     * @param value The OSS key of an object containing the function's deployment package. Conflicts with `filename`.
     */
    @JvmName("urlkahqvcnlvigkw")
    public suspend fun ossKey(`value`: Output<String>) {
        this.ossKey = value
    }

    /**
     * @param value See [Runtimes][https://www&#46;alibabacloud&#46;com/help/zh/function-compute/latest/manage-functions#multiTask3514] for valid values.
     */
    @JvmName("vursjetfhhcxybxg")
    public suspend fun runtime(`value`: Output<String>) {
        this.runtime = value
    }

    /**
     * @param value The Function Compute service name.
     */
    @JvmName("gnihklnuqmugqqfy")
    public suspend fun service(`value`: Output<String>) {
        this.service = value
    }

    /**
     * @param value The amount of time your function has to run in seconds.
     */
    @JvmName("fovwbjxosqgbutrk")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value The port that the function listen to, only valid for [custom runtime](https://www&#46;alibabacloud&#46;com/help/doc-detail/132044&#46;htm) and [custom container runtime](https://www.alibabacloud.com/help/doc-detail/179368.htm).
     */
    @JvmName("uijebmbdmxmvxgui")
    public suspend fun caPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caPort = mapped
    }

    /**
     * @param value The checksum (crc64) of the function code.Used to trigger updates.The value can be generated by data source alicloud_file_crc64_checksum.
     * > **NOTE:** For more information, see [Limits](https://www.alibabacloud.com/help/doc-detail/51907.htm).
     */
    @JvmName("hfsuphirktgxpakm")
    public suspend fun codeChecksum(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeChecksum = mapped
    }

    /**
     * @param value The configuration for custom container runtime.See `custom_container_config` below.
     */
    @JvmName("jtygfjnukkmoibfk")
    public suspend fun customContainerConfig(`value`: FunctionCustomContainerConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customContainerConfig = mapped
    }

    /**
     * @param argument The configuration for custom container runtime.See `custom_container_config` below.
     */
    @JvmName("qsbecnejybfmcrvg")
    public suspend fun customContainerConfig(argument: suspend FunctionCustomContainerConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FunctionCustomContainerConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customContainerConfig = mapped
    }

    /**
     * @param value The Function Compute function description.
     */
    @JvmName("jncrllxkieyuujlx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A map that defines environment variables for the function.
     */
    @JvmName("fuintdkdweipsbty")
    public suspend fun environmentVariables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param values A map that defines environment variables for the function.
     */
    @JvmName("shajplcdcdjmnnov")
    public fun environmentVariables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value The path to the function's deployment package within the local filesystem. It is conflict with the `oss_`-prefixed options.
     */
    @JvmName("gilxxjwsfoesvkxi")
    public suspend fun filename(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filename = mapped
    }

    /**
     * @param value The function [entry point](https://www.alibabacloud.com/help/doc-detail/157704.htm) in your code.
     */
    @JvmName("xrhvbkkhthhroiiq")
    public suspend fun handler(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.handler = mapped
    }

    /**
     * @param value The maximum length of time, in seconds, that the function's initialization should be run for.
     */
    @JvmName("ennsvolvoqopigmp")
    public suspend fun initializationTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initializationTimeout = mapped
    }

    /**
     * @param value The entry point of the function's [initialization](https://www.alibabacloud.com/help/doc-detail/157704.htm).
     */
    @JvmName("uuorlwghsdqqbddc")
    public suspend fun initializer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initializer = mapped
    }

    /**
     * @param value The maximum number of requests can be executed concurrently within the single function instance.
     */
    @JvmName("gcxvyvekqsvesibt")
    public suspend fun instanceConcurrency(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceConcurrency = mapped
    }

    /**
     * @param value The instance type of the function.
     */
    @JvmName("ikqydjrlbhikxxjj")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The configuration for layers.
     */
    @JvmName("dbkkoqvfopqdxcjr")
    public suspend fun layers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.layers = mapped
    }

    /**
     * @param values The configuration for layers.
     */
    @JvmName("xjdjquxuskpteibw")
    public suspend fun layers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.layers = mapped
    }

    /**
     * @param value Amount of memory in MB your function can use at runtime. Defaults to `128`. Limits to [128, 32768].
     */
    @JvmName("qytpkmddlkklklsf")
    public suspend fun memorySize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memorySize = mapped
    }

    /**
     * @param value The Function Compute function name. It is the only in one service and is conflict with "name_prefix".
     */
    @JvmName("llheeoupqdoiadlt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Setting a prefix to get a only function name. It is conflict with "name".
     */
    @JvmName("gqmimlsiaqteuqtq")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value The OSS bucket location containing the function's deployment package. Conflicts with `filename`. This bucket must reside in the same Alibaba Cloud region where you are creating the function.
     */
    @JvmName("itnflulokposuift")
    public suspend fun ossBucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossBucket = mapped
    }

    /**
     * @param value The OSS key of an object containing the function's deployment package. Conflicts with `filename`.
     */
    @JvmName("basjuwmquxtymggn")
    public suspend fun ossKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossKey = mapped
    }

    /**
     * @param value See [Runtimes][https://www&#46;alibabacloud&#46;com/help/zh/function-compute/latest/manage-functions#multiTask3514] for valid values.
     */
    @JvmName("ykrmdgwcqimitfsv")
    public suspend fun runtime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtime = mapped
    }

    /**
     * @param value The Function Compute service name.
     */
    @JvmName("qttdrhnyepsysghf")
    public suspend fun service(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.service = mapped
    }

    /**
     * @param value The amount of time your function has to run in seconds.
     */
    @JvmName("ccsbursjthefeydi")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): FunctionArgs = FunctionArgs(
        caPort = caPort,
        codeChecksum = codeChecksum,
        customContainerConfig = customContainerConfig,
        description = description,
        environmentVariables = environmentVariables,
        filename = filename,
        handler = handler,
        initializationTimeout = initializationTimeout,
        initializer = initializer,
        instanceConcurrency = instanceConcurrency,
        instanceType = instanceType,
        layers = layers,
        memorySize = memorySize,
        name = name,
        namePrefix = namePrefix,
        ossBucket = ossBucket,
        ossKey = ossKey,
        runtime = runtime,
        service = service,
        timeout = timeout,
    )
}
