@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin

import com.pulumi.alicloud.fc.FunctionAsyncInvokeConfigArgs.builder
import com.pulumi.alicloud.fc.kotlin.inputs.FunctionAsyncInvokeConfigDestinationConfigArgs
import com.pulumi.alicloud.fc.kotlin.inputs.FunctionAsyncInvokeConfigDestinationConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Manages an asynchronous invocation configuration for a FC Function or Alias.
 *  For the detailed information, please refer to the [developer guide](https://www.alibabacloud.com/help/en/fc/developer-reference/api-fc-open-2021-04-06-putfunctionasyncinvokeconfig).
 * > **NOTE:** Available since v1.100.0.
 * ## Example Usage
 * ### Destination Configuration
 * > **NOTE** Ensure the FC Function RAM Role has necessary permissions for the destination, such as `mns:SendMessage`, `mns:PublishMessage` or `fc:InvokeFunction`, otherwise the API will return a generic error.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const default = alicloud.getAccount({});
 * const defaultGetRegions = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultInteger = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const defaultRole = new alicloud.ram.Role("default", {
 *     name: `examplerole${defaultInteger.result}`,
 *     document: `\x09{
 * \x09\x09"Statement": [
 * \x09\x09  {
 * \x09\x09\x09"Action": "sts:AssumeRole",
 * \x09\x09\x09"Effect": "Allow",
 * \x09\x09\x09"Principal": {
 * \x09\x09\x09  "Service": [
 * \x09\x09\x09\x09"fc.aliyuncs.com"
 * \x09\x09\x09  ]
 * \x09\x09\x09}
 * \x09\x09  }
 * \x09\x09],
 * \x09\x09"Version": "1"
 * \x09}
 * `,
 *     description: "this is a example",
 *     force: true,
 * });
 * const defaultPolicy = new alicloud.ram.Policy("default", {
 *     policyName: `examplepolicy${defaultInteger.result}`,
 *     policyDocument: `\x09{
 * \x09\x09"Version": "1",
 * \x09\x09"Statement": [
 * \x09\x09  {
 * \x09\x09\x09"Action": "mns:*",
 * \x09\x09\x09"Resource": "*",
 * \x09\x09\x09"Effect": "Allow"
 * \x09\x09  }
 * \x09\x09]
 * \x09  }
 * `,
 * });
 * const defaultRolePolicyAttachment = new alicloud.ram.RolePolicyAttachment("default", {
 *     roleName: defaultRole.name,
 *     policyName: defaultPolicy.name,
 *     policyType: "Custom",
 * });
 * const defaultService = new alicloud.fc.Service("default", {
 *     name: `example-value-${defaultInteger.result}`,
 *     description: "example-value",
 *     role: defaultRole.arn,
 *     internetAccess: false,
 * });
 * const defaultBucket = new alicloud.oss.Bucket("default", {bucket: `terraform-example-${defaultInteger.result}`});
 * // If you upload the function by OSS Bucket, you need to specify path can't upload by content.
 * const defaultBucketObject = new alicloud.oss.BucketObject("default", {
 *     bucket: defaultBucket.id,
 *     key: "index.py",
 *     content: `import logging
 * def handler(event, context):
 * logger = logging.getLogger()
 * logger.info('hello world')
 * return 'hello world'`,
 * });
 * const defaultFunction = new alicloud.fc.Function("default", {
 *     service: defaultService.name,
 *     name: `terraform-example-${defaultInteger.result}`,
 *     description: "example",
 *     ossBucket: defaultBucket.id,
 *     ossKey: defaultBucketObject.key,
 *     memorySize: 512,
 *     runtime: "python3.10",
 *     handler: "hello.handler",
 * });
 * const defaultQueue = new alicloud.mns.Queue("default", {name: `terraform-example-${defaultInteger.result}`});
 * const defaultTopic = new alicloud.mns.Topic("default", {name: `terraform-example-${defaultInteger.result}`});
 * const defaultFunctionAsyncInvokeConfig = new alicloud.fc.FunctionAsyncInvokeConfig("default", {
 *     serviceName: defaultService.name,
 *     functionName: defaultFunction.name,
 *     destinationConfig: {
 *         onFailure: {
 *             destination: pulumi.all([defaultGetRegions, _default, defaultQueue&#46;name])&#46;apply(([defaultGetRegions, _default, name]) => `acs:mns:${defaultGetRegions&#46;regions?&#46;[0]?.id}:${_default.id}:/queues/${name}/messages`),
 *         },
 *         onSuccess: {
 *             destination: pulumi.all([defaultGetRegions, _default, defaultTopic&#46;name])&#46;apply(([defaultGetRegions, _default, name]) => `acs:mns:${defaultGetRegions&#46;regions?&#46;[0]?.id}:${_default.id}:/topics/${name}/messages`),
 *         },
 *     },
 *     maximumEventAgeInSeconds: 60,
 *     maximumRetryAttempts: 0,
 *     statefulInvocation: true,
 *     qualifier: "LATEST",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = alicloud.get_account()
 * default_get_regions = alicloud.get_regions(current=True)
 * default_integer = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * default_role = alicloud.ram.Role("default",
 *     name=f"examplerole{default_integer['result']}",
 *     document="""\x09{
 * \x09\x09"Statement": [
 * \x09\x09  {
 * \x09\x09\x09"Action": "sts:AssumeRole",
 * \x09\x09\x09"Effect": "Allow",
 * \x09\x09\x09"Principal": {
 * \x09\x09\x09  "Service": [
 * \x09\x09\x09\x09"fc.aliyuncs.com"
 * \x09\x09\x09  ]
 * \x09\x09\x09}
 * \x09\x09  }
 * \x09\x09],
 * \x09\x09"Version": "1"
 * \x09}
 * """,
 *     description="this is a example",
 *     force=True)
 * default_policy = alicloud.ram.Policy("default",
 *     policy_name=f"examplepolicy{default_integer['result']}",
 *     policy_document="""\x09{
 * \x09\x09"Version": "1",
 * \x09\x09"Statement": [
 * \x09\x09  {
 * \x09\x09\x09"Action": "mns:*",
 * \x09\x09\x09"Resource": "*",
 * \x09\x09\x09"Effect": "Allow"
 * \x09\x09  }
 * \x09\x09]
 * \x09  }
 * """)
 * default_role_policy_attachment = alicloud.ram.RolePolicyAttachment("default",
 *     role_name=default_role.name,
 *     policy_name=default_policy.name,
 *     policy_type="Custom")
 * default_service = alicloud.fc.Service("default",
 *     name=f"example-value-{default_integer['result']}",
 *     description="example-value",
 *     role=default_role.arn,
 *     internet_access=False)
 * default_bucket = alicloud.oss.Bucket("default", bucket=f"terraform-example-{default_integer['result']}")
 * # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
 * default_bucket_object = alicloud.oss.BucketObject("default",
 *     bucket=default_bucket.id,
 *     key="index.py",
 *     content="""import logging
 * def handler(event, context):
 * logger = logging.getLogger()
 * logger.info('hello world')
 * return 'hello world'""")
 * default_function = alicloud.fc.Function("default",
 *     service=default_service.name,
 *     name=f"terraform-example-{default_integer['result']}",
 *     description="example",
 *     oss_bucket=default_bucket.id,
 *     oss_key=default_bucket_object.key,
 *     memory_size=512,
 *     runtime="python3.10",
 *     handler="hello.handler")
 * default_queue = alicloud.mns.Queue("default", name=f"terraform-example-{default_integer['result']}")
 * default_topic = alicloud.mns.Topic("default", name=f"terraform-example-{default_integer['result']}")
 * default_function_async_invoke_config = alicloud.fc.FunctionAsyncInvokeConfig("default",
 *     service_name=default_service.name,
 *     function_name=default_function.name,
 *     destination_config={
 *         "on_failure": {
 *             "destination": default_queue.name.apply(lambda name: f"acs:mns:{default_get_regions.regions[0].id}:{default.id}:/queues/{name}/messages"),
 *         },
 *         "on_success": {
 *             "destination": default_topic.name.apply(lambda name: f"acs:mns:{default_get_regions.regions[0].id}:{default.id}:/topics/{name}/messages"),
 *         },
 *     },
 *     maximum_event_age_in_seconds=60,
 *     maximum_retry_attempts=0,
 *     stateful_invocation=True,
 *     qualifier="LATEST")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetAccount.Invoke();
 *     var defaultGetRegions = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var defaultRole = new AliCloud.Ram.Role("default", new()
 *     {
 *         Name = $"examplerole{defaultInteger.Result}",
 *         Document = @"	{
 * 		""Statement"": [
 * 		  {
 * 			""Action"": ""sts:AssumeRole"",
 * 			""Effect"": ""Allow"",
 * 			""Principal"": {
 * 			  ""Service"": [
 * 				""fc.aliyuncs.com""
 * 			  ]
 * 			}
 * 		  }
 * 		],
 * 		""Version"": ""1""
 * 	}
 * ",
 *         Description = "this is a example",
 *         Force = true,
 *     });
 *     var defaultPolicy = new AliCloud.Ram.Policy("default", new()
 *     {
 *         PolicyName = $"examplepolicy{defaultInteger.Result}",
 *         PolicyDocument = @"	{
 * 		""Version"": ""1"",
 * 		""Statement"": [
 * 		  {
 * 			""Action"": ""mns:*"",
 * 			""Resource"": ""*"",
 * 			""Effect"": ""Allow""
 * 		  }
 * 		]
 * 	  }
 * ",
 *     });
 *     var defaultRolePolicyAttachment = new AliCloud.Ram.RolePolicyAttachment("default", new()
 *     {
 *         RoleName = defaultRole.Name,
 *         PolicyName = defaultPolicy.Name,
 *         PolicyType = "Custom",
 *     });
 *     var defaultService = new AliCloud.FC.Service("default", new()
 *     {
 *         Name = $"example-value-{defaultInteger.Result}",
 *         Description = "example-value",
 *         Role = defaultRole.Arn,
 *         InternetAccess = false,
 *     });
 *     var defaultBucket = new AliCloud.Oss.Bucket("default", new()
 *     {
 *         BucketName = $"terraform-example-{defaultInteger.Result}",
 *     });
 *     // If you upload the function by OSS Bucket, you need to specify path can't upload by content.
 *     var defaultBucketObject = new AliCloud.Oss.BucketObject("default", new()
 *     {
 *         Bucket = defaultBucket.Id,
 *         Key = "index.py",
 *         Content = @"import logging
 * def handler(event, context):
 * logger = logging.getLogger()
 * logger.info('hello world')
 * return 'hello world'",
 *     });
 *     var defaultFunction = new AliCloud.FC.Function("default", new()
 *     {
 *         Service = defaultService.Name,
 *         Name = $"terraform-example-{defaultInteger.Result}",
 *         Description = "example",
 *         OssBucket = defaultBucket.Id,
 *         OssKey = defaultBucketObject.Key,
 *         MemorySize = 512,
 *         Runtime = "python3.10",
 *         Handler = "hello.handler",
 *     });
 *     var defaultQueue = new AliCloud.Mns.Queue("default", new()
 *     {
 *         Name = $"terraform-example-{defaultInteger.Result}",
 *     });
 *     var defaultTopic = new AliCloud.Mns.Topic("default", new()
 *     {
 *         Name = $"terraform-example-{defaultInteger.Result}",
 *     });
 *     var defaultFunctionAsyncInvokeConfig = new AliCloud.FC.FunctionAsyncInvokeConfig("default", new()
 *     {
 *         ServiceName = defaultService.Name,
 *         FunctionName = defaultFunction.Name,
 *         DestinationConfig = new AliCloud.FC.Inputs.FunctionAsyncInvokeConfigDestinationConfigArgs
 *         {
 *             OnFailure = new AliCloud.FC.Inputs.FunctionAsyncInvokeConfigDestinationConfigOnFailureArgs
 *             {
 *                 Destination = Output.Tuple(defaultGetRegions, @default, defaultQueue.Name).Apply(values =>
 *                 {
 *                     var defaultGetRegions = values.Item1;
 *                     var @default = values.Item2;
 *                     var name = values.Item3;
 *                     return $"acs:mns:{defaultGetRegions.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)}:{@default.Apply(getAccountResult => getAccountResult.Id)}:/queues/{name}/messages";
 *                 }),
 *             },
 *             OnSuccess = new AliCloud.FC.Inputs.FunctionAsyncInvokeConfigDestinationConfigOnSuccessArgs
 *             {
 *                 Destination = Output.Tuple(defaultGetRegions, @default, defaultTopic.Name).Apply(values =>
 *                 {
 *                     var defaultGetRegions = values.Item1;
 *                     var @default = values.Item2;
 *                     var name = values.Item3;
 *                     return $"acs:mns:{defaultGetRegions.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)}:{@default.Apply(getAccountResult => getAccountResult.Id)}:/topics/{name}/messages";
 *                 }),
 *             },
 *         },
 *         MaximumEventAgeInSeconds = 60,
 *         MaximumRetryAttempts = 0,
 *         StatefulInvocation = true,
 *         Qualifier = "LATEST",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fc"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mns"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetRegions, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultRole, err := ram.NewRole(ctx, "default", &ram.RoleArgs{
 * 			Name: pulumi.Sprintf("examplerole%v", defaultInteger.Result),
 * 			Document: pulumi.String(`	{
 * 		"Statement": [
 * 		  {
 * 			"Action": "sts:AssumeRole",
 * 			"Effect": "Allow",
 * 			"Principal": {
 * 			  "Service": [
 * 				"fc.aliyuncs.com"
 * 			  ]
 * 			}
 * 		  }
 * 		],
 * 		"Version": "1"
 * 	}
 * `),
 * 			Description: pulumi.String("this is a example"),
 * 			Force:       pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultPolicy, err := ram.NewPolicy(ctx, "default", &ram.PolicyArgs{
 * 			PolicyName: pulumi.Sprintf("examplepolicy%v", defaultInteger.Result),
 * 			PolicyDocument: pulumi.String(`	{
 * 		"Version": "1",
 * 		"Statement": [
 * 		  {
 * 			"Action": "mns:*",
 * 			"Resource": "*",
 * 			"Effect": "Allow"
 * 		  }
 * 		]
 * 	  }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ram.NewRolePolicyAttachment(ctx, "default", &ram.RolePolicyAttachmentArgs{
 * 			RoleName:   defaultRole.Name,
 * 			PolicyName: defaultPolicy.Name,
 * 			PolicyType: pulumi.String("Custom"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultService, err := fc.NewService(ctx, "default", &fc.ServiceArgs{
 * 			Name:           pulumi.Sprintf("example-value-%v", defaultInteger.Result),
 * 			Description:    pulumi.String("example-value"),
 * 			Role:           defaultRole.Arn,
 * 			InternetAccess: pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBucket, err := oss.NewBucket(ctx, "default", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("terraform-example-%v", defaultInteger.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// If you upload the function by OSS Bucket, you need to specify path can't upload by content.
 * 		defaultBucketObject, err := oss.NewBucketObject(ctx, "default", &oss.BucketObjectArgs{
 * 			Bucket:  defaultBucket.ID(),
 * 			Key:     pulumi.String("index.py"),
 * 			Content: pulumi.String("import logging \ndef handler(event, context): \nlogger = logging.getLogger() \nlogger.info('hello world') \nreturn 'hello world'"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultFunction, err := fc.NewFunction(ctx, "default", &fc.FunctionArgs{
 * 			Service:     defaultService.Name,
 * 			Name:        pulumi.Sprintf("terraform-example-%v", defaultInteger.Result),
 * 			Description: pulumi.String("example"),
 * 			OssBucket:   defaultBucket.ID(),
 * 			OssKey:      defaultBucketObject.Key,
 * 			MemorySize:  pulumi.Int(512),
 * 			Runtime:     pulumi.String("python3.10"),
 * 			Handler:     pulumi.String("hello.handler"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultQueue, err := mns.NewQueue(ctx, "default", &mns.QueueArgs{
 * 			Name: pulumi.Sprintf("terraform-example-%v", defaultInteger.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultTopic, err := mns.NewTopic(ctx, "default", &mns.TopicArgs{
 * 			Name: pulumi.Sprintf("terraform-example-%v", defaultInteger.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = fc.NewFunctionAsyncInvokeConfig(ctx, "default", &fc.FunctionAsyncInvokeConfigArgs{
 * 			ServiceName:  defaultService.Name,
 * 			FunctionName: defaultFunction.Name,
 * 			DestinationConfig: &fc.FunctionAsyncInvokeConfigDestinationConfigArgs{
 * 				OnFailure: &fc.FunctionAsyncInvokeConfigDestinationConfigOnFailureArgs{
 * 					Destination: defaultQueue.Name.ApplyT(func(name string) (string, error) {
 * 						return fmt.Sprintf("acs:mns:%v:%v:/queues/%v/messages", defaultGetRegions.Regions[0].Id, _default.Id, name), nil
 * 					}).(pulumi.StringOutput),
 * 				},
 * 				OnSuccess: &fc.FunctionAsyncInvokeConfigDestinationConfigOnSuccessArgs{
 * 					Destination: defaultTopic.Name.ApplyT(func(name string) (string, error) {
 * 						return fmt.Sprintf("acs:mns:%v:%v:/topics/%v/messages", defaultGetRegions.Regions[0].Id, _default.Id, name), nil
 * 					}).(pulumi.StringOutput),
 * 				},
 * 			},
 * 			MaximumEventAgeInSeconds: pulumi.Int(60),
 * 			MaximumRetryAttempts:     pulumi.Int(0),
 * 			StatefulInvocation:       pulumi.Bool(true),
 * 			Qualifier:                pulumi.String("LATEST"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.ram.Role;
 * import com.pulumi.alicloud.ram.RoleArgs;
 * import com.pulumi.alicloud.ram.Policy;
 * import com.pulumi.alicloud.ram.PolicyArgs;
 * import com.pulumi.alicloud.ram.RolePolicyAttachment;
 * import com.pulumi.alicloud.ram.RolePolicyAttachmentArgs;
 * import com.pulumi.alicloud.fc.Service;
 * import com.pulumi.alicloud.fc.ServiceArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.oss.BucketObject;
 * import com.pulumi.alicloud.oss.BucketObjectArgs;
 * import com.pulumi.alicloud.fc.Function;
 * import com.pulumi.alicloud.fc.FunctionArgs;
 * import com.pulumi.alicloud.mns.Queue;
 * import com.pulumi.alicloud.mns.QueueArgs;
 * import com.pulumi.alicloud.mns.Topic;
 * import com.pulumi.alicloud.mns.TopicArgs;
 * import com.pulumi.alicloud.fc.FunctionAsyncInvokeConfig;
 * import com.pulumi.alicloud.fc.FunctionAsyncInvokeConfigArgs;
 * import com.pulumi.alicloud.fc.inputs.FunctionAsyncInvokeConfigDestinationConfigArgs;
 * import com.pulumi.alicloud.fc.inputs.FunctionAsyncInvokeConfigDestinationConfigOnFailureArgs;
 * import com.pulumi.alicloud.fc.inputs.FunctionAsyncInvokeConfigDestinationConfigOnSuccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = AlicloudFunctions.getAccount();
 *         final var defaultGetRegions = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var defaultRole = new Role("defaultRole", RoleArgs.builder()
 *             .name(String.format("examplerole%s", defaultInteger.result()))
 *             .document("""
 * 	{
 * 		"Statement": [
 * 		  {
 * 			"Action": "sts:AssumeRole",
 * 			"Effect": "Allow",
 * 			"Principal": {
 * 			  "Service": [
 * 				"fc.aliyuncs.com"
 * 			  ]
 * 			}
 * 		  }
 * 		],
 * 		"Version": "1"
 * 	}
 *             """)
 *             .description("this is a example")
 *             .force(true)
 *             .build());
 *         var defaultPolicy = new Policy("defaultPolicy", PolicyArgs.builder()
 *             .policyName(String.format("examplepolicy%s", defaultInteger.result()))
 *             .policyDocument("""
 * 	{
 * 		"Version": "1",
 * 		"Statement": [
 * 		  {
 * 			"Action": "mns:*",
 * 			"Resource": "*",
 * 			"Effect": "Allow"
 * 		  }
 * 		]
 * 	  }
 *             """)
 *             .build());
 *         var defaultRolePolicyAttachment = new RolePolicyAttachment("defaultRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .roleName(defaultRole.name())
 *             .policyName(defaultPolicy.name())
 *             .policyType("Custom")
 *             .build());
 *         var defaultService = new Service("defaultService", ServiceArgs.builder()
 *             .name(String.format("example-value-%s", defaultInteger.result()))
 *             .description("example-value")
 *             .role(defaultRole.arn())
 *             .internetAccess(false)
 *             .build());
 *         var defaultBucket = new Bucket("defaultBucket", BucketArgs.builder()
 *             .bucket(String.format("terraform-example-%s", defaultInteger.result()))
 *             .build());
 *         // If you upload the function by OSS Bucket, you need to specify path can't upload by content.
 *         var defaultBucketObject = new BucketObject("defaultBucketObject", BucketObjectArgs.builder()
 *             .bucket(defaultBucket.id())
 *             .key("index.py")
 *             .content("""
 * import logging
 * def handler(event, context):
 * logger = logging.getLogger()
 * logger.info('hello world')
 * return 'hello world'            """)
 *             .build());
 *         var defaultFunction = new Function("defaultFunction", FunctionArgs.builder()
 *             .service(defaultService.name())
 *             .name(String.format("terraform-example-%s", defaultInteger.result()))
 *             .description("example")
 *             .ossBucket(defaultBucket.id())
 *             .ossKey(defaultBucketObject.key())
 *             .memorySize("512")
 *             .runtime("python3.10")
 *             .handler("hello.handler")
 *             .build());
 *         var defaultQueue = new Queue("defaultQueue", QueueArgs.builder()
 *             .name(String.format("terraform-example-%s", defaultInteger.result()))
 *             .build());
 *         var defaultTopic = new Topic("defaultTopic", TopicArgs.builder()
 *             .name(String.format("terraform-example-%s", defaultInteger.result()))
 *             .build());
 *         var defaultFunctionAsyncInvokeConfig = new FunctionAsyncInvokeConfig("defaultFunctionAsyncInvokeConfig", FunctionAsyncInvokeConfigArgs.builder()
 *             .serviceName(defaultService.name())
 *             .functionName(defaultFunction.name())
 *             .destinationConfig(FunctionAsyncInvokeConfigDestinationConfigArgs.builder()
 *                 .onFailure(FunctionAsyncInvokeConfigDestinationConfigOnFailureArgs.builder()
 *                     .destination(defaultQueue.name().applyValue(name -> String.format("acs:mns:%s:%s:/queues/%s/messages", defaultGetRegions.applyValue(getRegionsResult -> getRegionsResult.regions()[0].id()),default_.id(),name)))
 *                     .build())
 *                 .onSuccess(FunctionAsyncInvokeConfigDestinationConfigOnSuccessArgs.builder()
 *                     .destination(defaultTopic.name().applyValue(name -> String.format("acs:mns:%s:%s:/topics/%s/messages", defaultGetRegions.applyValue(getRegionsResult -> getRegionsResult.regions()[0].id()),default_.id(),name)))
 *                     .build())
 *                 .build())
 *             .maximumEventAgeInSeconds(60)
 *             .maximumRetryAttempts(0)
 *             .statefulInvocation(true)
 *             .qualifier("LATEST")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       max: 99999
 *       min: 10000
 *   defaultRole:
 *     type: alicloud:ram:Role
 *     name: default
 *     properties:
 *       name: examplerole${defaultInteger.result}
 *       document: |
 *         	{
 *         		"Statement": [
 *         		  {
 *         			"Action": "sts:AssumeRole",
 *         			"Effect": "Allow",
 *         			"Principal": {
 *         			  "Service": [
 *         				"fc.aliyuncs.com"
 *         			  ]
 *         			}
 *         		  }
 *         		],
 *         		"Version": "1"
 *         	}
 *       description: this is a example
 *       force: true
 *   defaultPolicy:
 *     type: alicloud:ram:Policy
 *     name: default
 *     properties:
 *       policyName: examplepolicy${defaultInteger.result}
 *       policyDocument: |
 *         	{
 *         		"Version": "1",
 *         		"Statement": [
 *         		  {
 *         			"Action": "mns:*",
 *         			"Resource": "*",
 *         			"Effect": "Allow"
 *         		  }
 *         		]
 *         	  }
 *   defaultRolePolicyAttachment:
 *     type: alicloud:ram:RolePolicyAttachment
 *     name: default
 *     properties:
 *       roleName: ${defaultRole.name}
 *       policyName: ${defaultPolicy.name}
 *       policyType: Custom
 *   defaultService:
 *     type: alicloud:fc:Service
 *     name: default
 *     properties:
 *       name: example-value-${defaultInteger.result}
 *       description: example-value
 *       role: ${defaultRole.arn}
 *       internetAccess: false
 *   defaultBucket:
 *     type: alicloud:oss:Bucket
 *     name: default
 *     properties:
 *       bucket: terraform-example-${defaultInteger.result}
 *   # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
 *   defaultBucketObject:
 *     type: alicloud:oss:BucketObject
 *     name: default
 *     properties:
 *       bucket: ${defaultBucket.id}
 *       key: index.py
 *       content: "import logging \ndef handler(event, context): \nlogger = logging.getLogger() \nlogger.info('hello world') \nreturn 'hello world'"
 *   defaultFunction:
 *     type: alicloud:fc:Function
 *     name: default
 *     properties:
 *       service: ${defaultService.name}
 *       name: terraform-example-${defaultInteger.result}
 *       description: example
 *       ossBucket: ${defaultBucket.id}
 *       ossKey: ${defaultBucketObject.key}
 *       memorySize: '512'
 *       runtime: python3.10
 *       handler: hello.handler
 *   defaultQueue:
 *     type: alicloud:mns:Queue
 *     name: default
 *     properties:
 *       name: terraform-example-${defaultInteger.result}
 *   defaultTopic:
 *     type: alicloud:mns:Topic
 *     name: default
 *     properties:
 *       name: terraform-example-${defaultInteger.result}
 *   defaultFunctionAsyncInvokeConfig:
 *     type: alicloud:fc:FunctionAsyncInvokeConfig
 *     name: default
 *     properties:
 *       serviceName: ${defaultService.name}
 *       functionName: ${defaultFunction.name}
 *       destinationConfig:
 *         onFailure:
 *           destination: acs:mns:${defaultGetRegions.regions[0].id}:${default.id}:/queues/${defaultQueue.name}/messages
 *         onSuccess:
 *           destination: acs:mns:${defaultGetRegions.regions[0].id}:${default.id}:/topics/${defaultTopic.name}/messages
 *       maximumEventAgeInSeconds: 60
 *       maximumRetryAttempts: 0 # Async Job Configuration
 *       statefulInvocation: true # Configuration for Function Latest Unpublished Version
 *       qualifier: LATEST
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 *   defaultGetRegions:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Function Compute Function Async Invoke Configs can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:fc/functionAsyncInvokeConfig:FunctionAsyncInvokeConfig example my_function
 * ```
 * @property destinationConfig Configuration block with destination configuration. See `destination_config` below.
 * @property functionName Name of the Function Compute Function.
 * @property maximumEventAgeInSeconds Maximum age of a request that Function Compute sends to a function for processing in seconds. Valid values between 1 and 2592000 (between 60 and 21600 before v1.167.0).
 * @property maximumRetryAttempts Maximum number of times to retry when the function returns an error. Valid values between 0 and 8 (between 0 and 2 before v1.167.0). Defaults to 2.
 * @property qualifier Function Compute Function published version, `LATEST`, or Function Compute Alias name. The default value is `LATEST`.
 * @property serviceName Name of the Function Compute Function, omitting any version or alias qualifier.
 * @property statefulInvocation Function Compute async job configuration(also known as Task Mode). valid values true or false, default `false`
 */
public data class FunctionAsyncInvokeConfigArgs(
    public val destinationConfig: Output<FunctionAsyncInvokeConfigDestinationConfigArgs>? = null,
    public val functionName: Output<String>? = null,
    public val maximumEventAgeInSeconds: Output<Int>? = null,
    public val maximumRetryAttempts: Output<Int>? = null,
    public val qualifier: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val statefulInvocation: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.FunctionAsyncInvokeConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.FunctionAsyncInvokeConfigArgs =
        com.pulumi.alicloud.fc.FunctionAsyncInvokeConfigArgs.builder()
            .destinationConfig(destinationConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .functionName(functionName?.applyValue({ args0 -> args0 }))
            .maximumEventAgeInSeconds(maximumEventAgeInSeconds?.applyValue({ args0 -> args0 }))
            .maximumRetryAttempts(maximumRetryAttempts?.applyValue({ args0 -> args0 }))
            .qualifier(qualifier?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .statefulInvocation(statefulInvocation?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionAsyncInvokeConfigArgs].
 */
@PulumiTagMarker
public class FunctionAsyncInvokeConfigArgsBuilder internal constructor() {
    private var destinationConfig: Output<FunctionAsyncInvokeConfigDestinationConfigArgs>? = null

    private var functionName: Output<String>? = null

    private var maximumEventAgeInSeconds: Output<Int>? = null

    private var maximumRetryAttempts: Output<Int>? = null

    private var qualifier: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var statefulInvocation: Output<Boolean>? = null

    /**
     * @param value Configuration block with destination configuration. See `destination_config` below.
     */
    @JvmName("oveafchwgolpcjen")
    public suspend fun destinationConfig(`value`: Output<FunctionAsyncInvokeConfigDestinationConfigArgs>) {
        this.destinationConfig = value
    }

    /**
     * @param value Name of the Function Compute Function.
     */
    @JvmName("mcmxubmhkvtnktxp")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value Maximum age of a request that Function Compute sends to a function for processing in seconds. Valid values between 1 and 2592000 (between 60 and 21600 before v1.167.0).
     */
    @JvmName("grfhkblwskbuwhmw")
    public suspend fun maximumEventAgeInSeconds(`value`: Output<Int>) {
        this.maximumEventAgeInSeconds = value
    }

    /**
     * @param value Maximum number of times to retry when the function returns an error. Valid values between 0 and 8 (between 0 and 2 before v1.167.0). Defaults to 2.
     */
    @JvmName("efnyaentkaabugle")
    public suspend fun maximumRetryAttempts(`value`: Output<Int>) {
        this.maximumRetryAttempts = value
    }

    /**
     * @param value Function Compute Function published version, `LATEST`, or Function Compute Alias name. The default value is `LATEST`.
     */
    @JvmName("fququswylklubrtw")
    public suspend fun qualifier(`value`: Output<String>) {
        this.qualifier = value
    }

    /**
     * @param value Name of the Function Compute Function, omitting any version or alias qualifier.
     */
    @JvmName("xyvqivjidykcwerm")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Function Compute async job configuration(also known as Task Mode). valid values true or false, default `false`
     */
    @JvmName("hhoblqhcqatmysss")
    public suspend fun statefulInvocation(`value`: Output<Boolean>) {
        this.statefulInvocation = value
    }

    /**
     * @param value Configuration block with destination configuration. See `destination_config` below.
     */
    @JvmName("yduehixaqdihncax")
    public suspend fun destinationConfig(`value`: FunctionAsyncInvokeConfigDestinationConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationConfig = mapped
    }

    /**
     * @param argument Configuration block with destination configuration. See `destination_config` below.
     */
    @JvmName("abwrimmvmkjgoebx")
    public suspend fun destinationConfig(argument: suspend FunctionAsyncInvokeConfigDestinationConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FunctionAsyncInvokeConfigDestinationConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.destinationConfig = mapped
    }

    /**
     * @param value Name of the Function Compute Function.
     */
    @JvmName("dfsxrmqusnmxshjm")
    public suspend fun functionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    /**
     * @param value Maximum age of a request that Function Compute sends to a function for processing in seconds. Valid values between 1 and 2592000 (between 60 and 21600 before v1.167.0).
     */
    @JvmName("qrmexeyijxltktgk")
    public suspend fun maximumEventAgeInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumEventAgeInSeconds = mapped
    }

    /**
     * @param value Maximum number of times to retry when the function returns an error. Valid values between 0 and 8 (between 0 and 2 before v1.167.0). Defaults to 2.
     */
    @JvmName("hyfmvmmxhexeqpaw")
    public suspend fun maximumRetryAttempts(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumRetryAttempts = mapped
    }

    /**
     * @param value Function Compute Function published version, `LATEST`, or Function Compute Alias name. The default value is `LATEST`.
     */
    @JvmName("xsopllfklbnpksfp")
    public suspend fun qualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qualifier = mapped
    }

    /**
     * @param value Name of the Function Compute Function, omitting any version or alias qualifier.
     */
    @JvmName("onvyxaircrbcmicb")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Function Compute async job configuration(also known as Task Mode). valid values true or false, default `false`
     */
    @JvmName("rfwsyxcoabspeeyh")
    public suspend fun statefulInvocation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statefulInvocation = mapped
    }

    internal fun build(): FunctionAsyncInvokeConfigArgs = FunctionAsyncInvokeConfigArgs(
        destinationConfig = destinationConfig,
        functionName = functionName,
        maximumEventAgeInSeconds = maximumEventAgeInSeconds,
        maximumRetryAttempts = maximumRetryAttempts,
        qualifier = qualifier,
        serviceName = serviceName,
        statefulInvocation = statefulInvocation,
    )
}
