@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin

import com.pulumi.alicloud.fc.LayerVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const defaultBucket = new alicloud.oss.Bucket("default", {bucket: `terraform-example-${_default.result}`});
 * // If you upload the function by OSS Bucket, you need to specify path can't upload by content.
 * const defaultBucketObject = new alicloud.oss.BucketObject("default", {
 *     bucket: defaultBucket.id,
 *     key: "index.py",
 *     content: `import logging
 * def handler(event, context):
 * logger = logging.getLogger()
 * logger.info('hello world')
 * return 'hello world'`,
 * });
 * const example = new alicloud.fc.LayerVersion("example", {
 *     layerName: `terraform-example-${_default.result}`,
 *     compatibleRuntimes: ["python2&#46;7"],
 *     ossBucketName: defaultBucket.bucket,
 *     ossObjectName: defaultBucketObject.key,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * default_bucket = alicloud.oss.Bucket("default", bucket=f"terraform-example-{default['result']}")
 * # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
 * default_bucket_object = alicloud.oss.BucketObject("default",
 *     bucket=default_bucket.id,
 *     key="index.py",
 *     content="""import logging
 * def handler(event, context):
 * logger = logging.getLogger()
 * logger.info('hello world')
 * return 'hello world'""")
 * example = alicloud.fc.LayerVersion("example",
 *     layer_name=f"terraform-example-{default['result']}",
 *     compatible_runtimes=["python2&#46;7"],
 *     oss_bucket_name=default_bucket.bucket,
 *     oss_object_name=default_bucket_object.key)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var defaultBucket = new AliCloud.Oss.Bucket("default", new()
 *     {
 *         BucketName = $"terraform-example-{@default.Result}",
 *     });
 *     // If you upload the function by OSS Bucket, you need to specify path can't upload by content.
 *     var defaultBucketObject = new AliCloud.Oss.BucketObject("default", new()
 *     {
 *         Bucket = defaultBucket.Id,
 *         Key = "index.py",
 *         Content = @"import logging
 * def handler(event, context):
 * logger = logging.getLogger()
 * logger.info('hello world')
 * return 'hello world'",
 *     });
 *     var example = new AliCloud.FC.LayerVersion("example", new()
 *     {
 *         LayerName = $"terraform-example-{@default.Result}",
 *         CompatibleRuntimes = new[]
 *         {
 *             "python2.7",
 *         },
 *         OssBucketName = defaultBucket.BucketName,
 *         OssObjectName = defaultBucketObject.Key,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fc"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBucket, err := oss.NewBucket(ctx, "default", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// If you upload the function by OSS Bucket, you need to specify path can't upload by content.
 * 		defaultBucketObject, err := oss.NewBucketObject(ctx, "default", &oss.BucketObjectArgs{
 * 			Bucket:  defaultBucket.ID(),
 * 			Key:     pulumi.String("index.py"),
 * 			Content: pulumi.String("import logging \ndef handler(event, context): \nlogger = logging.getLogger() \nlogger.info('hello world') \nreturn 'hello world'"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = fc.NewLayerVersion(ctx, "example", &fc.LayerVersionArgs{
 * 			LayerName: pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			CompatibleRuntimes: pulumi.StringArray{
 * 				pulumi.String("python2.7"),
 * 			},
 * 			OssBucketName: defaultBucket.Bucket,
 * 			OssObjectName: defaultBucketObject.Key,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.oss.BucketObject;
 * import com.pulumi.alicloud.oss.BucketObjectArgs;
 * import com.pulumi.alicloud.fc.LayerVersion;
 * import com.pulumi.alicloud.fc.LayerVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var defaultBucket = new Bucket("defaultBucket", BucketArgs.builder()
 *             .bucket(String.format("terraform-example-%s", default_.result()))
 *             .build());
 *         // If you upload the function by OSS Bucket, you need to specify path can't upload by content.
 *         var defaultBucketObject = new BucketObject("defaultBucketObject", BucketObjectArgs.builder()
 *             .bucket(defaultBucket.id())
 *             .key("index.py")
 *             .content("""
 * import logging
 * def handler(event, context):
 * logger = logging.getLogger()
 * logger.info('hello world')
 * return 'hello world'            """)
 *             .build());
 *         var example = new LayerVersion("example", LayerVersionArgs.builder()
 *             .layerName(String.format("terraform-example-%s", default_.result()))
 *             .compatibleRuntimes("python2.7")
 *             .ossBucketName(defaultBucket.bucket())
 *             .ossObjectName(defaultBucketObject.key())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   defaultBucket:
 *     type: alicloud:oss:Bucket
 *     name: default
 *     properties:
 *       bucket: terraform-example-${default.result}
 *   # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
 *   defaultBucketObject:
 *     type: alicloud:oss:BucketObject
 *     name: default
 *     properties:
 *       bucket: ${defaultBucket.id}
 *       key: index.py
 *       content: "import logging \ndef handler(event, context): \nlogger = logging.getLogger() \nlogger.info('hello world') \nreturn 'hello world'"
 *   example:
 *     type: alicloud:fc:LayerVersion
 *     properties:
 *       layerName: terraform-example-${default.result}
 *       compatibleRuntimes:
 *         - python2.7
 *       ossBucketName: ${defaultBucket.bucket}
 *       ossObjectName: ${defaultBucketObject.key}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Function Compute Layer Version can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:fc/layerVersion:LayerVersion example my_function
 * ```
 * @property compatibleRuntimes The list of runtime environments that are supported by the layer. Valid values: `nodejs14`, `nodejs12`, `nodejs10`, `nodejs8`, `nodejs6`, `python3.9`, `python3`, `python2.7`, `java11`, `java8`, `php7.2`, `go1`,`dotnetcore2.1`, `custom`.
 * @property description The description of the layer version.
 * @property layerName The name of the layer.
 * @property ossBucketName The name of the OSS bucket that stores the ZIP package of the function code.
 * @property ossObjectName The name of the OSS object (ZIP package) that contains the function code.
 * @property skipDestroy Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`. When this is not set to `true`, changing any of `compatible_runtimes`, `description`, `layer_name`, `oss_bucket_name`,  `oss_object_name`, or `zip_file` forces deletion of the existing layer version and creation of a new layer version.
 * @property zipFile The ZIP package of the function code that is encoded in the Base64 format.
 * > **NOTE:** `zip_file` and `oss_bucket_name`, `oss_object_name` cannot be used together.
 */
public data class LayerVersionArgs(
    public val compatibleRuntimes: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val layerName: Output<String>? = null,
    public val ossBucketName: Output<String>? = null,
    public val ossObjectName: Output<String>? = null,
    public val skipDestroy: Output<Boolean>? = null,
    public val zipFile: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.LayerVersionArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.LayerVersionArgs =
        com.pulumi.alicloud.fc.LayerVersionArgs.builder()
            .compatibleRuntimes(compatibleRuntimes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .layerName(layerName?.applyValue({ args0 -> args0 }))
            .ossBucketName(ossBucketName?.applyValue({ args0 -> args0 }))
            .ossObjectName(ossObjectName?.applyValue({ args0 -> args0 }))
            .skipDestroy(skipDestroy?.applyValue({ args0 -> args0 }))
            .zipFile(zipFile?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LayerVersionArgs].
 */
@PulumiTagMarker
public class LayerVersionArgsBuilder internal constructor() {
    private var compatibleRuntimes: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var layerName: Output<String>? = null

    private var ossBucketName: Output<String>? = null

    private var ossObjectName: Output<String>? = null

    private var skipDestroy: Output<Boolean>? = null

    private var zipFile: Output<String>? = null

    /**
     * @param value The list of runtime environments that are supported by the layer. Valid values: `nodejs14`, `nodejs12`, `nodejs10`, `nodejs8`, `nodejs6`, `python3.9`, `python3`, `python2.7`, `java11`, `java8`, `php7.2`, `go1`,`dotnetcore2.1`, `custom`.
     */
    @JvmName("kbnokonqyjkftyka")
    public suspend fun compatibleRuntimes(`value`: Output<List<String>>) {
        this.compatibleRuntimes = value
    }

    @JvmName("vbvauybkslwjlfgy")
    public suspend fun compatibleRuntimes(vararg values: Output<String>) {
        this.compatibleRuntimes = Output.all(values.asList())
    }

    /**
     * @param values The list of runtime environments that are supported by the layer. Valid values: `nodejs14`, `nodejs12`, `nodejs10`, `nodejs8`, `nodejs6`, `python3.9`, `python3`, `python2.7`, `java11`, `java8`, `php7.2`, `go1`,`dotnetcore2.1`, `custom`.
     */
    @JvmName("bvygptabqkjmakre")
    public suspend fun compatibleRuntimes(values: List<Output<String>>) {
        this.compatibleRuntimes = Output.all(values)
    }

    /**
     * @param value The description of the layer version.
     */
    @JvmName("darutiqqpdvkyndo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the layer.
     */
    @JvmName("mytpdtnnebnqpbvg")
    public suspend fun layerName(`value`: Output<String>) {
        this.layerName = value
    }

    /**
     * @param value The name of the OSS bucket that stores the ZIP package of the function code.
     */
    @JvmName("baiccimkuqyegtws")
    public suspend fun ossBucketName(`value`: Output<String>) {
        this.ossBucketName = value
    }

    /**
     * @param value The name of the OSS object (ZIP package) that contains the function code.
     */
    @JvmName("kwnwvjcewtrjwbag")
    public suspend fun ossObjectName(`value`: Output<String>) {
        this.ossObjectName = value
    }

    /**
     * @param value Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`. When this is not set to `true`, changing any of `compatible_runtimes`, `description`, `layer_name`, `oss_bucket_name`,  `oss_object_name`, or `zip_file` forces deletion of the existing layer version and creation of a new layer version.
     */
    @JvmName("ehbgkrgyuuuotmdv")
    public suspend fun skipDestroy(`value`: Output<Boolean>) {
        this.skipDestroy = value
    }

    /**
     * @param value The ZIP package of the function code that is encoded in the Base64 format.
     * > **NOTE:** `zip_file` and `oss_bucket_name`, `oss_object_name` cannot be used together.
     */
    @JvmName("krihaqvqiygujvem")
    public suspend fun zipFile(`value`: Output<String>) {
        this.zipFile = value
    }

    /**
     * @param value The list of runtime environments that are supported by the layer. Valid values: `nodejs14`, `nodejs12`, `nodejs10`, `nodejs8`, `nodejs6`, `python3.9`, `python3`, `python2.7`, `java11`, `java8`, `php7.2`, `go1`,`dotnetcore2.1`, `custom`.
     */
    @JvmName("ojeimgiwfempygrq")
    public suspend fun compatibleRuntimes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compatibleRuntimes = mapped
    }

    /**
     * @param values The list of runtime environments that are supported by the layer. Valid values: `nodejs14`, `nodejs12`, `nodejs10`, `nodejs8`, `nodejs6`, `python3.9`, `python3`, `python2.7`, `java11`, `java8`, `php7.2`, `go1`,`dotnetcore2.1`, `custom`.
     */
    @JvmName("okkstsakecmhrvfg")
    public suspend fun compatibleRuntimes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.compatibleRuntimes = mapped
    }

    /**
     * @param value The description of the layer version.
     */
    @JvmName("ovqaegxkpswjxixn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the layer.
     */
    @JvmName("raruwsjyyeilhsej")
    public suspend fun layerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.layerName = mapped
    }

    /**
     * @param value The name of the OSS bucket that stores the ZIP package of the function code.
     */
    @JvmName("fdkpagwqpvjreiar")
    public suspend fun ossBucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossBucketName = mapped
    }

    /**
     * @param value The name of the OSS object (ZIP package) that contains the function code.
     */
    @JvmName("qkjlmuuljwjiknpj")
    public suspend fun ossObjectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossObjectName = mapped
    }

    /**
     * @param value Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`. When this is not set to `true`, changing any of `compatible_runtimes`, `description`, `layer_name`, `oss_bucket_name`,  `oss_object_name`, or `zip_file` forces deletion of the existing layer version and creation of a new layer version.
     */
    @JvmName("itujwwhouutowuet")
    public suspend fun skipDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipDestroy = mapped
    }

    /**
     * @param value The ZIP package of the function code that is encoded in the Base64 format.
     * > **NOTE:** `zip_file` and `oss_bucket_name`, `oss_object_name` cannot be used together.
     */
    @JvmName("kjhadbdnebcasfcp")
    public suspend fun zipFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zipFile = mapped
    }

    internal fun build(): LayerVersionArgs = LayerVersionArgs(
        compatibleRuntimes = compatibleRuntimes,
        description = description,
        layerName = layerName,
        ossBucketName = ossBucketName,
        ossObjectName = ossObjectName,
        skipDestroy = skipDestroy,
        zipFile = zipFile,
    )
}
