@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin

import com.pulumi.alicloud.fc.kotlin.outputs.ServiceLogConfig
import com.pulumi.alicloud.fc.kotlin.outputs.ServiceNasConfig
import com.pulumi.alicloud.fc.kotlin.outputs.ServiceTracingConfig
import com.pulumi.alicloud.fc.kotlin.outputs.ServiceVpcConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.alicloud.fc.kotlin.outputs.ServiceLogConfig.Companion.toKotlin as serviceLogConfigToKotlin
import com.pulumi.alicloud.fc.kotlin.outputs.ServiceNasConfig.Companion.toKotlin as serviceNasConfigToKotlin
import com.pulumi.alicloud.fc.kotlin.outputs.ServiceTracingConfig.Companion.toKotlin as serviceTracingConfigToKotlin
import com.pulumi.alicloud.fc.kotlin.outputs.ServiceVpcConfig.Companion.toKotlin as serviceVpcConfigToKotlin

/**
 * Builder for [Service].
 */
@PulumiTagMarker
public class ServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceArgs = ServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceArgsBuilder.() -> Unit) {
        val builder = ServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Service {
        val builtJavaResource = com.pulumi.alicloud.fc.Service(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Service(builtJavaResource)
    }
}

public class Service internal constructor(
    override val javaResource: com.pulumi.alicloud.fc.Service,
) : KotlinCustomResource(javaResource, ServiceMapper) {
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val internetAccess: Output<Boolean>?
        get() = javaResource.internetAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val lastModified: Output<String>
        get() = javaResource.lastModified().applyValue({ args0 -> args0 })

    public val logConfig: Output<ServiceLogConfig>?
        get() = javaResource.logConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    serviceLogConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val namePrefix: Output<String>?
        get() = javaResource.namePrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val nasConfig: Output<ServiceNasConfig>?
        get() = javaResource.nasConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    serviceNasConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    public val publish: Output<Boolean>?
        get() = javaResource.publish().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val role: Output<String>?
        get() = javaResource.role().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val serviceId: Output<String>
        get() = javaResource.serviceId().applyValue({ args0 -> args0 })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    public val tracingConfig: Output<ServiceTracingConfig>?
        get() = javaResource.tracingConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serviceTracingConfigToKotlin(args0) })
            }).orElse(null)
        })

    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })

    public val vpcConfig: Output<ServiceVpcConfig>?
        get() = javaResource.vpcConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    serviceVpcConfigToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object ServiceMapper : ResourceMapper<Service> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.fc.Service::class == javaResource::class

    override fun map(javaResource: Resource): Service = Service(
        javaResource as
            com.pulumi.alicloud.fc.Service,
    )
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Service].
 */
public suspend fun service(name: String, block: suspend ServiceResourceBuilder.() -> Unit): Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 */
public fun service(name: String): Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
