@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin

import com.pulumi.alicloud.fc.ServiceArgs.builder
import com.pulumi.alicloud.fc.kotlin.inputs.ServiceLogConfigArgs
import com.pulumi.alicloud.fc.kotlin.inputs.ServiceLogConfigArgsBuilder
import com.pulumi.alicloud.fc.kotlin.inputs.ServiceNasConfigArgs
import com.pulumi.alicloud.fc.kotlin.inputs.ServiceNasConfigArgsBuilder
import com.pulumi.alicloud.fc.kotlin.inputs.ServiceTracingConfigArgs
import com.pulumi.alicloud.fc.kotlin.inputs.ServiceTracingConfigArgsBuilder
import com.pulumi.alicloud.fc.kotlin.inputs.ServiceVpcConfigArgs
import com.pulumi.alicloud.fc.kotlin.inputs.ServiceVpcConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property description
 * @property internetAccess
 * @property logConfig
 * @property name
 * @property namePrefix
 * @property nasConfig
 * @property publish
 * @property role
 * @property tags
 * @property tracingConfig
 * @property vpcConfig
 */
public data class ServiceArgs(
    public val description: Output<String>? = null,
    public val internetAccess: Output<Boolean>? = null,
    public val logConfig: Output<ServiceLogConfigArgs>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val nasConfig: Output<ServiceNasConfigArgs>? = null,
    public val publish: Output<Boolean>? = null,
    public val role: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tracingConfig: Output<ServiceTracingConfigArgs>? = null,
    public val vpcConfig: Output<ServiceVpcConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.ServiceArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.ServiceArgs =
        com.pulumi.alicloud.fc.ServiceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .internetAccess(internetAccess?.applyValue({ args0 -> args0 }))
            .logConfig(logConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .nasConfig(nasConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publish(publish?.applyValue({ args0 -> args0 }))
            .role(role?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tracingConfig(tracingConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vpcConfig(vpcConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ServiceArgs].
 */
@PulumiTagMarker
public class ServiceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var internetAccess: Output<Boolean>? = null

    private var logConfig: Output<ServiceLogConfigArgs>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var nasConfig: Output<ServiceNasConfigArgs>? = null

    private var publish: Output<Boolean>? = null

    private var role: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tracingConfig: Output<ServiceTracingConfigArgs>? = null

    private var vpcConfig: Output<ServiceVpcConfigArgs>? = null

    /**
     * @param value
     */
    @JvmName("beswvukibntcumee")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("avmpojtbwhcwdywb")
    public suspend fun internetAccess(`value`: Output<Boolean>) {
        this.internetAccess = value
    }

    /**
     * @param value
     */
    @JvmName("enkvgdnlcjnjlqxy")
    public suspend fun logConfig(`value`: Output<ServiceLogConfigArgs>) {
        this.logConfig = value
    }

    /**
     * @param value
     */
    @JvmName("xvntnyinbtersdlg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("egxdmnerkgwawmrx")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value
     */
    @JvmName("icyjtxvokfhmjyuh")
    public suspend fun nasConfig(`value`: Output<ServiceNasConfigArgs>) {
        this.nasConfig = value
    }

    /**
     * @param value
     */
    @JvmName("sdnpvdvpiwvexwsn")
    public suspend fun publish(`value`: Output<Boolean>) {
        this.publish = value
    }

    /**
     * @param value
     */
    @JvmName("lkmnrlcscyreuqhf")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value
     */
    @JvmName("fesritoqykoasepa")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("epwqvxoocugicauf")
    public suspend fun tracingConfig(`value`: Output<ServiceTracingConfigArgs>) {
        this.tracingConfig = value
    }

    /**
     * @param value
     */
    @JvmName("suhxtakxvgggcgbs")
    public suspend fun vpcConfig(`value`: Output<ServiceVpcConfigArgs>) {
        this.vpcConfig = value
    }

    /**
     * @param value
     */
    @JvmName("xellhlajiilpmbnx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("sgmhfatwaujneyjg")
    public suspend fun internetAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetAccess = mapped
    }

    /**
     * @param value
     */
    @JvmName("jjeleecreexwoktw")
    public suspend fun logConfig(`value`: ServiceLogConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logConfig = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rghgajaknfvbloub")
    public suspend fun logConfig(argument: suspend ServiceLogConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceLogConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logConfig = mapped
    }

    /**
     * @param value
     */
    @JvmName("rbdiafcokuocmgwx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("btburabxjndnfrjj")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value
     */
    @JvmName("pkljyghnaeibpueq")
    public suspend fun nasConfig(`value`: ServiceNasConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nasConfig = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jtsgvuexlqrqxjkf")
    public suspend fun nasConfig(argument: suspend ServiceNasConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceNasConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.nasConfig = mapped
    }

    /**
     * @param value
     */
    @JvmName("ypmbqrfeoxvjkpea")
    public suspend fun publish(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publish = mapped
    }

    /**
     * @param value
     */
    @JvmName("tjndbeefvmcgcviu")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value
     */
    @JvmName("wjuhaeubxulfxrid")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("edhurnuivnyixcdq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("wmeusacsecoeyusy")
    public suspend fun tracingConfig(`value`: ServiceTracingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tracingConfig = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yignymqxevebuyxr")
    public suspend fun tracingConfig(argument: suspend ServiceTracingConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceTracingConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tracingConfig = mapped
    }

    /**
     * @param value
     */
    @JvmName("igrbccylbfifmntl")
    public suspend fun vpcConfig(`value`: ServiceVpcConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfig = mapped
    }

    /**
     * @param argument
     */
    @JvmName("duyskxwwxrsiwqjm")
    public suspend fun vpcConfig(argument: suspend ServiceVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceVpcConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcConfig = mapped
    }

    internal fun build(): ServiceArgs = ServiceArgs(
        description = description,
        internetAccess = internetAccess,
        logConfig = logConfig,
        name = name,
        namePrefix = namePrefix,
        nasConfig = nasConfig,
        publish = publish,
        role = role,
        tags = tags,
        tracingConfig = tracingConfig,
        vpcConfig = vpcConfig,
    )
}
