@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin

import com.pulumi.alicloud.fc.kotlin.outputs.V2FunctionCode
import com.pulumi.alicloud.fc.kotlin.outputs.V2FunctionCustomContainerConfig
import com.pulumi.alicloud.fc.kotlin.outputs.V2FunctionCustomDns
import com.pulumi.alicloud.fc.kotlin.outputs.V2FunctionCustomHealthCheckConfig
import com.pulumi.alicloud.fc.kotlin.outputs.V2FunctionCustomRuntimeConfig
import com.pulumi.alicloud.fc.kotlin.outputs.V2FunctionInstanceLifecycleConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.fc.kotlin.outputs.V2FunctionCode.Companion.toKotlin as v2FunctionCodeToKotlin
import com.pulumi.alicloud.fc.kotlin.outputs.V2FunctionCustomContainerConfig.Companion.toKotlin as v2FunctionCustomContainerConfigToKotlin
import com.pulumi.alicloud.fc.kotlin.outputs.V2FunctionCustomDns.Companion.toKotlin as v2FunctionCustomDnsToKotlin
import com.pulumi.alicloud.fc.kotlin.outputs.V2FunctionCustomHealthCheckConfig.Companion.toKotlin as v2FunctionCustomHealthCheckConfigToKotlin
import com.pulumi.alicloud.fc.kotlin.outputs.V2FunctionCustomRuntimeConfig.Companion.toKotlin as v2FunctionCustomRuntimeConfigToKotlin
import com.pulumi.alicloud.fc.kotlin.outputs.V2FunctionInstanceLifecycleConfig.Companion.toKotlin as v2FunctionInstanceLifecycleConfigToKotlin

/**
 * Builder for [V2Function].
 */
@PulumiTagMarker
public class V2FunctionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: V2FunctionArgs = V2FunctionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend V2FunctionArgsBuilder.() -> Unit) {
        val builder = V2FunctionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): V2Function {
        val builtJavaResource = com.pulumi.alicloud.fc.V2Function(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return V2Function(builtJavaResource)
    }
}

public class V2Function internal constructor(
    override val javaResource: com.pulumi.alicloud.fc.V2Function,
) : KotlinCustomResource(javaResource, V2FunctionMapper) {
    public val caPort: Output<Int>
        get() = javaResource.caPort().applyValue({ args0 -> args0 })

    public val code: Output<V2FunctionCode>?
        get() = javaResource.code().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    v2FunctionCodeToKotlin(args0)
                })
            }).orElse(null)
        })

    public val codeChecksum: Output<String>
        get() = javaResource.codeChecksum().applyValue({ args0 -> args0 })

    public val cpu: Output<Double>?
        get() = javaResource.cpu().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    public val customContainerConfig: Output<V2FunctionCustomContainerConfig>?
        get() = javaResource.customContainerConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> v2FunctionCustomContainerConfigToKotlin(args0) })
            }).orElse(null)
        })

    public val customDns: Output<V2FunctionCustomDns>?
        get() = javaResource.customDns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    v2FunctionCustomDnsToKotlin(args0)
                })
            }).orElse(null)
        })

    public val customHealthCheckConfig: Output<V2FunctionCustomHealthCheckConfig>?
        get() = javaResource.customHealthCheckConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> v2FunctionCustomHealthCheckConfigToKotlin(args0) })
            }).orElse(null)
        })

    public val customRuntimeConfig: Output<V2FunctionCustomRuntimeConfig>?
        get() = javaResource.customRuntimeConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> v2FunctionCustomRuntimeConfigToKotlin(args0) })
            }).orElse(null)
        })

    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val diskSize: Output<Int>?
        get() = javaResource.diskSize().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val environmentVariables: Output<Map<String, String>>?
        get() = javaResource.environmentVariables().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    public val functionName: Output<String>
        get() = javaResource.functionName().applyValue({ args0 -> args0 })

    public val gpuMemorySize: Output<Int>?
        get() = javaResource.gpuMemorySize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val handler: Output<String>
        get() = javaResource.handler().applyValue({ args0 -> args0 })

    public val initializationTimeout: Output<Int>
        get() = javaResource.initializationTimeout().applyValue({ args0 -> args0 })

    public val initializer: Output<String>?
        get() = javaResource.initializer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val instanceConcurrency: Output<Int>
        get() = javaResource.instanceConcurrency().applyValue({ args0 -> args0 })

    public val instanceLifecycleConfig: Output<V2FunctionInstanceLifecycleConfig>?
        get() = javaResource.instanceLifecycleConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> v2FunctionInstanceLifecycleConfigToKotlin(args0) })
            }).orElse(null)
        })

    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    public val layers: Output<List<String>>?
        get() = javaResource.layers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    public val memorySize: Output<Int>
        get() = javaResource.memorySize().applyValue({ args0 -> args0 })

    public val runtime: Output<String>
        get() = javaResource.runtime().applyValue({ args0 -> args0 })

    public val serviceName: Output<String>
        get() = javaResource.serviceName().applyValue({ args0 -> args0 })

    public val timeout: Output<Int>
        get() = javaResource.timeout().applyValue({ args0 -> args0 })
}

public object V2FunctionMapper : ResourceMapper<V2Function> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.fc.V2Function::class == javaResource::class

    override fun map(javaResource: Resource): V2Function = V2Function(
        javaResource as
            com.pulumi.alicloud.fc.V2Function,
    )
}

/**
 * @see [V2Function].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [V2Function].
 */
public suspend fun v2Function(name: String, block: suspend V2FunctionResourceBuilder.() -> Unit): V2Function {
    val builder = V2FunctionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [V2Function].
 * @param name The _unique_ name of the resulting resource.
 */
public fun v2Function(name: String): V2Function {
    val builder = V2FunctionResourceBuilder()
    builder.name(name)
    return builder.build()
}
