@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin

import com.pulumi.alicloud.fc.V2FunctionArgs.builder
import com.pulumi.alicloud.fc.kotlin.inputs.V2FunctionCodeArgs
import com.pulumi.alicloud.fc.kotlin.inputs.V2FunctionCodeArgsBuilder
import com.pulumi.alicloud.fc.kotlin.inputs.V2FunctionCustomContainerConfigArgs
import com.pulumi.alicloud.fc.kotlin.inputs.V2FunctionCustomContainerConfigArgsBuilder
import com.pulumi.alicloud.fc.kotlin.inputs.V2FunctionCustomDnsArgs
import com.pulumi.alicloud.fc.kotlin.inputs.V2FunctionCustomDnsArgsBuilder
import com.pulumi.alicloud.fc.kotlin.inputs.V2FunctionCustomHealthCheckConfigArgs
import com.pulumi.alicloud.fc.kotlin.inputs.V2FunctionCustomHealthCheckConfigArgsBuilder
import com.pulumi.alicloud.fc.kotlin.inputs.V2FunctionCustomRuntimeConfigArgs
import com.pulumi.alicloud.fc.kotlin.inputs.V2FunctionCustomRuntimeConfigArgsBuilder
import com.pulumi.alicloud.fc.kotlin.inputs.V2FunctionInstanceLifecycleConfigArgs
import com.pulumi.alicloud.fc.kotlin.inputs.V2FunctionInstanceLifecycleConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property caPort
 * @property code
 * @property codeChecksum
 * @property cpu
 * @property customContainerConfig
 * @property customDns
 * @property customHealthCheckConfig
 * @property customRuntimeConfig
 * @property description
 * @property diskSize
 * @property environmentVariables
 * @property functionName
 * @property gpuMemorySize
 * @property handler
 * @property initializationTimeout
 * @property initializer
 * @property instanceConcurrency
 * @property instanceLifecycleConfig
 * @property instanceType
 * @property layers
 * @property memorySize
 * @property runtime
 * @property serviceName
 * @property timeout
 */
public data class V2FunctionArgs(
    public val caPort: Output<Int>? = null,
    public val code: Output<V2FunctionCodeArgs>? = null,
    public val codeChecksum: Output<String>? = null,
    public val cpu: Output<Double>? = null,
    public val customContainerConfig: Output<V2FunctionCustomContainerConfigArgs>? = null,
    public val customDns: Output<V2FunctionCustomDnsArgs>? = null,
    public val customHealthCheckConfig: Output<V2FunctionCustomHealthCheckConfigArgs>? = null,
    public val customRuntimeConfig: Output<V2FunctionCustomRuntimeConfigArgs>? = null,
    public val description: Output<String>? = null,
    public val diskSize: Output<Int>? = null,
    public val environmentVariables: Output<Map<String, String>>? = null,
    public val functionName: Output<String>? = null,
    public val gpuMemorySize: Output<Int>? = null,
    public val handler: Output<String>? = null,
    public val initializationTimeout: Output<Int>? = null,
    public val initializer: Output<String>? = null,
    public val instanceConcurrency: Output<Int>? = null,
    public val instanceLifecycleConfig: Output<V2FunctionInstanceLifecycleConfigArgs>? = null,
    public val instanceType: Output<String>? = null,
    public val layers: Output<List<String>>? = null,
    public val memorySize: Output<Int>? = null,
    public val runtime: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val timeout: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.V2FunctionArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.V2FunctionArgs =
        com.pulumi.alicloud.fc.V2FunctionArgs.builder()
            .caPort(caPort?.applyValue({ args0 -> args0 }))
            .code(code?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .codeChecksum(codeChecksum?.applyValue({ args0 -> args0 }))
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .customContainerConfig(
                customContainerConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customDns(customDns?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customHealthCheckConfig(
                customHealthCheckConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customRuntimeConfig(
                customRuntimeConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .diskSize(diskSize?.applyValue({ args0 -> args0 }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .functionName(functionName?.applyValue({ args0 -> args0 }))
            .gpuMemorySize(gpuMemorySize?.applyValue({ args0 -> args0 }))
            .handler(handler?.applyValue({ args0 -> args0 }))
            .initializationTimeout(initializationTimeout?.applyValue({ args0 -> args0 }))
            .initializer(initializer?.applyValue({ args0 -> args0 }))
            .instanceConcurrency(instanceConcurrency?.applyValue({ args0 -> args0 }))
            .instanceLifecycleConfig(
                instanceLifecycleConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .layers(layers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .memorySize(memorySize?.applyValue({ args0 -> args0 }))
            .runtime(runtime?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2FunctionArgs].
 */
@PulumiTagMarker
public class V2FunctionArgsBuilder internal constructor() {
    private var caPort: Output<Int>? = null

    private var code: Output<V2FunctionCodeArgs>? = null

    private var codeChecksum: Output<String>? = null

    private var cpu: Output<Double>? = null

    private var customContainerConfig: Output<V2FunctionCustomContainerConfigArgs>? = null

    private var customDns: Output<V2FunctionCustomDnsArgs>? = null

    private var customHealthCheckConfig: Output<V2FunctionCustomHealthCheckConfigArgs>? = null

    private var customRuntimeConfig: Output<V2FunctionCustomRuntimeConfigArgs>? = null

    private var description: Output<String>? = null

    private var diskSize: Output<Int>? = null

    private var environmentVariables: Output<Map<String, String>>? = null

    private var functionName: Output<String>? = null

    private var gpuMemorySize: Output<Int>? = null

    private var handler: Output<String>? = null

    private var initializationTimeout: Output<Int>? = null

    private var initializer: Output<String>? = null

    private var instanceConcurrency: Output<Int>? = null

    private var instanceLifecycleConfig: Output<V2FunctionInstanceLifecycleConfigArgs>? = null

    private var instanceType: Output<String>? = null

    private var layers: Output<List<String>>? = null

    private var memorySize: Output<Int>? = null

    private var runtime: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var timeout: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("siswfvrjtlorjwwd")
    public suspend fun caPort(`value`: Output<Int>) {
        this.caPort = value
    }

    /**
     * @param value
     */
    @JvmName("nejlsjrxecvohgbp")
    public suspend fun code(`value`: Output<V2FunctionCodeArgs>) {
        this.code = value
    }

    /**
     * @param value
     */
    @JvmName("dwlxobpkgbdtqfsi")
    public suspend fun codeChecksum(`value`: Output<String>) {
        this.codeChecksum = value
    }

    /**
     * @param value
     */
    @JvmName("hwxfnsrqkhnrloqi")
    public suspend fun cpu(`value`: Output<Double>) {
        this.cpu = value
    }

    /**
     * @param value
     */
    @JvmName("jjpfmllrhtybdhwy")
    public suspend fun customContainerConfig(`value`: Output<V2FunctionCustomContainerConfigArgs>) {
        this.customContainerConfig = value
    }

    /**
     * @param value
     */
    @JvmName("obumpeoybsbidtgl")
    public suspend fun customDns(`value`: Output<V2FunctionCustomDnsArgs>) {
        this.customDns = value
    }

    /**
     * @param value
     */
    @JvmName("yrsxjkltripkntmq")
    public suspend fun customHealthCheckConfig(`value`: Output<V2FunctionCustomHealthCheckConfigArgs>) {
        this.customHealthCheckConfig = value
    }

    /**
     * @param value
     */
    @JvmName("ihoovkljetikdndu")
    public suspend fun customRuntimeConfig(`value`: Output<V2FunctionCustomRuntimeConfigArgs>) {
        this.customRuntimeConfig = value
    }

    /**
     * @param value
     */
    @JvmName("tkugsttlbbaxifyn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("ksllujkglgflllka")
    public suspend fun diskSize(`value`: Output<Int>) {
        this.diskSize = value
    }

    /**
     * @param value
     */
    @JvmName("hbxigurvfbbevdwu")
    public suspend fun environmentVariables(`value`: Output<Map<String, String>>) {
        this.environmentVariables = value
    }

    /**
     * @param value
     */
    @JvmName("dhrjkkdeppkujpml")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value
     */
    @JvmName("lsjuladejdsyfigb")
    public suspend fun gpuMemorySize(`value`: Output<Int>) {
        this.gpuMemorySize = value
    }

    /**
     * @param value
     */
    @JvmName("agcedfgynatreqqa")
    public suspend fun handler(`value`: Output<String>) {
        this.handler = value
    }

    /**
     * @param value
     */
    @JvmName("tkaomuetkibswjim")
    public suspend fun initializationTimeout(`value`: Output<Int>) {
        this.initializationTimeout = value
    }

    /**
     * @param value
     */
    @JvmName("mlgnkvjxkdotstai")
    public suspend fun initializer(`value`: Output<String>) {
        this.initializer = value
    }

    /**
     * @param value
     */
    @JvmName("rakndqodwcdwurmk")
    public suspend fun instanceConcurrency(`value`: Output<Int>) {
        this.instanceConcurrency = value
    }

    /**
     * @param value
     */
    @JvmName("slsgprlpdsvhactu")
    public suspend fun instanceLifecycleConfig(`value`: Output<V2FunctionInstanceLifecycleConfigArgs>) {
        this.instanceLifecycleConfig = value
    }

    /**
     * @param value
     */
    @JvmName("sjkmbybaaphacgsa")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value
     */
    @JvmName("fhbpthjbadmnmfwq")
    public suspend fun layers(`value`: Output<List<String>>) {
        this.layers = value
    }

    @JvmName("odaamarisxdojaqr")
    public suspend fun layers(vararg values: Output<String>) {
        this.layers = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("rhjyesldigyhodef")
    public suspend fun layers(values: List<Output<String>>) {
        this.layers = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("krqxnufmarxuncnk")
    public suspend fun memorySize(`value`: Output<Int>) {
        this.memorySize = value
    }

    /**
     * @param value
     */
    @JvmName("abvenfactpwsqxwk")
    public suspend fun runtime(`value`: Output<String>) {
        this.runtime = value
    }

    /**
     * @param value
     */
    @JvmName("ynvrgjvjuklvoefg")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value
     */
    @JvmName("frsdwuuwbkfggies")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value
     */
    @JvmName("lknjsewexijkhidg")
    public suspend fun caPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caPort = mapped
    }

    /**
     * @param value
     */
    @JvmName("gvgxnlghsemcltqx")
    public suspend fun code(`value`: V2FunctionCodeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qcvtcryunwykobis")
    public suspend fun code(argument: suspend V2FunctionCodeArgsBuilder.() -> Unit) {
        val toBeMapped = V2FunctionCodeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.code = mapped
    }

    /**
     * @param value
     */
    @JvmName("ibjwjqokqmoxajbu")
    public suspend fun codeChecksum(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeChecksum = mapped
    }

    /**
     * @param value
     */
    @JvmName("olioerlakshjrnti")
    public suspend fun cpu(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value
     */
    @JvmName("cgetvgwlfkukdgry")
    public suspend fun customContainerConfig(`value`: V2FunctionCustomContainerConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customContainerConfig = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bobytgotjmwbalhn")
    public suspend fun customContainerConfig(argument: suspend V2FunctionCustomContainerConfigArgsBuilder.() -> Unit) {
        val toBeMapped = V2FunctionCustomContainerConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customContainerConfig = mapped
    }

    /**
     * @param value
     */
    @JvmName("shqjhxvyjoefjkwm")
    public suspend fun customDns(`value`: V2FunctionCustomDnsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDns = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bugyecwhqvynxjsd")
    public suspend fun customDns(argument: suspend V2FunctionCustomDnsArgsBuilder.() -> Unit) {
        val toBeMapped = V2FunctionCustomDnsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customDns = mapped
    }

    /**
     * @param value
     */
    @JvmName("adlyfyjvnjygrsbo")
    public suspend fun customHealthCheckConfig(`value`: V2FunctionCustomHealthCheckConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customHealthCheckConfig = mapped
    }

    /**
     * @param argument
     */
    @JvmName("culjmkuphrapoucg")
    public suspend fun customHealthCheckConfig(argument: suspend V2FunctionCustomHealthCheckConfigArgsBuilder.() -> Unit) {
        val toBeMapped = V2FunctionCustomHealthCheckConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customHealthCheckConfig = mapped
    }

    /**
     * @param value
     */
    @JvmName("cqievfamykqpfeot")
    public suspend fun customRuntimeConfig(`value`: V2FunctionCustomRuntimeConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRuntimeConfig = mapped
    }

    /**
     * @param argument
     */
    @JvmName("osqjicwjttqsqelg")
    public suspend fun customRuntimeConfig(argument: suspend V2FunctionCustomRuntimeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = V2FunctionCustomRuntimeConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customRuntimeConfig = mapped
    }

    /**
     * @param value
     */
    @JvmName("ahywqfrptspyhmht")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("goomyioodqwsuoie")
    public suspend fun diskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSize = mapped
    }

    /**
     * @param value
     */
    @JvmName("pidusiehsfxyndpa")
    public suspend fun environmentVariables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param values
     */
    @JvmName("xcvvfyivmljsqpaf")
    public fun environmentVariables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value
     */
    @JvmName("xjqnlwesugbbqkxw")
    public suspend fun functionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    /**
     * @param value
     */
    @JvmName("hghvavixapefqnlb")
    public suspend fun gpuMemorySize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gpuMemorySize = mapped
    }

    /**
     * @param value
     */
    @JvmName("irxcymfoutbhopuk")
    public suspend fun handler(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.handler = mapped
    }

    /**
     * @param value
     */
    @JvmName("pkcxnolypphjgcxf")
    public suspend fun initializationTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initializationTimeout = mapped
    }

    /**
     * @param value
     */
    @JvmName("gmignywagwikukok")
    public suspend fun initializer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initializer = mapped
    }

    /**
     * @param value
     */
    @JvmName("jjhwfcaghtrxrwux")
    public suspend fun instanceConcurrency(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceConcurrency = mapped
    }

    /**
     * @param value
     */
    @JvmName("dthdbjokjfuwgboc")
    public suspend fun instanceLifecycleConfig(`value`: V2FunctionInstanceLifecycleConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceLifecycleConfig = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dvnxamjgjqnxsnli")
    public suspend fun instanceLifecycleConfig(argument: suspend V2FunctionInstanceLifecycleConfigArgsBuilder.() -> Unit) {
        val toBeMapped = V2FunctionInstanceLifecycleConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.instanceLifecycleConfig = mapped
    }

    /**
     * @param value
     */
    @JvmName("woboubqatoowymio")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value
     */
    @JvmName("eyhogigyxhhynvpb")
    public suspend fun layers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.layers = mapped
    }

    /**
     * @param values
     */
    @JvmName("cskcqsfaksqvqrpj")
    public suspend fun layers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.layers = mapped
    }

    /**
     * @param value
     */
    @JvmName("ouppysixavaaetoy")
    public suspend fun memorySize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memorySize = mapped
    }

    /**
     * @param value
     */
    @JvmName("bjucgweddfmfwnjn")
    public suspend fun runtime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtime = mapped
    }

    /**
     * @param value
     */
    @JvmName("irqybdowiuxmxarr")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value
     */
    @JvmName("liwxacpqvhkmxidp")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): V2FunctionArgs = V2FunctionArgs(
        caPort = caPort,
        code = code,
        codeChecksum = codeChecksum,
        cpu = cpu,
        customContainerConfig = customContainerConfig,
        customDns = customDns,
        customHealthCheckConfig = customHealthCheckConfig,
        customRuntimeConfig = customRuntimeConfig,
        description = description,
        diskSize = diskSize,
        environmentVariables = environmentVariables,
        functionName = functionName,
        gpuMemorySize = gpuMemorySize,
        handler = handler,
        initializationTimeout = initializationTimeout,
        initializer = initializer,
        instanceConcurrency = instanceConcurrency,
        instanceLifecycleConfig = instanceLifecycleConfig,
        instanceType = instanceType,
        layers = layers,
        memorySize = memorySize,
        runtime = runtime,
        serviceName = serviceName,
        timeout = timeout,
    )
}
