@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [V3Alias].
 */
@PulumiTagMarker
public class V3AliasResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: V3AliasArgs = V3AliasArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend V3AliasArgsBuilder.() -> Unit) {
        val builder = V3AliasArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): V3Alias {
        val builtJavaResource = com.pulumi.alicloud.fc.V3Alias(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return V3Alias(builtJavaResource)
    }
}

/**
 * Provides a FCV3 Alias resource.
 * Alias for functions.
 * For information about FCV3 Alias and how to use it, see [What is Alias](https://www.alibabacloud.com/help/en/functioncompute/developer-reference/api-fc-2023-03-30-createalias).
 * > **NOTE:** Available since v1.228.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const functionName = config.get("functionName") || "flask-3xdg";
 * const _default = new alicloud.fc.V3Alias("default", {
 *     versionId: "1",
 *     functionName: functionName,
 *     description: "create alias",
 *     aliasName: name,
 *     additionalVersionWeight: {
 *         "2": 0.5,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * function_name = config.get("functionName")
 * if function_name is None:
 *     function_name = "flask-3xdg"
 * default = alicloud.fc.V3Alias("default",
 *     version_id="1",
 *     function_name=function_name,
 *     description="create alias",
 *     alias_name=name,
 *     additional_version_weight={
 *         "2": 0.5,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var functionName = config.Get("functionName") ?? "flask-3xdg";
 *     var @default = new AliCloud.FC.V3Alias("default", new()
 *     {
 *         VersionId = "1",
 *         FunctionName = functionName,
 *         Description = "create alias",
 *         AliasName = name,
 *         AdditionalVersionWeight =
 *         {
 *             { "2", 0.5 },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		functionName := "flask-3xdg"
 * 		if param := cfg.Get("functionName"); param != "" {
 * 			functionName = param
 * 		}
 * 		_, err := fc.NewV3Alias(ctx, "default", &fc.V3AliasArgs{
 * 			VersionId:    pulumi.String("1"),
 * 			FunctionName: pulumi.String(functionName),
 * 			Description:  pulumi.String("create alias"),
 * 			AliasName:    pulumi.String(name),
 * 			AdditionalVersionWeight: pulumi.Float64Map{
 * 				"2": pulumi.Float64(0.5),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.fc.V3Alias;
 * import com.pulumi.alicloud.fc.V3AliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var functionName = config.get("functionName").orElse("flask-3xdg");
 *         var default_ = new V3Alias("default", V3AliasArgs.builder()
 *             .versionId("1")
 *             .functionName(functionName)
 *             .description("create alias")
 *             .aliasName(name)
 *             .additionalVersionWeight(Map.of("2", "0.5"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 *   functionName:
 *     type: string
 *     default: flask-3xdg
 * resources:
 *   default:
 *     type: alicloud:fc:V3Alias
 *     properties:
 *       versionId: '1'
 *       functionName: ${functionName}
 *       description: create alias
 *       aliasName: ${name}
 *       additionalVersionWeight:
 *         '2': '0.5'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * FCV3 Alias can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:fc/v3Alias:V3Alias example <function_name>:<alias_name>
 * ```
 */
public class V3Alias internal constructor(
    override val javaResource: com.pulumi.alicloud.fc.V3Alias,
) : KotlinCustomResource(javaResource, V3AliasMapper) {
    /**
     * Grayscale version
     */
    public val additionalVersionWeight: Output<Map<String, Double>>?
        get() = javaResource.additionalVersionWeight().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Function Alias
     */
    public val aliasName: Output<String>
        get() = javaResource.aliasName().applyValue({ args0 -> args0 })

    /**
     * The creation time of the resource
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Description
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Function Name
     */
    public val functionName: Output<String>
        get() = javaResource.functionName().applyValue({ args0 -> args0 })

    /**
     * The version that the alias points
     */
    public val versionId: Output<String>?
        get() = javaResource.versionId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object V3AliasMapper : ResourceMapper<V3Alias> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.fc.V3Alias::class == javaResource::class

    override fun map(javaResource: Resource): V3Alias = V3Alias(
        javaResource as
            com.pulumi.alicloud.fc.V3Alias,
    )
}

/**
 * @see [V3Alias].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [V3Alias].
 */
public suspend fun v3Alias(name: String, block: suspend V3AliasResourceBuilder.() -> Unit): V3Alias {
    val builder = V3AliasResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [V3Alias].
 * @param name The _unique_ name of the resulting resource.
 */
public fun v3Alias(name: String): V3Alias {
    val builder = V3AliasResourceBuilder()
    builder.name(name)
    return builder.build()
}
