@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin

import com.pulumi.alicloud.fc.V3AliasArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a FCV3 Alias resource.
 * Alias for functions.
 * For information about FCV3 Alias and how to use it, see [What is Alias](https://www.alibabacloud.com/help/en/functioncompute/developer-reference/api-fc-2023-03-30-createalias).
 * > **NOTE:** Available since v1.228.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const functionName = config.get("functionName") || "flask-3xdg";
 * const _default = new alicloud.fc.V3Alias("default", {
 *     versionId: "1",
 *     functionName: functionName,
 *     description: "create alias",
 *     aliasName: name,
 *     additionalVersionWeight: {
 *         "2": 0.5,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * function_name = config.get("functionName")
 * if function_name is None:
 *     function_name = "flask-3xdg"
 * default = alicloud.fc.V3Alias("default",
 *     version_id="1",
 *     function_name=function_name,
 *     description="create alias",
 *     alias_name=name,
 *     additional_version_weight={
 *         "2": 0.5,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var functionName = config.Get("functionName") ?? "flask-3xdg";
 *     var @default = new AliCloud.FC.V3Alias("default", new()
 *     {
 *         VersionId = "1",
 *         FunctionName = functionName,
 *         Description = "create alias",
 *         AliasName = name,
 *         AdditionalVersionWeight =
 *         {
 *             { "2", 0.5 },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		functionName := "flask-3xdg"
 * 		if param := cfg.Get("functionName"); param != "" {
 * 			functionName = param
 * 		}
 * 		_, err := fc.NewV3Alias(ctx, "default", &fc.V3AliasArgs{
 * 			VersionId:    pulumi.String("1"),
 * 			FunctionName: pulumi.String(functionName),
 * 			Description:  pulumi.String("create alias"),
 * 			AliasName:    pulumi.String(name),
 * 			AdditionalVersionWeight: pulumi.Float64Map{
 * 				"2": pulumi.Float64(0.5),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.fc.V3Alias;
 * import com.pulumi.alicloud.fc.V3AliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var functionName = config.get("functionName").orElse("flask-3xdg");
 *         var default_ = new V3Alias("default", V3AliasArgs.builder()
 *             .versionId("1")
 *             .functionName(functionName)
 *             .description("create alias")
 *             .aliasName(name)
 *             .additionalVersionWeight(Map.of("2", "0.5"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 *   functionName:
 *     type: string
 *     default: flask-3xdg
 * resources:
 *   default:
 *     type: alicloud:fc:V3Alias
 *     properties:
 *       versionId: '1'
 *       functionName: ${functionName}
 *       description: create alias
 *       aliasName: ${name}
 *       additionalVersionWeight:
 *         '2': '0.5'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * FCV3 Alias can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:fc/v3Alias:V3Alias example <function_name>:<alias_name>
 * ```
 * @property additionalVersionWeight Grayscale version
 * @property aliasName Function Alias
 * @property description Description
 * @property functionName Function Name
 * @property versionId The version that the alias points
 */
public data class V3AliasArgs(
    public val additionalVersionWeight: Output<Map<String, Double>>? = null,
    public val aliasName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val functionName: Output<String>? = null,
    public val versionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.V3AliasArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.V3AliasArgs =
        com.pulumi.alicloud.fc.V3AliasArgs.builder()
            .additionalVersionWeight(
                additionalVersionWeight?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .aliasName(aliasName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .functionName(functionName?.applyValue({ args0 -> args0 }))
            .versionId(versionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V3AliasArgs].
 */
@PulumiTagMarker
public class V3AliasArgsBuilder internal constructor() {
    private var additionalVersionWeight: Output<Map<String, Double>>? = null

    private var aliasName: Output<String>? = null

    private var description: Output<String>? = null

    private var functionName: Output<String>? = null

    private var versionId: Output<String>? = null

    /**
     * @param value Grayscale version
     */
    @JvmName("teoejaapinqkfecg")
    public suspend fun additionalVersionWeight(`value`: Output<Map<String, Double>>) {
        this.additionalVersionWeight = value
    }

    /**
     * @param value Function Alias
     */
    @JvmName("hjaksnxcyhxkprln")
    public suspend fun aliasName(`value`: Output<String>) {
        this.aliasName = value
    }

    /**
     * @param value Description
     */
    @JvmName("edkypajkotpmxxfh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Function Name
     */
    @JvmName("iawdwmotmneljffb")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value The version that the alias points
     */
    @JvmName("iawjqpsixyjnfyqm")
    public suspend fun versionId(`value`: Output<String>) {
        this.versionId = value
    }

    /**
     * @param value Grayscale version
     */
    @JvmName("pslswirfggxypjpv")
    public suspend fun additionalVersionWeight(`value`: Map<String, Double>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalVersionWeight = mapped
    }

    /**
     * @param values Grayscale version
     */
    @JvmName("hwpfmolpsfcybves")
    public fun additionalVersionWeight(vararg values: Pair<String, Double>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalVersionWeight = mapped
    }

    /**
     * @param value Function Alias
     */
    @JvmName("khrqofwqyvcsknvb")
    public suspend fun aliasName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aliasName = mapped
    }

    /**
     * @param value Description
     */
    @JvmName("smcrtsvqrihinkql")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Function Name
     */
    @JvmName("umjcijdhqqovgkix")
    public suspend fun functionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    /**
     * @param value The version that the alias points
     */
    @JvmName("nmssjuooelnamrux")
    public suspend fun versionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionId = mapped
    }

    internal fun build(): V3AliasArgs = V3AliasArgs(
        additionalVersionWeight = additionalVersionWeight,
        aliasName = aliasName,
        description = description,
        functionName = functionName,
        versionId = versionId,
    )
}
