@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin

import com.pulumi.alicloud.fc.kotlin.outputs.V3AsyncInvokeConfigDestinationConfig
import com.pulumi.alicloud.fc.kotlin.outputs.V3AsyncInvokeConfigDestinationConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [V3AsyncInvokeConfig].
 */
@PulumiTagMarker
public class V3AsyncInvokeConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: V3AsyncInvokeConfigArgs = V3AsyncInvokeConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend V3AsyncInvokeConfigArgsBuilder.() -> Unit) {
        val builder = V3AsyncInvokeConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): V3AsyncInvokeConfig {
        val builtJavaResource = com.pulumi.alicloud.fc.V3AsyncInvokeConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return V3AsyncInvokeConfig(builtJavaResource)
    }
}

/**
 * Provides a FCV3 Async Invoke Config resource.
 * Function Asynchronous Configuration.
 * For information about FCV3 Async Invoke Config and how to use it, see [What is Async Invoke Config](https://www.alibabacloud.com/help/en/functioncompute/developer-reference/api-fc-2023-03-30-getasyncinvokeconfig).
 * > **NOTE:** Available since v1.228.0.
 * ## Import
 * FCV3 Async Invoke Config can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:fc/v3AsyncInvokeConfig:V3AsyncInvokeConfig example <id>
 * ```
 */
public class V3AsyncInvokeConfig internal constructor(
    override val javaResource: com.pulumi.alicloud.fc.V3AsyncInvokeConfig,
) : KotlinCustomResource(javaResource, V3AsyncInvokeConfigMapper) {
    /**
     * Whether to enable an asynchronous task
     */
    public val asyncTask: Output<Boolean>?
        get() = javaResource.asyncTask().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The creation time of the resource
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Target Configuration See `destination_config` below.
     */
    public val destinationConfig: Output<V3AsyncInvokeConfigDestinationConfig>?
        get() = javaResource.destinationConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Function Name
     */
    public val functionName: Output<String>
        get() = javaResource.functionName().applyValue({ args0 -> args0 })

    /**
     * Event maximum survival time
     */
    public val maxAsyncEventAgeInSeconds: Output<Int>?
        get() = javaResource.maxAsyncEventAgeInSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Number of Asynchronous call retries
     */
    public val maxAsyncRetryAttempts: Output<Int>?
        get() = javaResource.maxAsyncRetryAttempts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Function version or alias
     */
    public val qualifier: Output<String>?
        get() = javaResource.qualifier().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object V3AsyncInvokeConfigMapper : ResourceMapper<V3AsyncInvokeConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.fc.V3AsyncInvokeConfig::class == javaResource::class

    override fun map(javaResource: Resource): V3AsyncInvokeConfig = V3AsyncInvokeConfig(
        javaResource
            as com.pulumi.alicloud.fc.V3AsyncInvokeConfig,
    )
}

/**
 * @see [V3AsyncInvokeConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [V3AsyncInvokeConfig].
 */
public suspend fun v3AsyncInvokeConfig(
    name: String,
    block: suspend V3AsyncInvokeConfigResourceBuilder.() -> Unit,
): V3AsyncInvokeConfig {
    val builder = V3AsyncInvokeConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [V3AsyncInvokeConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun v3AsyncInvokeConfig(name: String): V3AsyncInvokeConfig {
    val builder = V3AsyncInvokeConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
