@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin

import com.pulumi.alicloud.fc.V3AsyncInvokeConfigArgs.builder
import com.pulumi.alicloud.fc.kotlin.inputs.V3AsyncInvokeConfigDestinationConfigArgs
import com.pulumi.alicloud.fc.kotlin.inputs.V3AsyncInvokeConfigDestinationConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a FCV3 Async Invoke Config resource.
 * Function Asynchronous Configuration.
 * For information about FCV3 Async Invoke Config and how to use it, see [What is Async Invoke Config](https://www.alibabacloud.com/help/en/functioncompute/developer-reference/api-fc-2023-03-30-getasyncinvokeconfig).
 * > **NOTE:** Available since v1.228.0.
 * ## Import
 * FCV3 Async Invoke Config can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:fc/v3AsyncInvokeConfig:V3AsyncInvokeConfig example <id>
 * ```
 * @property asyncTask Whether to enable an asynchronous task
 * @property destinationConfig Target Configuration See `destination_config` below.
 * @property functionName Function Name
 * @property maxAsyncEventAgeInSeconds Event maximum survival time
 * @property maxAsyncRetryAttempts Number of Asynchronous call retries
 * @property qualifier Function version or alias
 */
public data class V3AsyncInvokeConfigArgs(
    public val asyncTask: Output<Boolean>? = null,
    public val destinationConfig: Output<V3AsyncInvokeConfigDestinationConfigArgs>? = null,
    public val functionName: Output<String>? = null,
    public val maxAsyncEventAgeInSeconds: Output<Int>? = null,
    public val maxAsyncRetryAttempts: Output<Int>? = null,
    public val qualifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.V3AsyncInvokeConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.V3AsyncInvokeConfigArgs =
        com.pulumi.alicloud.fc.V3AsyncInvokeConfigArgs.builder()
            .asyncTask(asyncTask?.applyValue({ args0 -> args0 }))
            .destinationConfig(destinationConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .functionName(functionName?.applyValue({ args0 -> args0 }))
            .maxAsyncEventAgeInSeconds(maxAsyncEventAgeInSeconds?.applyValue({ args0 -> args0 }))
            .maxAsyncRetryAttempts(maxAsyncRetryAttempts?.applyValue({ args0 -> args0 }))
            .qualifier(qualifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V3AsyncInvokeConfigArgs].
 */
@PulumiTagMarker
public class V3AsyncInvokeConfigArgsBuilder internal constructor() {
    private var asyncTask: Output<Boolean>? = null

    private var destinationConfig: Output<V3AsyncInvokeConfigDestinationConfigArgs>? = null

    private var functionName: Output<String>? = null

    private var maxAsyncEventAgeInSeconds: Output<Int>? = null

    private var maxAsyncRetryAttempts: Output<Int>? = null

    private var qualifier: Output<String>? = null

    /**
     * @param value Whether to enable an asynchronous task
     */
    @JvmName("kcatsuvmjaaaqeau")
    public suspend fun asyncTask(`value`: Output<Boolean>) {
        this.asyncTask = value
    }

    /**
     * @param value Target Configuration See `destination_config` below.
     */
    @JvmName("fsgsrdwlhuiuihna")
    public suspend fun destinationConfig(`value`: Output<V3AsyncInvokeConfigDestinationConfigArgs>) {
        this.destinationConfig = value
    }

    /**
     * @param value Function Name
     */
    @JvmName("cttdywljgoyefsvc")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value Event maximum survival time
     */
    @JvmName("rrnjambhvmidebbv")
    public suspend fun maxAsyncEventAgeInSeconds(`value`: Output<Int>) {
        this.maxAsyncEventAgeInSeconds = value
    }

    /**
     * @param value Number of Asynchronous call retries
     */
    @JvmName("nmshopkkppjgpowv")
    public suspend fun maxAsyncRetryAttempts(`value`: Output<Int>) {
        this.maxAsyncRetryAttempts = value
    }

    /**
     * @param value Function version or alias
     */
    @JvmName("etndpruefwtokaca")
    public suspend fun qualifier(`value`: Output<String>) {
        this.qualifier = value
    }

    /**
     * @param value Whether to enable an asynchronous task
     */
    @JvmName("dvbwssqlluamggvn")
    public suspend fun asyncTask(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.asyncTask = mapped
    }

    /**
     * @param value Target Configuration See `destination_config` below.
     */
    @JvmName("pacatifgkcjvmgof")
    public suspend fun destinationConfig(`value`: V3AsyncInvokeConfigDestinationConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationConfig = mapped
    }

    /**
     * @param argument Target Configuration See `destination_config` below.
     */
    @JvmName("vwamyirhrsekxqnl")
    public suspend fun destinationConfig(argument: suspend V3AsyncInvokeConfigDestinationConfigArgsBuilder.() -> Unit) {
        val toBeMapped = V3AsyncInvokeConfigDestinationConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.destinationConfig = mapped
    }

    /**
     * @param value Function Name
     */
    @JvmName("fuaopdoqhixbiutm")
    public suspend fun functionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    /**
     * @param value Event maximum survival time
     */
    @JvmName("ybewmpvfubrvnyec")
    public suspend fun maxAsyncEventAgeInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxAsyncEventAgeInSeconds = mapped
    }

    /**
     * @param value Number of Asynchronous call retries
     */
    @JvmName("jhbnqbwhutgjendo")
    public suspend fun maxAsyncRetryAttempts(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxAsyncRetryAttempts = mapped
    }

    /**
     * @param value Function version or alias
     */
    @JvmName("kmmsnejduomftwxm")
    public suspend fun qualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qualifier = mapped
    }

    internal fun build(): V3AsyncInvokeConfigArgs = V3AsyncInvokeConfigArgs(
        asyncTask = asyncTask,
        destinationConfig = destinationConfig,
        functionName = functionName,
        maxAsyncEventAgeInSeconds = maxAsyncEventAgeInSeconds,
        maxAsyncRetryAttempts = maxAsyncRetryAttempts,
        qualifier = qualifier,
    )
}
