@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [V3ConcurrencyConfig].
 */
@PulumiTagMarker
public class V3ConcurrencyConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: V3ConcurrencyConfigArgs = V3ConcurrencyConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend V3ConcurrencyConfigArgsBuilder.() -> Unit) {
        val builder = V3ConcurrencyConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): V3ConcurrencyConfig {
        val builtJavaResource = com.pulumi.alicloud.fc.V3ConcurrencyConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return V3ConcurrencyConfig(builtJavaResource)
    }
}

/**
 * Provides a FCV3 Concurrency Config resource.
 * Function concurrency configuration.
 * For information about FCV3 Concurrency Config and how to use it, see [What is Concurrency Config](https://www.alibabacloud.com/help/en/functioncompute/developer-reference/api-fc-2023-03-30-putconcurrencyconfig).
 * > **NOTE:** Available since v1.228.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _function = new alicloud.fc.V3Function("function", {
 *     memorySize: 512,
 *     cpu: 0.5,
 *     handler: "index.Handler",
 *     code: {
 *         zipFile: "UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA=",
 *     },
 *     functionName: name,
 *     runtime: "python3.9",
 *     diskSize: 512,
 *     logConfig: {
 *         logBeginRule: "None",
 *     },
 * });
 * const _default = new alicloud.fc.V3ConcurrencyConfig("default", {
 *     functionName: _function.functionName,
 *     reservedConcurrency: 100,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * function = alicloud.fc.V3Function("function",
 *     memory_size=512,
 *     cpu=0.5,
 *     handler="index.Handler",
 *     code={
 *         "zip_file": "UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA=",
 *     },
 *     function_name=name,
 *     runtime="python3.9",
 *     disk_size=512,
 *     log_config={
 *         "log_begin_rule": "None",
 *     })
 * default = alicloud.fc.V3ConcurrencyConfig("default",
 *     function_name=function.function_name,
 *     reserved_concurrency=100)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var function = new AliCloud.FC.V3Function("function", new()
 *     {
 *         MemorySize = 512,
 *         Cpu = 0.5,
 *         Handler = "index.Handler",
 *         Code = new AliCloud.FC.Inputs.V3FunctionCodeArgs
 *         {
 *             ZipFile = "UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA=",
 *         },
 *         FunctionName = name,
 *         Runtime = "python3.9",
 *         DiskSize = 512,
 *         LogConfig = new AliCloud.FC.Inputs.V3FunctionLogConfigArgs
 *         {
 *             LogBeginRule = "None",
 *         },
 *     });
 *     var @default = new AliCloud.FC.V3ConcurrencyConfig("default", new()
 *     {
 *         FunctionName = function.FunctionName,
 *         ReservedConcurrency = 100,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		function, err := fc.NewV3Function(ctx, "function", &fc.V3FunctionArgs{
 * 			MemorySize: pulumi.Int(512),
 * 			Cpu:        pulumi.Float64(0.5),
 * 			Handler:    pulumi.String("index.Handler"),
 * 			Code: &fc.V3FunctionCodeArgs{
 * 				ZipFile: pulumi.String("UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA="),
 * 			},
 * 			FunctionName: pulumi.String(name),
 * 			Runtime:      pulumi.String("python3.9"),
 * 			DiskSize:     pulumi.Int(512),
 * 			LogConfig: &fc.V3FunctionLogConfigArgs{
 * 				LogBeginRule: pulumi.String("None"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = fc.NewV3ConcurrencyConfig(ctx, "default", &fc.V3ConcurrencyConfigArgs{
 * 			FunctionName:        function.FunctionName,
 * 			ReservedConcurrency: pulumi.Int(100),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.fc.V3Function;
 * import com.pulumi.alicloud.fc.V3FunctionArgs;
 * import com.pulumi.alicloud.fc.inputs.V3FunctionCodeArgs;
 * import com.pulumi.alicloud.fc.inputs.V3FunctionLogConfigArgs;
 * import com.pulumi.alicloud.fc.V3ConcurrencyConfig;
 * import com.pulumi.alicloud.fc.V3ConcurrencyConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var function = new V3Function("function", V3FunctionArgs.builder()
 *             .memorySize("512")
 *             .cpu(0.5)
 *             .handler("index.Handler")
 *             .code(V3FunctionCodeArgs.builder()
 *                 .zipFile("UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA=")
 *                 .build())
 *             .functionName(name)
 *             .runtime("python3.9")
 *             .diskSize("512")
 *             .logConfig(V3FunctionLogConfigArgs.builder()
 *                 .logBeginRule("None")
 *                 .build())
 *             .build());
 *         var default_ = new V3ConcurrencyConfig("default", V3ConcurrencyConfigArgs.builder()
 *             .functionName(function.functionName())
 *             .reservedConcurrency("100")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   function:
 *     type: alicloud:fc:V3Function
 *     properties:
 *       memorySize: '512'
 *       cpu: 0.5
 *       handler: index.Handler
 *       code:
 *         zipFile: UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA=
 *       functionName: ${name}
 *       runtime: python3.9
 *       diskSize: '512'
 *       logConfig:
 *         logBeginRule: None
 *   default:
 *     type: alicloud:fc:V3ConcurrencyConfig
 *     properties:
 *       functionName: ${function.functionName}
 *       reservedConcurrency: '100'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * FCV3 Concurrency Config can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:fc/v3ConcurrencyConfig:V3ConcurrencyConfig example <id>
 * ```
 */
public class V3ConcurrencyConfig internal constructor(
    override val javaResource: com.pulumi.alicloud.fc.V3ConcurrencyConfig,
) : KotlinCustomResource(javaResource, V3ConcurrencyConfigMapper) {
    /**
     * Function Name
     */
    public val functionName: Output<String>
        get() = javaResource.functionName().applyValue({ args0 -> args0 })

    /**
     * Reserved Concurrency. Functions reserve a part of account concurrency. Other functions cannot use this part of concurrency. Reserved concurrency includes the total concurrency of Reserved Instances and As-You-go instances.
     */
    public val reservedConcurrency: Output<Int>?
        get() = javaResource.reservedConcurrency().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object V3ConcurrencyConfigMapper : ResourceMapper<V3ConcurrencyConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.fc.V3ConcurrencyConfig::class == javaResource::class

    override fun map(javaResource: Resource): V3ConcurrencyConfig = V3ConcurrencyConfig(
        javaResource
            as com.pulumi.alicloud.fc.V3ConcurrencyConfig,
    )
}

/**
 * @see [V3ConcurrencyConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [V3ConcurrencyConfig].
 */
public suspend fun v3ConcurrencyConfig(
    name: String,
    block: suspend V3ConcurrencyConfigResourceBuilder.() -> Unit,
): V3ConcurrencyConfig {
    val builder = V3ConcurrencyConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [V3ConcurrencyConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun v3ConcurrencyConfig(name: String): V3ConcurrencyConfig {
    val builder = V3ConcurrencyConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
