@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin

import com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionCode
import com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionCustomContainerConfig
import com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionCustomDns
import com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionCustomRuntimeConfig
import com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionGpuConfig
import com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionInstanceLifecycleConfig
import com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionLogConfig
import com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionNasConfig
import com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionOssMountConfig
import com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionVpcConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionCode.Companion.toKotlin as v3FunctionCodeToKotlin
import com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionCustomContainerConfig.Companion.toKotlin as v3FunctionCustomContainerConfigToKotlin
import com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionCustomDns.Companion.toKotlin as v3FunctionCustomDnsToKotlin
import com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionCustomRuntimeConfig.Companion.toKotlin as v3FunctionCustomRuntimeConfigToKotlin
import com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionGpuConfig.Companion.toKotlin as v3FunctionGpuConfigToKotlin
import com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionInstanceLifecycleConfig.Companion.toKotlin as v3FunctionInstanceLifecycleConfigToKotlin
import com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionLogConfig.Companion.toKotlin as v3FunctionLogConfigToKotlin
import com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionNasConfig.Companion.toKotlin as v3FunctionNasConfigToKotlin
import com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionOssMountConfig.Companion.toKotlin as v3FunctionOssMountConfigToKotlin
import com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionVpcConfig.Companion.toKotlin as v3FunctionVpcConfigToKotlin

/**
 * Builder for [V3Function].
 */
@PulumiTagMarker
public class V3FunctionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: V3FunctionArgs = V3FunctionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend V3FunctionArgsBuilder.() -> Unit) {
        val builder = V3FunctionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): V3Function {
        val builtJavaResource = com.pulumi.alicloud.fc.V3Function(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return V3Function(builtJavaResource)
    }
}

/**
 * Provides a FCV3 Function resource.
 * The resource scheduling and running of Function Compute is based on functions. The FC function consists of function code and function configuration.
 * For information about FCV3 Function and how to use it, see [What is Function](https://www.alibabacloud.com/help/en/functioncompute/developer-reference/api-fc-2023-03-30-getfunction).
 * > **NOTE:** Available since v1.228.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new random.index.Uuid("default", {});
 * const defaultBucket = new alicloud.oss.Bucket("default", {bucket: `${name}-${_default.result}`});
 * const defaultBucketObject = new alicloud.oss.BucketObject("default", {
 *     bucket: defaultBucket.bucket,
 *     key: "FCV3Py39.zip",
 *     content: "print('hello')",
 * });
 * const defaultV3Function = new alicloud.fc.V3Function("default", {
 *     description: "Create",
 *     memorySize: 512,
 *     layers: ["acs:fc:cn-shanghai:official:layers/Python39-Aliyun-SDK/versions/3"],
 *     timeout: 3,
 *     runtime: "custom.debian10",
 *     handler: "index.handler",
 *     diskSize: 512,
 *     customRuntimeConfig: {
 *         commands: [
 *             "python",
 *             "-c",
 *             "example",
 *         ],
 *         args: [
 *             "app.py",
 *             "xx",
 *             "x",
 *         ],
 *         port: 9000,
 *         healthCheckConfig: {
 *             httpGetUrl: "/ready",
 *             initialDelaySeconds: 1,
 *             periodSeconds: 10,
 *             successThreshold: 1,
 *             timeoutSeconds: 1,
 *             failureThreshold: 3,
 *         },
 *     },
 *     logConfig: {
 *         logBeginRule: "None",
 *     },
 *     code: {
 *         ossBucketName: defaultBucket.bucket,
 *         ossObjectName: defaultBucketObject.key,
 *         checksum: "4270285996107335518",
 *     },
 *     instanceLifecycleConfig: {
 *         initializer: {
 *             timeout: 1,
 *             handler: "index.init",
 *         },
 *         preStop: {
 *             timeout: 1,
 *             handler: "index.stop",
 *         },
 *     },
 *     cpu: 0.5,
 *     instanceConcurrency: 2,
 *     functionName: `${name}-${_default.result}`,
 *     environmentVariables: {
 *         EnvKey: "EnvVal",
 *     },
 *     internetAccess: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = random.index.Uuid("default")
 * default_bucket = alicloud.oss.Bucket("default", bucket=f"{name}-{default['result']}")
 * default_bucket_object = alicloud.oss.BucketObject("default",
 *     bucket=default_bucket.bucket,
 *     key="FCV3Py39.zip",
 *     content="print('hello')")
 * default_v3_function = alicloud.fc.V3Function("default",
 *     description="Create",
 *     memory_size=512,
 *     layers=["acs:fc:cn-shanghai:official:layers/Python39-Aliyun-SDK/versions/3"],
 *     timeout=3,
 *     runtime="custom.debian10",
 *     handler="index.handler",
 *     disk_size=512,
 *     custom_runtime_config={
 *         "commands": [
 *             "python",
 *             "-c",
 *             "example",
 *         ],
 *         "args": [
 *             "app.py",
 *             "xx",
 *             "x",
 *         ],
 *         "port": 9000,
 *         "health_check_config": {
 *             "http_get_url": "/ready",
 *             "initial_delay_seconds": 1,
 *             "period_seconds": 10,
 *             "success_threshold": 1,
 *             "timeout_seconds": 1,
 *             "failure_threshold": 3,
 *         },
 *     },
 *     log_config={
 *         "log_begin_rule": "None",
 *     },
 *     code={
 *         "oss_bucket_name": default_bucket.bucket,
 *         "oss_object_name": default_bucket_object.key,
 *         "checksum": "4270285996107335518",
 *     },
 *     instance_lifecycle_config={
 *         "initializer": {
 *             "timeout": 1,
 *             "handler": "index.init",
 *         },
 *         "pre_stop": {
 *             "timeout": 1,
 *             "handler": "index.stop",
 *         },
 *     },
 *     cpu=0.5,
 *     instance_concurrency=2,
 *     function_name=f"{name}-{default['result']}",
 *     environment_variables={
 *         "EnvKey": "EnvVal",
 *     },
 *     internet_access=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new Random.Index.Uuid("default");
 *     var defaultBucket = new AliCloud.Oss.Bucket("default", new()
 *     {
 *         BucketName = $"{name}-{@default.Result}",
 *     });
 *     var defaultBucketObject = new AliCloud.Oss.BucketObject("default", new()
 *     {
 *         Bucket = defaultBucket.BucketName,
 *         Key = "FCV3Py39.zip",
 *         Content = "print('hello')",
 *     });
 *     var defaultV3Function = new AliCloud.FC.V3Function("default", new()
 *     {
 *         Description = "Create",
 *         MemorySize = 512,
 *         Layers = new[]
 *         {
 *             "acs:fc:cn-shanghai:official:layers/Python39-Aliyun-SDK/versions/3",
 *         },
 *         Timeout = 3,
 *         Runtime = "custom.debian10",
 *         Handler = "index.handler",
 *         DiskSize = 512,
 *         CustomRuntimeConfig = new AliCloud.FC.Inputs.V3FunctionCustomRuntimeConfigArgs
 *         {
 *             Commands = new[]
 *             {
 *                 "python",
 *                 "-c",
 *                 "example",
 *             },
 *             Args = new[]
 *             {
 *                 "app.py",
 *                 "xx",
 *                 "x",
 *             },
 *             Port = 9000,
 *             HealthCheckConfig = new AliCloud.FC.Inputs.V3FunctionCustomRuntimeConfigHealthCheckConfigArgs
 *             {
 *                 HttpGetUrl = "/ready",
 *                 InitialDelaySeconds = 1,
 *                 PeriodSeconds = 10,
 *                 SuccessThreshold = 1,
 *                 TimeoutSeconds = 1,
 *                 FailureThreshold = 3,
 *             },
 *         },
 *         LogConfig = new AliCloud.FC.Inputs.V3FunctionLogConfigArgs
 *         {
 *             LogBeginRule = "None",
 *         },
 *         Code = new AliCloud.FC.Inputs.V3FunctionCodeArgs
 *         {
 *             OssBucketName = defaultBucket.BucketName,
 *             OssObjectName = defaultBucketObject.Key,
 *             Checksum = "4270285996107335518",
 *         },
 *         InstanceLifecycleConfig = new AliCloud.FC.Inputs.V3FunctionInstanceLifecycleConfigArgs
 *         {
 *             Initializer = new AliCloud.FC.Inputs.V3FunctionInstanceLifecycleConfigInitializerArgs
 *             {
 *                 Timeout = 1,
 *                 Handler = "index.init",
 *             },
 *             PreStop = new AliCloud.FC.Inputs.V3FunctionInstanceLifecycleConfigPreStopArgs
 *             {
 *                 Timeout = 1,
 *                 Handler = "index.stop",
 *             },
 *         },
 *         Cpu = 0.5,
 *         InstanceConcurrency = 2,
 *         FunctionName = $"{name}-{@default.Result}",
 *         EnvironmentVariables =
 *         {
 *             { "EnvKey", "EnvVal" },
 *         },
 *         InternetAccess = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fc"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewUuid(ctx, "default", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBucket, err := oss.NewBucket(ctx, "default", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("%v-%v", name, _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBucketObject, err := oss.NewBucketObject(ctx, "default", &oss.BucketObjectArgs{
 * 			Bucket:  defaultBucket.Bucket,
 * 			Key:     pulumi.String("FCV3Py39.zip"),
 * 			Content: pulumi.String("print('hello')"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = fc.NewV3Function(ctx, "default", &fc.V3FunctionArgs{
 * 			Description: pulumi.String("Create"),
 * 			MemorySize:  pulumi.Int(512),
 * 			Layers: pulumi.StringArray{
 * 				pulumi.String("acs:fc:cn-shanghai:official:layers/Python39-Aliyun-SDK/versions/3"),
 * 			},
 * 			Timeout:  pulumi.Int(3),
 * 			Runtime:  pulumi.String("custom.debian10"),
 * 			Handler:  pulumi.String("index.handler"),
 * 			DiskSize: pulumi.Int(512),
 * 			CustomRuntimeConfig: &fc.V3FunctionCustomRuntimeConfigArgs{
 * 				Commands: pulumi.StringArray{
 * 					pulumi.String("python"),
 * 					pulumi.String("-c"),
 * 					pulumi.String("example"),
 * 				},
 * 				Args: pulumi.StringArray{
 * 					pulumi.String("app.py"),
 * 					pulumi.String("xx"),
 * 					pulumi.String("x"),
 * 				},
 * 				Port: pulumi.Int(9000),
 * 				HealthCheckConfig: &fc.V3FunctionCustomRuntimeConfigHealthCheckConfigArgs{
 * 					HttpGetUrl:          pulumi.String("/ready"),
 * 					InitialDelaySeconds: pulumi.Int(1),
 * 					PeriodSeconds:       pulumi.Int(10),
 * 					SuccessThreshold:    pulumi.Int(1),
 * 					TimeoutSeconds:      pulumi.Int(1),
 * 					FailureThreshold:    pulumi.Int(3),
 * 				},
 * 			},
 * 			LogConfig: &fc.V3FunctionLogConfigArgs{
 * 				LogBeginRule: pulumi.String("None"),
 * 			},
 * 			Code: &fc.V3FunctionCodeArgs{
 * 				OssBucketName: defaultBucket.Bucket,
 * 				OssObjectName: defaultBucketObject.Key,
 * 				Checksum:      pulumi.String("4270285996107335518"),
 * 			},
 * 			InstanceLifecycleConfig: &fc.V3FunctionInstanceLifecycleConfigArgs{
 * 				Initializer: &fc.V3FunctionInstanceLifecycleConfigInitializerArgs{
 * 					Timeout: pulumi.Int(1),
 * 					Handler: pulumi.String("index.init"),
 * 				},
 * 				PreStop: &fc.V3FunctionInstanceLifecycleConfigPreStopArgs{
 * 					Timeout: pulumi.Int(1),
 * 					Handler: pulumi.String("index.stop"),
 * 				},
 * 			},
 * 			Cpu:                 pulumi.Float64(0.5),
 * 			InstanceConcurrency: pulumi.Int(2),
 * 			FunctionName:        pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			EnvironmentVariables: pulumi.StringMap{
 * 				"EnvKey": pulumi.String("EnvVal"),
 * 			},
 * 			InternetAccess: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.uuid;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.oss.BucketObject;
 * import com.pulumi.alicloud.oss.BucketObjectArgs;
 * import com.pulumi.alicloud.fc.V3Function;
 * import com.pulumi.alicloud.fc.V3FunctionArgs;
 * import com.pulumi.alicloud.fc.inputs.V3FunctionCustomRuntimeConfigArgs;
 * import com.pulumi.alicloud.fc.inputs.V3FunctionCustomRuntimeConfigHealthCheckConfigArgs;
 * import com.pulumi.alicloud.fc.inputs.V3FunctionLogConfigArgs;
 * import com.pulumi.alicloud.fc.inputs.V3FunctionCodeArgs;
 * import com.pulumi.alicloud.fc.inputs.V3FunctionInstanceLifecycleConfigArgs;
 * import com.pulumi.alicloud.fc.inputs.V3FunctionInstanceLifecycleConfigInitializerArgs;
 * import com.pulumi.alicloud.fc.inputs.V3FunctionInstanceLifecycleConfigPreStopArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Uuid("default");
 *         var defaultBucket = new Bucket("defaultBucket", BucketArgs.builder()
 *             .bucket(String.format("%s-%s", name,default_.result()))
 *             .build());
 *         var defaultBucketObject = new BucketObject("defaultBucketObject", BucketObjectArgs.builder()
 *             .bucket(defaultBucket.bucket())
 *             .key("FCV3Py39.zip")
 *             .content("print('hello')")
 *             .build());
 *         var defaultV3Function = new V3Function("defaultV3Function", V3FunctionArgs.builder()
 *             .description("Create")
 *             .memorySize("512")
 *             .layers("acs:fc:cn-shanghai:official:layers/Python39-Aliyun-SDK/versions/3")
 *             .timeout("3")
 *             .runtime("custom.debian10")
 *             .handler("index.handler")
 *             .diskSize("512")
 *             .customRuntimeConfig(V3FunctionCustomRuntimeConfigArgs.builder()
 *                 .commands(
 *                     "python",
 *                     "-c",
 *                     "example")
 *                 .args(
 *                     "app.py",
 *                     "xx",
 *                     "x")
 *                 .port("9000")
 *                 .healthCheckConfig(V3FunctionCustomRuntimeConfigHealthCheckConfigArgs.builder()
 *                     .httpGetUrl("/ready")
 *                     .initialDelaySeconds("1")
 *                     .periodSeconds("10")
 *                     .successThreshold("1")
 *                     .timeoutSeconds("1")
 *                     .failureThreshold("3")
 *                     .build())
 *                 .build())
 *             .logConfig(V3FunctionLogConfigArgs.builder()
 *                 .logBeginRule("None")
 *                 .build())
 *             .code(V3FunctionCodeArgs.builder()
 *                 .ossBucketName(defaultBucket.bucket())
 *                 .ossObjectName(defaultBucketObject.key())
 *                 .checksum("4270285996107335518")
 *                 .build())
 *             .instanceLifecycleConfig(V3FunctionInstanceLifecycleConfigArgs.builder()
 *                 .initializer(V3FunctionInstanceLifecycleConfigInitializerArgs.builder()
 *                     .timeout("1")
 *                     .handler("index.init")
 *                     .build())
 *                 .preStop(V3FunctionInstanceLifecycleConfigPreStopArgs.builder()
 *                     .timeout("1")
 *                     .handler("index.stop")
 *                     .build())
 *                 .build())
 *             .cpu("0.5")
 *             .instanceConcurrency("2")
 *             .functionName(String.format("%s-%s", name,default_.result()))
 *             .environmentVariables(Map.of("EnvKey", "EnvVal"))
 *             .internetAccess("true")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: random:uuid
 *   defaultBucket:
 *     type: alicloud:oss:Bucket
 *     name: default
 *     properties:
 *       bucket: ${name}-${default.result}
 *   defaultBucketObject:
 *     type: alicloud:oss:BucketObject
 *     name: default
 *     properties:
 *       bucket: ${defaultBucket.bucket}
 *       key: FCV3Py39.zip
 *       content: print('hello')
 *   defaultV3Function:
 *     type: alicloud:fc:V3Function
 *     name: default
 *     properties:
 *       description: Create
 *       memorySize: '512'
 *       layers:
 *         - acs:fc:cn-shanghai:official:layers/Python39-Aliyun-SDK/versions/3
 *       timeout: '3'
 *       runtime: custom.debian10
 *       handler: index.handler
 *       diskSize: '512'
 *       customRuntimeConfig:
 *         commands:
 *           - python
 *           - -c
 *           - example
 *         args:
 *           - app.py
 *           - xx
 *           - x
 *         port: '9000'
 *         healthCheckConfig:
 *           httpGetUrl: /ready
 *           initialDelaySeconds: '1'
 *           periodSeconds: '10'
 *           successThreshold: '1'
 *           timeoutSeconds: '1'
 *           failureThreshold: '3'
 *       logConfig:
 *         logBeginRule: None
 *       code:
 *         ossBucketName: ${defaultBucket.bucket}
 *         ossObjectName: ${defaultBucketObject.key}
 *         checksum: '4270285996107335518'
 *       instanceLifecycleConfig:
 *         initializer:
 *           timeout: '1'
 *           handler: index.init
 *         preStop:
 *           timeout: '1'
 *           handler: index.stop
 *       cpu: '0.5'
 *       instanceConcurrency: '2'
 *       functionName: ${name}-${default.result}
 *       environmentVariables:
 *         EnvKey: EnvVal
 *       internetAccess: 'true'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * FCV3 Function can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:fc/v3Function:V3Function example <id>
 * ```
 */
public class V3Function internal constructor(
    override val javaResource: com.pulumi.alicloud.fc.V3Function,
) : KotlinCustomResource(javaResource, V3FunctionMapper) {
    /**
     * Function code ZIP package. code and customContainerConfig. See `code` below.
     */
    public val code: Output<V3FunctionCode>?
        get() = javaResource.code().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    v3FunctionCodeToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The CPU specification of the function. The unit is vCPU, which is a multiple of the 0.05 vCPU.
     */
    public val cpu: Output<Double>
        get() = javaResource.cpu().applyValue({ args0 -> args0 })

    /**
     * The creation time of the function.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The configuration of the custom container runtime. After the configuration is successful, the function can use the custom container image to execute the function. code and customContainerConfig. See `custom_container_config` below.
     */
    public val customContainerConfig: Output<V3FunctionCustomContainerConfig>?
        get() = javaResource.customContainerConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> v3FunctionCustomContainerConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Function custom DNS configuration See `custom_dns` below.
     */
    public val customDns: Output<V3FunctionCustomDns>?
        get() = javaResource.customDns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    v3FunctionCustomDnsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Customize the runtime configuration. See `custom_runtime_config` below.
     */
    public val customRuntimeConfig: Output<V3FunctionCustomRuntimeConfig>?
        get() = javaResource.customRuntimeConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> v3FunctionCustomRuntimeConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The description of the function. The function compute system does not use this attribute value, but we recommend that you set a concise and clear description for the function.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The disk specification of the function, in MB. The optional value is 512 MB or 10240MB.
     */
    public val diskSize: Output<Int>
        get() = javaResource.diskSize().applyValue({ args0 -> args0 })

    /**
     * The environment variable set for the function, you can get the value of the environment variable in the function.
     */
    public val environmentVariables: Output<Map<String, String>>?
        get() = javaResource.environmentVariables().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The function name. Consists of uppercase and lowercase letters, digits (0 to 9), underscores (_), and dashes (-). It must begin with an English letter (a ~ z), (A ~ Z), or an underscore (_). Case sensitive. The length is 1~128 characters.
     */
    public val functionName: Output<String>
        get() = javaResource.functionName().applyValue({ args0 -> args0 })

    /**
     * Function GPU configuration. See `gpu_config` below.
     */
    public val gpuConfig: Output<V3FunctionGpuConfig>?
        get() = javaResource.gpuConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    v3FunctionGpuConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Function Handler: the call entry for the function compute system to run your function.
     */
    public val handler: Output<String>
        get() = javaResource.handler().applyValue({ args0 -> args0 })

    /**
     * Maximum instance concurrency.
     */
    public val instanceConcurrency: Output<Int>
        get() = javaResource.instanceConcurrency().applyValue({ args0 -> args0 })

    /**
     * Instance lifecycle callback method configuration. See `instance_lifecycle_config` below.
     */
    public val instanceLifecycleConfig: Output<V3FunctionInstanceLifecycleConfig>?
        get() = javaResource.instanceLifecycleConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> v3FunctionInstanceLifecycleConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Allow function to access public network
     */
    public val internetAccess: Output<Boolean>
        get() = javaResource.internetAccess().applyValue({ args0 -> args0 })

    /**
     * The list of layers.
     */
    public val layers: Output<List<String>>?
        get() = javaResource.layers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The logs generated by the function are written to the configured Logstore. See `log_config` below.
     */
    public val logConfig: Output<V3FunctionLogConfig>?
        get() = javaResource.logConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    v3FunctionLogConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The memory specification of the function. The unit is MB. The memory size is a multiple of 64MB. The minimum value is 128MB and the maximum value is 32GB. At the same time, the ratio of cpu to memorySize (calculated by GB) should be between 1:1 and 1:4.
     */
    public val memorySize: Output<Int>
        get() = javaResource.memorySize().applyValue({ args0 -> args0 })

    /**
     * NAS configuration. After this parameter is configured, the function can access the specified NAS resource. See `nas_config` below.
     */
    public val nasConfig: Output<V3FunctionNasConfig>
        get() = javaResource.nasConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                v3FunctionNasConfigToKotlin(args0)
            })
        })

    /**
     * OSS mount configuration See `oss_mount_config` below.
     */
    public val ossMountConfig: Output<V3FunctionOssMountConfig>
        get() = javaResource.ossMountConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                v3FunctionOssMountConfigToKotlin(args0)
            })
        })

    /**
     * The user is authorized to the RAM role of function compute. After the configuration, function compute will assume this role to generate temporary access credentials. In the function, you can use the temporary access credentials of the role to access the specified Alibaba cloud service, such as OSS and OTS
     */
    public val role: Output<String>?
        get() = javaResource.role().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Function runtime type
     */
    public val runtime: Output<String>
        get() = javaResource.runtime().applyValue({ args0 -> args0 })

    /**
     * The maximum running time of the function, in seconds.
     */
    public val timeout: Output<Int>
        get() = javaResource.timeout().applyValue({ args0 -> args0 })

    /**
     * VPC configuration. After this parameter is configured, the function can access the specified VPC resources. See `vpc_config` below.
     */
    public val vpcConfig: Output<V3FunctionVpcConfig>
        get() = javaResource.vpcConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                v3FunctionVpcConfigToKotlin(args0)
            })
        })
}

public object V3FunctionMapper : ResourceMapper<V3Function> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.fc.V3Function::class == javaResource::class

    override fun map(javaResource: Resource): V3Function = V3Function(
        javaResource as
            com.pulumi.alicloud.fc.V3Function,
    )
}

/**
 * @see [V3Function].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [V3Function].
 */
public suspend fun v3Function(name: String, block: suspend V3FunctionResourceBuilder.() -> Unit): V3Function {
    val builder = V3FunctionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [V3Function].
 * @param name The _unique_ name of the resulting resource.
 */
public fun v3Function(name: String): V3Function {
    val builder = V3FunctionResourceBuilder()
    builder.name(name)
    return builder.build()
}
