@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin

import com.pulumi.alicloud.fc.V3FunctionArgs.builder
import com.pulumi.alicloud.fc.kotlin.inputs.V3FunctionCodeArgs
import com.pulumi.alicloud.fc.kotlin.inputs.V3FunctionCodeArgsBuilder
import com.pulumi.alicloud.fc.kotlin.inputs.V3FunctionCustomContainerConfigArgs
import com.pulumi.alicloud.fc.kotlin.inputs.V3FunctionCustomContainerConfigArgsBuilder
import com.pulumi.alicloud.fc.kotlin.inputs.V3FunctionCustomDnsArgs
import com.pulumi.alicloud.fc.kotlin.inputs.V3FunctionCustomDnsArgsBuilder
import com.pulumi.alicloud.fc.kotlin.inputs.V3FunctionCustomRuntimeConfigArgs
import com.pulumi.alicloud.fc.kotlin.inputs.V3FunctionCustomRuntimeConfigArgsBuilder
import com.pulumi.alicloud.fc.kotlin.inputs.V3FunctionGpuConfigArgs
import com.pulumi.alicloud.fc.kotlin.inputs.V3FunctionGpuConfigArgsBuilder
import com.pulumi.alicloud.fc.kotlin.inputs.V3FunctionInstanceLifecycleConfigArgs
import com.pulumi.alicloud.fc.kotlin.inputs.V3FunctionInstanceLifecycleConfigArgsBuilder
import com.pulumi.alicloud.fc.kotlin.inputs.V3FunctionLogConfigArgs
import com.pulumi.alicloud.fc.kotlin.inputs.V3FunctionLogConfigArgsBuilder
import com.pulumi.alicloud.fc.kotlin.inputs.V3FunctionNasConfigArgs
import com.pulumi.alicloud.fc.kotlin.inputs.V3FunctionNasConfigArgsBuilder
import com.pulumi.alicloud.fc.kotlin.inputs.V3FunctionOssMountConfigArgs
import com.pulumi.alicloud.fc.kotlin.inputs.V3FunctionOssMountConfigArgsBuilder
import com.pulumi.alicloud.fc.kotlin.inputs.V3FunctionVpcConfigArgs
import com.pulumi.alicloud.fc.kotlin.inputs.V3FunctionVpcConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a FCV3 Function resource.
 * The resource scheduling and running of Function Compute is based on functions. The FC function consists of function code and function configuration.
 * For information about FCV3 Function and how to use it, see [What is Function](https://www.alibabacloud.com/help/en/functioncompute/developer-reference/api-fc-2023-03-30-getfunction).
 * > **NOTE:** Available since v1.228.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new random.index.Uuid("default", {});
 * const defaultBucket = new alicloud.oss.Bucket("default", {bucket: `${name}-${_default.result}`});
 * const defaultBucketObject = new alicloud.oss.BucketObject("default", {
 *     bucket: defaultBucket.bucket,
 *     key: "FCV3Py39.zip",
 *     content: "print('hello')",
 * });
 * const defaultV3Function = new alicloud.fc.V3Function("default", {
 *     description: "Create",
 *     memorySize: 512,
 *     layers: ["acs:fc:cn-shanghai:official:layers/Python39-Aliyun-SDK/versions/3"],
 *     timeout: 3,
 *     runtime: "custom.debian10",
 *     handler: "index.handler",
 *     diskSize: 512,
 *     customRuntimeConfig: {
 *         commands: [
 *             "python",
 *             "-c",
 *             "example",
 *         ],
 *         args: [
 *             "app.py",
 *             "xx",
 *             "x",
 *         ],
 *         port: 9000,
 *         healthCheckConfig: {
 *             httpGetUrl: "/ready",
 *             initialDelaySeconds: 1,
 *             periodSeconds: 10,
 *             successThreshold: 1,
 *             timeoutSeconds: 1,
 *             failureThreshold: 3,
 *         },
 *     },
 *     logConfig: {
 *         logBeginRule: "None",
 *     },
 *     code: {
 *         ossBucketName: defaultBucket.bucket,
 *         ossObjectName: defaultBucketObject.key,
 *         checksum: "4270285996107335518",
 *     },
 *     instanceLifecycleConfig: {
 *         initializer: {
 *             timeout: 1,
 *             handler: "index.init",
 *         },
 *         preStop: {
 *             timeout: 1,
 *             handler: "index.stop",
 *         },
 *     },
 *     cpu: 0.5,
 *     instanceConcurrency: 2,
 *     functionName: `${name}-${_default.result}`,
 *     environmentVariables: {
 *         EnvKey: "EnvVal",
 *     },
 *     internetAccess: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = random.index.Uuid("default")
 * default_bucket = alicloud.oss.Bucket("default", bucket=f"{name}-{default['result']}")
 * default_bucket_object = alicloud.oss.BucketObject("default",
 *     bucket=default_bucket.bucket,
 *     key="FCV3Py39.zip",
 *     content="print('hello')")
 * default_v3_function = alicloud.fc.V3Function("default",
 *     description="Create",
 *     memory_size=512,
 *     layers=["acs:fc:cn-shanghai:official:layers/Python39-Aliyun-SDK/versions/3"],
 *     timeout=3,
 *     runtime="custom.debian10",
 *     handler="index.handler",
 *     disk_size=512,
 *     custom_runtime_config={
 *         "commands": [
 *             "python",
 *             "-c",
 *             "example",
 *         ],
 *         "args": [
 *             "app.py",
 *             "xx",
 *             "x",
 *         ],
 *         "port": 9000,
 *         "health_check_config": {
 *             "http_get_url": "/ready",
 *             "initial_delay_seconds": 1,
 *             "period_seconds": 10,
 *             "success_threshold": 1,
 *             "timeout_seconds": 1,
 *             "failure_threshold": 3,
 *         },
 *     },
 *     log_config={
 *         "log_begin_rule": "None",
 *     },
 *     code={
 *         "oss_bucket_name": default_bucket.bucket,
 *         "oss_object_name": default_bucket_object.key,
 *         "checksum": "4270285996107335518",
 *     },
 *     instance_lifecycle_config={
 *         "initializer": {
 *             "timeout": 1,
 *             "handler": "index.init",
 *         },
 *         "pre_stop": {
 *             "timeout": 1,
 *             "handler": "index.stop",
 *         },
 *     },
 *     cpu=0.5,
 *     instance_concurrency=2,
 *     function_name=f"{name}-{default['result']}",
 *     environment_variables={
 *         "EnvKey": "EnvVal",
 *     },
 *     internet_access=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new Random.Index.Uuid("default");
 *     var defaultBucket = new AliCloud.Oss.Bucket("default", new()
 *     {
 *         BucketName = $"{name}-{@default.Result}",
 *     });
 *     var defaultBucketObject = new AliCloud.Oss.BucketObject("default", new()
 *     {
 *         Bucket = defaultBucket.BucketName,
 *         Key = "FCV3Py39.zip",
 *         Content = "print('hello')",
 *     });
 *     var defaultV3Function = new AliCloud.FC.V3Function("default", new()
 *     {
 *         Description = "Create",
 *         MemorySize = 512,
 *         Layers = new[]
 *         {
 *             "acs:fc:cn-shanghai:official:layers/Python39-Aliyun-SDK/versions/3",
 *         },
 *         Timeout = 3,
 *         Runtime = "custom.debian10",
 *         Handler = "index.handler",
 *         DiskSize = 512,
 *         CustomRuntimeConfig = new AliCloud.FC.Inputs.V3FunctionCustomRuntimeConfigArgs
 *         {
 *             Commands = new[]
 *             {
 *                 "python",
 *                 "-c",
 *                 "example",
 *             },
 *             Args = new[]
 *             {
 *                 "app.py",
 *                 "xx",
 *                 "x",
 *             },
 *             Port = 9000,
 *             HealthCheckConfig = new AliCloud.FC.Inputs.V3FunctionCustomRuntimeConfigHealthCheckConfigArgs
 *             {
 *                 HttpGetUrl = "/ready",
 *                 InitialDelaySeconds = 1,
 *                 PeriodSeconds = 10,
 *                 SuccessThreshold = 1,
 *                 TimeoutSeconds = 1,
 *                 FailureThreshold = 3,
 *             },
 *         },
 *         LogConfig = new AliCloud.FC.Inputs.V3FunctionLogConfigArgs
 *         {
 *             LogBeginRule = "None",
 *         },
 *         Code = new AliCloud.FC.Inputs.V3FunctionCodeArgs
 *         {
 *             OssBucketName = defaultBucket.BucketName,
 *             OssObjectName = defaultBucketObject.Key,
 *             Checksum = "4270285996107335518",
 *         },
 *         InstanceLifecycleConfig = new AliCloud.FC.Inputs.V3FunctionInstanceLifecycleConfigArgs
 *         {
 *             Initializer = new AliCloud.FC.Inputs.V3FunctionInstanceLifecycleConfigInitializerArgs
 *             {
 *                 Timeout = 1,
 *                 Handler = "index.init",
 *             },
 *             PreStop = new AliCloud.FC.Inputs.V3FunctionInstanceLifecycleConfigPreStopArgs
 *             {
 *                 Timeout = 1,
 *                 Handler = "index.stop",
 *             },
 *         },
 *         Cpu = 0.5,
 *         InstanceConcurrency = 2,
 *         FunctionName = $"{name}-{@default.Result}",
 *         EnvironmentVariables =
 *         {
 *             { "EnvKey", "EnvVal" },
 *         },
 *         InternetAccess = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fc"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewUuid(ctx, "default", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBucket, err := oss.NewBucket(ctx, "default", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("%v-%v", name, _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBucketObject, err := oss.NewBucketObject(ctx, "default", &oss.BucketObjectArgs{
 * 			Bucket:  defaultBucket.Bucket,
 * 			Key:     pulumi.String("FCV3Py39.zip"),
 * 			Content: pulumi.String("print('hello')"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = fc.NewV3Function(ctx, "default", &fc.V3FunctionArgs{
 * 			Description: pulumi.String("Create"),
 * 			MemorySize:  pulumi.Int(512),
 * 			Layers: pulumi.StringArray{
 * 				pulumi.String("acs:fc:cn-shanghai:official:layers/Python39-Aliyun-SDK/versions/3"),
 * 			},
 * 			Timeout:  pulumi.Int(3),
 * 			Runtime:  pulumi.String("custom.debian10"),
 * 			Handler:  pulumi.String("index.handler"),
 * 			DiskSize: pulumi.Int(512),
 * 			CustomRuntimeConfig: &fc.V3FunctionCustomRuntimeConfigArgs{
 * 				Commands: pulumi.StringArray{
 * 					pulumi.String("python"),
 * 					pulumi.String("-c"),
 * 					pulumi.String("example"),
 * 				},
 * 				Args: pulumi.StringArray{
 * 					pulumi.String("app.py"),
 * 					pulumi.String("xx"),
 * 					pulumi.String("x"),
 * 				},
 * 				Port: pulumi.Int(9000),
 * 				HealthCheckConfig: &fc.V3FunctionCustomRuntimeConfigHealthCheckConfigArgs{
 * 					HttpGetUrl:          pulumi.String("/ready"),
 * 					InitialDelaySeconds: pulumi.Int(1),
 * 					PeriodSeconds:       pulumi.Int(10),
 * 					SuccessThreshold:    pulumi.Int(1),
 * 					TimeoutSeconds:      pulumi.Int(1),
 * 					FailureThreshold:    pulumi.Int(3),
 * 				},
 * 			},
 * 			LogConfig: &fc.V3FunctionLogConfigArgs{
 * 				LogBeginRule: pulumi.String("None"),
 * 			},
 * 			Code: &fc.V3FunctionCodeArgs{
 * 				OssBucketName: defaultBucket.Bucket,
 * 				OssObjectName: defaultBucketObject.Key,
 * 				Checksum:      pulumi.String("4270285996107335518"),
 * 			},
 * 			InstanceLifecycleConfig: &fc.V3FunctionInstanceLifecycleConfigArgs{
 * 				Initializer: &fc.V3FunctionInstanceLifecycleConfigInitializerArgs{
 * 					Timeout: pulumi.Int(1),
 * 					Handler: pulumi.String("index.init"),
 * 				},
 * 				PreStop: &fc.V3FunctionInstanceLifecycleConfigPreStopArgs{
 * 					Timeout: pulumi.Int(1),
 * 					Handler: pulumi.String("index.stop"),
 * 				},
 * 			},
 * 			Cpu:                 pulumi.Float64(0.5),
 * 			InstanceConcurrency: pulumi.Int(2),
 * 			FunctionName:        pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			EnvironmentVariables: pulumi.StringMap{
 * 				"EnvKey": pulumi.String("EnvVal"),
 * 			},
 * 			InternetAccess: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.uuid;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.oss.BucketObject;
 * import com.pulumi.alicloud.oss.BucketObjectArgs;
 * import com.pulumi.alicloud.fc.V3Function;
 * import com.pulumi.alicloud.fc.V3FunctionArgs;
 * import com.pulumi.alicloud.fc.inputs.V3FunctionCustomRuntimeConfigArgs;
 * import com.pulumi.alicloud.fc.inputs.V3FunctionCustomRuntimeConfigHealthCheckConfigArgs;
 * import com.pulumi.alicloud.fc.inputs.V3FunctionLogConfigArgs;
 * import com.pulumi.alicloud.fc.inputs.V3FunctionCodeArgs;
 * import com.pulumi.alicloud.fc.inputs.V3FunctionInstanceLifecycleConfigArgs;
 * import com.pulumi.alicloud.fc.inputs.V3FunctionInstanceLifecycleConfigInitializerArgs;
 * import com.pulumi.alicloud.fc.inputs.V3FunctionInstanceLifecycleConfigPreStopArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Uuid("default");
 *         var defaultBucket = new Bucket("defaultBucket", BucketArgs.builder()
 *             .bucket(String.format("%s-%s", name,default_.result()))
 *             .build());
 *         var defaultBucketObject = new BucketObject("defaultBucketObject", BucketObjectArgs.builder()
 *             .bucket(defaultBucket.bucket())
 *             .key("FCV3Py39.zip")
 *             .content("print('hello')")
 *             .build());
 *         var defaultV3Function = new V3Function("defaultV3Function", V3FunctionArgs.builder()
 *             .description("Create")
 *             .memorySize("512")
 *             .layers("acs:fc:cn-shanghai:official:layers/Python39-Aliyun-SDK/versions/3")
 *             .timeout("3")
 *             .runtime("custom.debian10")
 *             .handler("index.handler")
 *             .diskSize("512")
 *             .customRuntimeConfig(V3FunctionCustomRuntimeConfigArgs.builder()
 *                 .commands(
 *                     "python",
 *                     "-c",
 *                     "example")
 *                 .args(
 *                     "app.py",
 *                     "xx",
 *                     "x")
 *                 .port("9000")
 *                 .healthCheckConfig(V3FunctionCustomRuntimeConfigHealthCheckConfigArgs.builder()
 *                     .httpGetUrl("/ready")
 *                     .initialDelaySeconds("1")
 *                     .periodSeconds("10")
 *                     .successThreshold("1")
 *                     .timeoutSeconds("1")
 *                     .failureThreshold("3")
 *                     .build())
 *                 .build())
 *             .logConfig(V3FunctionLogConfigArgs.builder()
 *                 .logBeginRule("None")
 *                 .build())
 *             .code(V3FunctionCodeArgs.builder()
 *                 .ossBucketName(defaultBucket.bucket())
 *                 .ossObjectName(defaultBucketObject.key())
 *                 .checksum("4270285996107335518")
 *                 .build())
 *             .instanceLifecycleConfig(V3FunctionInstanceLifecycleConfigArgs.builder()
 *                 .initializer(V3FunctionInstanceLifecycleConfigInitializerArgs.builder()
 *                     .timeout("1")
 *                     .handler("index.init")
 *                     .build())
 *                 .preStop(V3FunctionInstanceLifecycleConfigPreStopArgs.builder()
 *                     .timeout("1")
 *                     .handler("index.stop")
 *                     .build())
 *                 .build())
 *             .cpu("0.5")
 *             .instanceConcurrency("2")
 *             .functionName(String.format("%s-%s", name,default_.result()))
 *             .environmentVariables(Map.of("EnvKey", "EnvVal"))
 *             .internetAccess("true")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: random:uuid
 *   defaultBucket:
 *     type: alicloud:oss:Bucket
 *     name: default
 *     properties:
 *       bucket: ${name}-${default.result}
 *   defaultBucketObject:
 *     type: alicloud:oss:BucketObject
 *     name: default
 *     properties:
 *       bucket: ${defaultBucket.bucket}
 *       key: FCV3Py39.zip
 *       content: print('hello')
 *   defaultV3Function:
 *     type: alicloud:fc:V3Function
 *     name: default
 *     properties:
 *       description: Create
 *       memorySize: '512'
 *       layers:
 *         - acs:fc:cn-shanghai:official:layers/Python39-Aliyun-SDK/versions/3
 *       timeout: '3'
 *       runtime: custom.debian10
 *       handler: index.handler
 *       diskSize: '512'
 *       customRuntimeConfig:
 *         commands:
 *           - python
 *           - -c
 *           - example
 *         args:
 *           - app.py
 *           - xx
 *           - x
 *         port: '9000'
 *         healthCheckConfig:
 *           httpGetUrl: /ready
 *           initialDelaySeconds: '1'
 *           periodSeconds: '10'
 *           successThreshold: '1'
 *           timeoutSeconds: '1'
 *           failureThreshold: '3'
 *       logConfig:
 *         logBeginRule: None
 *       code:
 *         ossBucketName: ${defaultBucket.bucket}
 *         ossObjectName: ${defaultBucketObject.key}
 *         checksum: '4270285996107335518'
 *       instanceLifecycleConfig:
 *         initializer:
 *           timeout: '1'
 *           handler: index.init
 *         preStop:
 *           timeout: '1'
 *           handler: index.stop
 *       cpu: '0.5'
 *       instanceConcurrency: '2'
 *       functionName: ${name}-${default.result}
 *       environmentVariables:
 *         EnvKey: EnvVal
 *       internetAccess: 'true'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * FCV3 Function can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:fc/v3Function:V3Function example <id>
 * ```
 * @property code Function code ZIP package. code and customContainerConfig. See `code` below.
 * @property cpu The CPU specification of the function. The unit is vCPU, which is a multiple of the 0.05 vCPU.
 * @property customContainerConfig The configuration of the custom container runtime. After the configuration is successful, the function can use the custom container image to execute the function. code and customContainerConfig. See `custom_container_config` below.
 * @property customDns Function custom DNS configuration See `custom_dns` below.
 * @property customRuntimeConfig Customize the runtime configuration. See `custom_runtime_config` below.
 * @property description The description of the function. The function compute system does not use this attribute value, but we recommend that you set a concise and clear description for the function.
 * @property diskSize The disk specification of the function, in MB. The optional value is 512 MB or 10240MB.
 * @property environmentVariables The environment variable set for the function, you can get the value of the environment variable in the function.
 * @property functionName The function name. Consists of uppercase and lowercase letters, digits (0 to 9), underscores (_), and dashes (-). It must begin with an English letter (a ~ z), (A ~ Z), or an underscore (_). Case sensitive. The length is 1~128 characters.
 * @property gpuConfig Function GPU configuration. See `gpu_config` below.
 * @property handler Function Handler: the call entry for the function compute system to run your function.
 * @property instanceConcurrency Maximum instance concurrency.
 * @property instanceLifecycleConfig Instance lifecycle callback method configuration. See `instance_lifecycle_config` below.
 * @property internetAccess Allow function to access public network
 * @property layers The list of layers.
 * @property logConfig The logs generated by the function are written to the configured Logstore. See `log_config` below.
 * @property memorySize The memory specification of the function. The unit is MB. The memory size is a multiple of 64MB. The minimum value is 128MB and the maximum value is 32GB. At the same time, the ratio of cpu to memorySize (calculated by GB) should be between 1:1 and 1:4.
 * @property nasConfig NAS configuration. After this parameter is configured, the function can access the specified NAS resource. See `nas_config` below.
 * @property ossMountConfig OSS mount configuration See `oss_mount_config` below.
 * @property role The user is authorized to the RAM role of function compute. After the configuration, function compute will assume this role to generate temporary access credentials. In the function, you can use the temporary access credentials of the role to access the specified Alibaba cloud service, such as OSS and OTS
 * @property runtime Function runtime type
 * @property timeout The maximum running time of the function, in seconds.
 * @property vpcConfig VPC configuration. After this parameter is configured, the function can access the specified VPC resources. See `vpc_config` below.
 */
public data class V3FunctionArgs(
    public val code: Output<V3FunctionCodeArgs>? = null,
    public val cpu: Output<Double>? = null,
    public val customContainerConfig: Output<V3FunctionCustomContainerConfigArgs>? = null,
    public val customDns: Output<V3FunctionCustomDnsArgs>? = null,
    public val customRuntimeConfig: Output<V3FunctionCustomRuntimeConfigArgs>? = null,
    public val description: Output<String>? = null,
    public val diskSize: Output<Int>? = null,
    public val environmentVariables: Output<Map<String, String>>? = null,
    public val functionName: Output<String>? = null,
    public val gpuConfig: Output<V3FunctionGpuConfigArgs>? = null,
    public val handler: Output<String>? = null,
    public val instanceConcurrency: Output<Int>? = null,
    public val instanceLifecycleConfig: Output<V3FunctionInstanceLifecycleConfigArgs>? = null,
    public val internetAccess: Output<Boolean>? = null,
    public val layers: Output<List<String>>? = null,
    public val logConfig: Output<V3FunctionLogConfigArgs>? = null,
    public val memorySize: Output<Int>? = null,
    public val nasConfig: Output<V3FunctionNasConfigArgs>? = null,
    public val ossMountConfig: Output<V3FunctionOssMountConfigArgs>? = null,
    public val role: Output<String>? = null,
    public val runtime: Output<String>? = null,
    public val timeout: Output<Int>? = null,
    public val vpcConfig: Output<V3FunctionVpcConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.V3FunctionArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.V3FunctionArgs =
        com.pulumi.alicloud.fc.V3FunctionArgs.builder()
            .code(code?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .customContainerConfig(
                customContainerConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customDns(customDns?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customRuntimeConfig(
                customRuntimeConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .diskSize(diskSize?.applyValue({ args0 -> args0 }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .functionName(functionName?.applyValue({ args0 -> args0 }))
            .gpuConfig(gpuConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .handler(handler?.applyValue({ args0 -> args0 }))
            .instanceConcurrency(instanceConcurrency?.applyValue({ args0 -> args0 }))
            .instanceLifecycleConfig(
                instanceLifecycleConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .internetAccess(internetAccess?.applyValue({ args0 -> args0 }))
            .layers(layers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .logConfig(logConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .memorySize(memorySize?.applyValue({ args0 -> args0 }))
            .nasConfig(nasConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ossMountConfig(ossMountConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .role(role?.applyValue({ args0 -> args0 }))
            .runtime(runtime?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 }))
            .vpcConfig(vpcConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V3FunctionArgs].
 */
@PulumiTagMarker
public class V3FunctionArgsBuilder internal constructor() {
    private var code: Output<V3FunctionCodeArgs>? = null

    private var cpu: Output<Double>? = null

    private var customContainerConfig: Output<V3FunctionCustomContainerConfigArgs>? = null

    private var customDns: Output<V3FunctionCustomDnsArgs>? = null

    private var customRuntimeConfig: Output<V3FunctionCustomRuntimeConfigArgs>? = null

    private var description: Output<String>? = null

    private var diskSize: Output<Int>? = null

    private var environmentVariables: Output<Map<String, String>>? = null

    private var functionName: Output<String>? = null

    private var gpuConfig: Output<V3FunctionGpuConfigArgs>? = null

    private var handler: Output<String>? = null

    private var instanceConcurrency: Output<Int>? = null

    private var instanceLifecycleConfig: Output<V3FunctionInstanceLifecycleConfigArgs>? = null

    private var internetAccess: Output<Boolean>? = null

    private var layers: Output<List<String>>? = null

    private var logConfig: Output<V3FunctionLogConfigArgs>? = null

    private var memorySize: Output<Int>? = null

    private var nasConfig: Output<V3FunctionNasConfigArgs>? = null

    private var ossMountConfig: Output<V3FunctionOssMountConfigArgs>? = null

    private var role: Output<String>? = null

    private var runtime: Output<String>? = null

    private var timeout: Output<Int>? = null

    private var vpcConfig: Output<V3FunctionVpcConfigArgs>? = null

    /**
     * @param value Function code ZIP package. code and customContainerConfig. See `code` below.
     */
    @JvmName("mixvpdvdjojrtddm")
    public suspend fun code(`value`: Output<V3FunctionCodeArgs>) {
        this.code = value
    }

    /**
     * @param value The CPU specification of the function. The unit is vCPU, which is a multiple of the 0.05 vCPU.
     */
    @JvmName("oliqfknnfggcuojk")
    public suspend fun cpu(`value`: Output<Double>) {
        this.cpu = value
    }

    /**
     * @param value The configuration of the custom container runtime. After the configuration is successful, the function can use the custom container image to execute the function. code and customContainerConfig. See `custom_container_config` below.
     */
    @JvmName("ngriomarprirfyux")
    public suspend fun customContainerConfig(`value`: Output<V3FunctionCustomContainerConfigArgs>) {
        this.customContainerConfig = value
    }

    /**
     * @param value Function custom DNS configuration See `custom_dns` below.
     */
    @JvmName("rtnvexjvhbtoipsk")
    public suspend fun customDns(`value`: Output<V3FunctionCustomDnsArgs>) {
        this.customDns = value
    }

    /**
     * @param value Customize the runtime configuration. See `custom_runtime_config` below.
     */
    @JvmName("rnxqptyxqmeldclh")
    public suspend fun customRuntimeConfig(`value`: Output<V3FunctionCustomRuntimeConfigArgs>) {
        this.customRuntimeConfig = value
    }

    /**
     * @param value The description of the function. The function compute system does not use this attribute value, but we recommend that you set a concise and clear description for the function.
     */
    @JvmName("pthkykxfptaawkam")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The disk specification of the function, in MB. The optional value is 512 MB or 10240MB.
     */
    @JvmName("pesurnesljvcthyw")
    public suspend fun diskSize(`value`: Output<Int>) {
        this.diskSize = value
    }

    /**
     * @param value The environment variable set for the function, you can get the value of the environment variable in the function.
     */
    @JvmName("rwnaynjexjypmlvq")
    public suspend fun environmentVariables(`value`: Output<Map<String, String>>) {
        this.environmentVariables = value
    }

    /**
     * @param value The function name. Consists of uppercase and lowercase letters, digits (0 to 9), underscores (_), and dashes (-). It must begin with an English letter (a ~ z), (A ~ Z), or an underscore (_). Case sensitive. The length is 1~128 characters.
     */
    @JvmName("seooyvicdtwfuojh")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value Function GPU configuration. See `gpu_config` below.
     */
    @JvmName("gvgcejuhtoqxbldr")
    public suspend fun gpuConfig(`value`: Output<V3FunctionGpuConfigArgs>) {
        this.gpuConfig = value
    }

    /**
     * @param value Function Handler: the call entry for the function compute system to run your function.
     */
    @JvmName("weiaavygfyekgxed")
    public suspend fun handler(`value`: Output<String>) {
        this.handler = value
    }

    /**
     * @param value Maximum instance concurrency.
     */
    @JvmName("pvcqimvunuvtofej")
    public suspend fun instanceConcurrency(`value`: Output<Int>) {
        this.instanceConcurrency = value
    }

    /**
     * @param value Instance lifecycle callback method configuration. See `instance_lifecycle_config` below.
     */
    @JvmName("wmchdnvsykidxgvv")
    public suspend fun instanceLifecycleConfig(`value`: Output<V3FunctionInstanceLifecycleConfigArgs>) {
        this.instanceLifecycleConfig = value
    }

    /**
     * @param value Allow function to access public network
     */
    @JvmName("mgkkdtudwkovrpgh")
    public suspend fun internetAccess(`value`: Output<Boolean>) {
        this.internetAccess = value
    }

    /**
     * @param value The list of layers.
     */
    @JvmName("irmdowoyvgnitoim")
    public suspend fun layers(`value`: Output<List<String>>) {
        this.layers = value
    }

    @JvmName("fifapfwdcsckvgrk")
    public suspend fun layers(vararg values: Output<String>) {
        this.layers = Output.all(values.asList())
    }

    /**
     * @param values The list of layers.
     */
    @JvmName("fxkvccefyjuohtqm")
    public suspend fun layers(values: List<Output<String>>) {
        this.layers = Output.all(values)
    }

    /**
     * @param value The logs generated by the function are written to the configured Logstore. See `log_config` below.
     */
    @JvmName("lsvcyecvldjhhkgg")
    public suspend fun logConfig(`value`: Output<V3FunctionLogConfigArgs>) {
        this.logConfig = value
    }

    /**
     * @param value The memory specification of the function. The unit is MB. The memory size is a multiple of 64MB. The minimum value is 128MB and the maximum value is 32GB. At the same time, the ratio of cpu to memorySize (calculated by GB) should be between 1:1 and 1:4.
     */
    @JvmName("pkslvsecnurkvoby")
    public suspend fun memorySize(`value`: Output<Int>) {
        this.memorySize = value
    }

    /**
     * @param value NAS configuration. After this parameter is configured, the function can access the specified NAS resource. See `nas_config` below.
     */
    @JvmName("mlyllupyxfxwddhb")
    public suspend fun nasConfig(`value`: Output<V3FunctionNasConfigArgs>) {
        this.nasConfig = value
    }

    /**
     * @param value OSS mount configuration See `oss_mount_config` below.
     */
    @JvmName("kunrkgfyelkssffl")
    public suspend fun ossMountConfig(`value`: Output<V3FunctionOssMountConfigArgs>) {
        this.ossMountConfig = value
    }

    /**
     * @param value The user is authorized to the RAM role of function compute. After the configuration, function compute will assume this role to generate temporary access credentials. In the function, you can use the temporary access credentials of the role to access the specified Alibaba cloud service, such as OSS and OTS
     */
    @JvmName("xjkavcnbbxoriief")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value Function runtime type
     */
    @JvmName("qkmhfpfwperljira")
    public suspend fun runtime(`value`: Output<String>) {
        this.runtime = value
    }

    /**
     * @param value The maximum running time of the function, in seconds.
     */
    @JvmName("uschvxqtfapiyxhf")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value VPC configuration. After this parameter is configured, the function can access the specified VPC resources. See `vpc_config` below.
     */
    @JvmName("qipyuarfvjylfifi")
    public suspend fun vpcConfig(`value`: Output<V3FunctionVpcConfigArgs>) {
        this.vpcConfig = value
    }

    /**
     * @param value Function code ZIP package. code and customContainerConfig. See `code` below.
     */
    @JvmName("cvrkskwtnpxihhjs")
    public suspend fun code(`value`: V3FunctionCodeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param argument Function code ZIP package. code and customContainerConfig. See `code` below.
     */
    @JvmName("ahqqcrbuxtfogcar")
    public suspend fun code(argument: suspend V3FunctionCodeArgsBuilder.() -> Unit) {
        val toBeMapped = V3FunctionCodeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.code = mapped
    }

    /**
     * @param value The CPU specification of the function. The unit is vCPU, which is a multiple of the 0.05 vCPU.
     */
    @JvmName("exrlbbsaaeqmacet")
    public suspend fun cpu(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value The configuration of the custom container runtime. After the configuration is successful, the function can use the custom container image to execute the function. code and customContainerConfig. See `custom_container_config` below.
     */
    @JvmName("ntyxaekeckymlcwr")
    public suspend fun customContainerConfig(`value`: V3FunctionCustomContainerConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customContainerConfig = mapped
    }

    /**
     * @param argument The configuration of the custom container runtime. After the configuration is successful, the function can use the custom container image to execute the function. code and customContainerConfig. See `custom_container_config` below.
     */
    @JvmName("cdafddhweyufetqr")
    public suspend fun customContainerConfig(argument: suspend V3FunctionCustomContainerConfigArgsBuilder.() -> Unit) {
        val toBeMapped = V3FunctionCustomContainerConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customContainerConfig = mapped
    }

    /**
     * @param value Function custom DNS configuration See `custom_dns` below.
     */
    @JvmName("vrefwnbufjtoctiy")
    public suspend fun customDns(`value`: V3FunctionCustomDnsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDns = mapped
    }

    /**
     * @param argument Function custom DNS configuration See `custom_dns` below.
     */
    @JvmName("qvkmdyqkahqqwjoq")
    public suspend fun customDns(argument: suspend V3FunctionCustomDnsArgsBuilder.() -> Unit) {
        val toBeMapped = V3FunctionCustomDnsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customDns = mapped
    }

    /**
     * @param value Customize the runtime configuration. See `custom_runtime_config` below.
     */
    @JvmName("sqmjnxtexcsyuhro")
    public suspend fun customRuntimeConfig(`value`: V3FunctionCustomRuntimeConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRuntimeConfig = mapped
    }

    /**
     * @param argument Customize the runtime configuration. See `custom_runtime_config` below.
     */
    @JvmName("thltykasvasnonpp")
    public suspend fun customRuntimeConfig(argument: suspend V3FunctionCustomRuntimeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = V3FunctionCustomRuntimeConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customRuntimeConfig = mapped
    }

    /**
     * @param value The description of the function. The function compute system does not use this attribute value, but we recommend that you set a concise and clear description for the function.
     */
    @JvmName("amgmmkhtababalgi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The disk specification of the function, in MB. The optional value is 512 MB or 10240MB.
     */
    @JvmName("tpthfoxkyuytjddq")
    public suspend fun diskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSize = mapped
    }

    /**
     * @param value The environment variable set for the function, you can get the value of the environment variable in the function.
     */
    @JvmName("aaniqfgytgdaqsvt")
    public suspend fun environmentVariables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param values The environment variable set for the function, you can get the value of the environment variable in the function.
     */
    @JvmName("sbnskbspinmvraap")
    public fun environmentVariables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value The function name. Consists of uppercase and lowercase letters, digits (0 to 9), underscores (_), and dashes (-). It must begin with an English letter (a ~ z), (A ~ Z), or an underscore (_). Case sensitive. The length is 1~128 characters.
     */
    @JvmName("xjjwywcahltydirm")
    public suspend fun functionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    /**
     * @param value Function GPU configuration. See `gpu_config` below.
     */
    @JvmName("uatktpviyuiduojp")
    public suspend fun gpuConfig(`value`: V3FunctionGpuConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gpuConfig = mapped
    }

    /**
     * @param argument Function GPU configuration. See `gpu_config` below.
     */
    @JvmName("ncblfbhrwxcolfxg")
    public suspend fun gpuConfig(argument: suspend V3FunctionGpuConfigArgsBuilder.() -> Unit) {
        val toBeMapped = V3FunctionGpuConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gpuConfig = mapped
    }

    /**
     * @param value Function Handler: the call entry for the function compute system to run your function.
     */
    @JvmName("udfnycjtnvwevmfm")
    public suspend fun handler(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.handler = mapped
    }

    /**
     * @param value Maximum instance concurrency.
     */
    @JvmName("lcyylevymxeshugp")
    public suspend fun instanceConcurrency(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceConcurrency = mapped
    }

    /**
     * @param value Instance lifecycle callback method configuration. See `instance_lifecycle_config` below.
     */
    @JvmName("uwgycganmslljxcx")
    public suspend fun instanceLifecycleConfig(`value`: V3FunctionInstanceLifecycleConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceLifecycleConfig = mapped
    }

    /**
     * @param argument Instance lifecycle callback method configuration. See `instance_lifecycle_config` below.
     */
    @JvmName("ylictgbmptrlgoox")
    public suspend fun instanceLifecycleConfig(argument: suspend V3FunctionInstanceLifecycleConfigArgsBuilder.() -> Unit) {
        val toBeMapped = V3FunctionInstanceLifecycleConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.instanceLifecycleConfig = mapped
    }

    /**
     * @param value Allow function to access public network
     */
    @JvmName("igqybulnbivcqmuu")
    public suspend fun internetAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetAccess = mapped
    }

    /**
     * @param value The list of layers.
     */
    @JvmName("destmrnaadfrqvqp")
    public suspend fun layers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.layers = mapped
    }

    /**
     * @param values The list of layers.
     */
    @JvmName("thxafonjqgwwmqel")
    public suspend fun layers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.layers = mapped
    }

    /**
     * @param value The logs generated by the function are written to the configured Logstore. See `log_config` below.
     */
    @JvmName("gpyxwplfxaevqlpn")
    public suspend fun logConfig(`value`: V3FunctionLogConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logConfig = mapped
    }

    /**
     * @param argument The logs generated by the function are written to the configured Logstore. See `log_config` below.
     */
    @JvmName("fqklaiqrxvwljpad")
    public suspend fun logConfig(argument: suspend V3FunctionLogConfigArgsBuilder.() -> Unit) {
        val toBeMapped = V3FunctionLogConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logConfig = mapped
    }

    /**
     * @param value The memory specification of the function. The unit is MB. The memory size is a multiple of 64MB. The minimum value is 128MB and the maximum value is 32GB. At the same time, the ratio of cpu to memorySize (calculated by GB) should be between 1:1 and 1:4.
     */
    @JvmName("vtetdexbedxbawae")
    public suspend fun memorySize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memorySize = mapped
    }

    /**
     * @param value NAS configuration. After this parameter is configured, the function can access the specified NAS resource. See `nas_config` below.
     */
    @JvmName("pyxvguubgwxunrpm")
    public suspend fun nasConfig(`value`: V3FunctionNasConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nasConfig = mapped
    }

    /**
     * @param argument NAS configuration. After this parameter is configured, the function can access the specified NAS resource. See `nas_config` below.
     */
    @JvmName("ukmjgisdlctijhcr")
    public suspend fun nasConfig(argument: suspend V3FunctionNasConfigArgsBuilder.() -> Unit) {
        val toBeMapped = V3FunctionNasConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.nasConfig = mapped
    }

    /**
     * @param value OSS mount configuration See `oss_mount_config` below.
     */
    @JvmName("owtkfqfxdmawcios")
    public suspend fun ossMountConfig(`value`: V3FunctionOssMountConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossMountConfig = mapped
    }

    /**
     * @param argument OSS mount configuration See `oss_mount_config` below.
     */
    @JvmName("bjcykbntvktuswqu")
    public suspend fun ossMountConfig(argument: suspend V3FunctionOssMountConfigArgsBuilder.() -> Unit) {
        val toBeMapped = V3FunctionOssMountConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ossMountConfig = mapped
    }

    /**
     * @param value The user is authorized to the RAM role of function compute. After the configuration, function compute will assume this role to generate temporary access credentials. In the function, you can use the temporary access credentials of the role to access the specified Alibaba cloud service, such as OSS and OTS
     */
    @JvmName("iufmvcjwyrmhuuwt")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value Function runtime type
     */
    @JvmName("hlmotixjrhcwbwqt")
    public suspend fun runtime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtime = mapped
    }

    /**
     * @param value The maximum running time of the function, in seconds.
     */
    @JvmName("ctnftlciilsddyce")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param value VPC configuration. After this parameter is configured, the function can access the specified VPC resources. See `vpc_config` below.
     */
    @JvmName("lkuvmyxjqartjhdl")
    public suspend fun vpcConfig(`value`: V3FunctionVpcConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfig = mapped
    }

    /**
     * @param argument VPC configuration. After this parameter is configured, the function can access the specified VPC resources. See `vpc_config` below.
     */
    @JvmName("tlawqnvjsmjfkqxx")
    public suspend fun vpcConfig(argument: suspend V3FunctionVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped = V3FunctionVpcConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcConfig = mapped
    }

    internal fun build(): V3FunctionArgs = V3FunctionArgs(
        code = code,
        cpu = cpu,
        customContainerConfig = customContainerConfig,
        customDns = customDns,
        customRuntimeConfig = customRuntimeConfig,
        description = description,
        diskSize = diskSize,
        environmentVariables = environmentVariables,
        functionName = functionName,
        gpuConfig = gpuConfig,
        handler = handler,
        instanceConcurrency = instanceConcurrency,
        instanceLifecycleConfig = instanceLifecycleConfig,
        internetAccess = internetAccess,
        layers = layers,
        logConfig = logConfig,
        memorySize = memorySize,
        nasConfig = nasConfig,
        ossMountConfig = ossMountConfig,
        role = role,
        runtime = runtime,
        timeout = timeout,
        vpcConfig = vpcConfig,
    )
}
