@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [V3Trigger].
 */
@PulumiTagMarker
public class V3TriggerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: V3TriggerArgs = V3TriggerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend V3TriggerArgsBuilder.() -> Unit) {
        val builder = V3TriggerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): V3Trigger {
        val builtJavaResource = com.pulumi.alicloud.fc.V3Trigger(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return V3Trigger(builtJavaResource)
    }
}

/**
 * Provides a FCV3 Trigger resource.
 * A trigger is a way of triggering the execution of a function. In the event-driven computing model, the event source is the producer of the event, the function is the handler of the event, and the trigger provides a centralized and unified way to manage different event sources. In the event source, when the event occurs, if the rules defined by the trigger are met,.
 * For information about FCV3 Trigger and how to use it, see [What is Trigger](https://www.alibabacloud.com/help/en/functioncompute/api-fc-2023-03-30-createtrigger).
 * > **NOTE:** Available since v1.228.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const functionName = config.get("functionName") || "TerraformTriggerResourceAPI";
 * const triggerName = config.get("triggerName") || "TerraformTrigger_CDN";
 * const _function = new alicloud.fc.V3Function("function", {
 *     memorySize: 512,
 *     cpu: 0.5,
 *     handler: "index.Handler",
 *     code: {
 *         zipFile: "UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA=",
 *     },
 *     functionName: name,
 *     runtime: "python3.9",
 *     diskSize: 512,
 *     logConfig: {
 *         logBeginRule: "None",
 *     },
 * });
 * const current = alicloud.getAccount({});
 * const _default = new alicloud.fc.V3Trigger("default", {
 *     triggerType: "cdn_events",
 *     triggerName: name,
 *     description: "create",
 *     qualifier: "LATEST",
 *     triggerConfig: JSON.stringify({
 *         eventName: "CachedObjectsPushed",
 *         eventVersion: "1.0.0",
 *         notes: "example",
 *         filter: {
 *             domain: ["example&#46;com"],
 *         },
 *     }),
 *     sourceArn: current.then(current => `acs:cdn:*:${current.id}`),
 *     invocationRole: current.then(current => `acs:ram::${current.id}:role/aliyuncdneventnotificationrole`),
 *     functionName: _function.functionName,
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * function_name = config.get("functionName")
 * if function_name is None:
 *     function_name = "TerraformTriggerResourceAPI"
 * trigger_name = config.get("triggerName")
 * if trigger_name is None:
 *     trigger_name = "TerraformTrigger_CDN"
 * function = alicloud.fc.V3Function("function",
 *     memory_size=512,
 *     cpu=0.5,
 *     handler="index.Handler",
 *     code={
 *         "zip_file": "UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA=",
 *     },
 *     function_name=name,
 *     runtime="python3.9",
 *     disk_size=512,
 *     log_config={
 *         "log_begin_rule": "None",
 *     })
 * current = alicloud.get_account()
 * default = alicloud.fc.V3Trigger("default",
 *     trigger_type="cdn_events",
 *     trigger_name=name,
 *     description="create",
 *     qualifier="LATEST",
 *     trigger_config=json.dumps({
 *         "eventName": "CachedObjectsPushed",
 *         "eventVersion": "1.0.0",
 *         "notes": "example",
 *         "filter": {
 *             "domain": ["example&#46;com"],
 *         },
 *     }),
 *     source_arn=f"acs:cdn:*:{current.id}",
 *     invocation_role=f"acs:ram::{current.id}:role/aliyuncdneventnotificationrole",
 *     function_name=function.function_name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var functionName = config.Get("functionName") ?? "TerraformTriggerResourceAPI";
 *     var triggerName = config.Get("triggerName") ?? "TerraformTrigger_CDN";
 *     var function = new AliCloud.FC.V3Function("function", new()
 *     {
 *         MemorySize = 512,
 *         Cpu = 0.5,
 *         Handler = "index.Handler",
 *         Code = new AliCloud.FC.Inputs.V3FunctionCodeArgs
 *         {
 *             ZipFile = "UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA=",
 *         },
 *         FunctionName = name,
 *         Runtime = "python3.9",
 *         DiskSize = 512,
 *         LogConfig = new AliCloud.FC.Inputs.V3FunctionLogConfigArgs
 *         {
 *             LogBeginRule = "None",
 *         },
 *     });
 *     var current = AliCloud.GetAccount.Invoke();
 *     var @default = new AliCloud.FC.V3Trigger("default", new()
 *     {
 *         TriggerType = "cdn_events",
 *         TriggerName = name,
 *         Description = "create",
 *         Qualifier = "LATEST",
 *         TriggerConfig = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["eventName"] = "CachedObjectsPushed",
 *             ["eventVersion"] = "1.0.0",
 *             ["notes"] = "example",
 *             ["filter"] = new Dictionary<string, object?>
 *             {
 *                 ["domain"] = new[]
 *                 {
 *                     "example.com",
 *                 },
 *             },
 *         }),
 *         SourceArn = $"acs:cdn:*:{current.Apply(getAccountResult => getAccountResult.Id)}",
 *         InvocationRole = $"acs:ram::{current.Apply(getAccountResult => getAccountResult.Id)}:role/aliyuncdneventnotificationrole",
 *         FunctionName = function.FunctionName,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		functionName := "TerraformTriggerResourceAPI"
 * 		if param := cfg.Get("functionName"); param != "" {
 * 			functionName = param
 * 		}
 * 		triggerName := "TerraformTrigger_CDN"
 * 		if param := cfg.Get("triggerName"); param != "" {
 * 			triggerName = param
 * 		}
 * 		function, err := fc.NewV3Function(ctx, "function", &fc.V3FunctionArgs{
 * 			MemorySize: pulumi.Int(512),
 * 			Cpu:        pulumi.Float64(0.5),
 * 			Handler:    pulumi.String("index.Handler"),
 * 			Code: &fc.V3FunctionCodeArgs{
 * 				ZipFile: pulumi.String("UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA="),
 * 			},
 * 			FunctionName: pulumi.String(name),
 * 			Runtime:      pulumi.String("python3.9"),
 * 			DiskSize:     pulumi.Int(512),
 * 			LogConfig: &fc.V3FunctionLogConfigArgs{
 * 				LogBeginRule: pulumi.String("None"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		current, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"eventName":    "CachedObjectsPushed",
 * 			"eventVersion": "1.0.0",
 * 			"notes":        "example",
 * 			"filter": map[string]interface{}{
 * 				"domain": []string{
 * 					"example.com",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = fc.NewV3Trigger(ctx, "default", &fc.V3TriggerArgs{
 * 			TriggerType:    pulumi.String("cdn_events"),
 * 			TriggerName:    pulumi.String(name),
 * 			Description:    pulumi.String("create"),
 * 			Qualifier:      pulumi.String("LATEST"),
 * 			TriggerConfig:  pulumi.String(json0),
 * 			SourceArn:      pulumi.Sprintf("acs:cdn:*:%v", current.Id),
 * 			InvocationRole: pulumi.Sprintf("acs:ram::%v:role/aliyuncdneventnotificationrole", current.Id),
 * 			FunctionName:   function.FunctionName,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.fc.V3Function;
 * import com.pulumi.alicloud.fc.V3FunctionArgs;
 * import com.pulumi.alicloud.fc.inputs.V3FunctionCodeArgs;
 * import com.pulumi.alicloud.fc.inputs.V3FunctionLogConfigArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.fc.V3Trigger;
 * import com.pulumi.alicloud.fc.V3TriggerArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var functionName = config.get("functionName").orElse("TerraformTriggerResourceAPI");
 *         final var triggerName = config.get("triggerName").orElse("TerraformTrigger_CDN");
 *         var function = new V3Function("function", V3FunctionArgs.builder()
 *             .memorySize("512")
 *             .cpu(0.5)
 *             .handler("index.Handler")
 *             .code(V3FunctionCodeArgs.builder()
 *                 .zipFile("UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA=")
 *                 .build())
 *             .functionName(name)
 *             .runtime("python3.9")
 *             .diskSize("512")
 *             .logConfig(V3FunctionLogConfigArgs.builder()
 *                 .logBeginRule("None")
 *                 .build())
 *             .build());
 *         final var current = AlicloudFunctions.getAccount();
 *         var default_ = new V3Trigger("default", V3TriggerArgs.builder()
 *             .triggerType("cdn_events")
 *             .triggerName(name)
 *             .description("create")
 *             .qualifier("LATEST")
 *             .triggerConfig(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("eventName", "CachedObjectsPushed"),
 *                     jsonProperty("eventVersion", "1.0.0"),
 *                     jsonProperty("notes", "example"),
 *                     jsonProperty("filter", jsonObject(
 *                         jsonProperty("domain", jsonArray("example.com"))
 *                     ))
 *                 )))
 *             .sourceArn(String.format("acs:cdn:*:%s", current.applyValue(getAccountResult -> getAccountResult.id())))
 *             .invocationRole(String.format("acs:ram::%s:role/aliyuncdneventnotificationrole", current.applyValue(getAccountResult -> getAccountResult.id())))
 *             .functionName(function.functionName())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 *   functionName:
 *     type: string
 *     default: TerraformTriggerResourceAPI
 *   triggerName:
 *     type: string
 *     default: TerraformTrigger_CDN
 * resources:
 *   function:
 *     type: alicloud:fc:V3Function
 *     properties:
 *       memorySize: '512'
 *       cpu: 0.5
 *       handler: index.Handler
 *       code:
 *         zipFile: UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA=
 *       functionName: ${name}
 *       runtime: python3.9
 *       diskSize: '512'
 *       logConfig:
 *         logBeginRule: None
 *   default:
 *     type: alicloud:fc:V3Trigger
 *     properties:
 *       triggerType: cdn_events
 *       triggerName: ${name}
 *       description: create
 *       qualifier: LATEST
 *       triggerConfig:
 *         fn::toJSON:
 *           eventName: CachedObjectsPushed
 *           eventVersion: 1.0.0
 *           notes: example
 *           filter:
 *             domain:
 *               - example.com
 *       sourceArn: acs:cdn:*:${current.id}
 *       invocationRole: acs:ram::${current.id}:role/aliyuncdneventnotificationrole
 *       functionName: ${function.functionName}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * FCV3 Trigger can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:fc/v3Trigger:V3Trigger example <function_name>:<trigger_name>
 * ```
 */
public class V3Trigger internal constructor(
    override val javaResource: com.pulumi.alicloud.fc.V3Trigger,
) : KotlinCustomResource(javaResource, V3TriggerMapper) {
    /**
     * Creation time
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Description of the trigger
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Function Name
     */
    public val functionName: Output<String>
        get() = javaResource.functionName().applyValue({ args0 -> args0 })

    /**
     * The role required by the event source (such as OSS) to call the function.
     */
    public val invocationRole: Output<String>?
        get() = javaResource.invocationRole().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The version or alias of the function
     */
    public val qualifier: Output<String>
        get() = javaResource.qualifier().applyValue({ args0 -> args0 })

    /**
     * Trigger Event source ARN
     */
    public val sourceArn: Output<String>?
        get() = javaResource.sourceArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The state of the trigger
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Trigger configuration. The configuration varies for different types of triggers.
     */
    public val triggerConfig: Output<String>?
        get() = javaResource.triggerConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Trigger Name
     */
    public val triggerName: Output<String>
        get() = javaResource.triggerName().applyValue({ args0 -> args0 })

    /**
     * The type of the trigger. Currently, the supported types include oss, log, http, timer, tablestore, cdn_events, mns_topic and eventbridge.
     */
    public val triggerType: Output<String>
        get() = javaResource.triggerType().applyValue({ args0 -> args0 })
}

public object V3TriggerMapper : ResourceMapper<V3Trigger> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.fc.V3Trigger::class == javaResource::class

    override fun map(javaResource: Resource): V3Trigger = V3Trigger(
        javaResource as
            com.pulumi.alicloud.fc.V3Trigger,
    )
}

/**
 * @see [V3Trigger].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [V3Trigger].
 */
public suspend fun v3Trigger(name: String, block: suspend V3TriggerResourceBuilder.() -> Unit): V3Trigger {
    val builder = V3TriggerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [V3Trigger].
 * @param name The _unique_ name of the resulting resource.
 */
public fun v3Trigger(name: String): V3Trigger {
    val builder = V3TriggerResourceBuilder()
    builder.name(name)
    return builder.build()
}
