@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.AliasRoutingConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property additionalVersionWeights A map that defines the proportion of events that should be sent to different versions of a Function Compute service.
 */
public data class AliasRoutingConfigArgs(
    public val additionalVersionWeights: Output<Map<String, Double>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.AliasRoutingConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.AliasRoutingConfigArgs =
        com.pulumi.alicloud.fc.inputs.AliasRoutingConfigArgs.builder()
            .additionalVersionWeights(
                additionalVersionWeights?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AliasRoutingConfigArgs].
 */
@PulumiTagMarker
public class AliasRoutingConfigArgsBuilder internal constructor() {
    private var additionalVersionWeights: Output<Map<String, Double>>? = null

    /**
     * @param value A map that defines the proportion of events that should be sent to different versions of a Function Compute service.
     */
    @JvmName("jbjgweltbkgoqhqy")
    public suspend fun additionalVersionWeights(`value`: Output<Map<String, Double>>) {
        this.additionalVersionWeights = value
    }

    /**
     * @param value A map that defines the proportion of events that should be sent to different versions of a Function Compute service.
     */
    @JvmName("gvwtbbgdkgjoreym")
    public suspend fun additionalVersionWeights(`value`: Map<String, Double>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalVersionWeights = mapped
    }

    /**
     * @param values A map that defines the proportion of events that should be sent to different versions of a Function Compute service.
     */
    @JvmName("hpcybuhdgomdpyyc")
    public fun additionalVersionWeights(vararg values: Pair<String, Double>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalVersionWeights = mapped
    }

    internal fun build(): AliasRoutingConfigArgs = AliasRoutingConfigArgs(
        additionalVersionWeights = additionalVersionWeights,
    )
}
