@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.CustomDomainCertConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certName The name of the certificate, used to distinguish different certificates.
 * @property certificate Certificate data of the HTTPS certificates, follow the 'pem' format.
 * @property privateKey Private key of the HTTPS certificates, follow the 'pem' format.
 */
public data class CustomDomainCertConfigArgs(
    public val certName: Output<String>,
    public val certificate: Output<String>,
    public val privateKey: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.CustomDomainCertConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.CustomDomainCertConfigArgs =
        com.pulumi.alicloud.fc.inputs.CustomDomainCertConfigArgs.builder()
            .certName(certName.applyValue({ args0 -> args0 }))
            .certificate(certificate.applyValue({ args0 -> args0 }))
            .privateKey(privateKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomDomainCertConfigArgs].
 */
@PulumiTagMarker
public class CustomDomainCertConfigArgsBuilder internal constructor() {
    private var certName: Output<String>? = null

    private var certificate: Output<String>? = null

    private var privateKey: Output<String>? = null

    /**
     * @param value The name of the certificate, used to distinguish different certificates.
     */
    @JvmName("nsfyhihimtfflcho")
    public suspend fun certName(`value`: Output<String>) {
        this.certName = value
    }

    /**
     * @param value Certificate data of the HTTPS certificates, follow the 'pem' format.
     */
    @JvmName("lpkkjdknwmxobaob")
    public suspend fun certificate(`value`: Output<String>) {
        this.certificate = value
    }

    /**
     * @param value Private key of the HTTPS certificates, follow the 'pem' format.
     */
    @JvmName("qoaajvpcjchhhkyp")
    public suspend fun privateKey(`value`: Output<String>) {
        this.privateKey = value
    }

    /**
     * @param value The name of the certificate, used to distinguish different certificates.
     */
    @JvmName("iqumetrrolidrusk")
    public suspend fun certName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certName = mapped
    }

    /**
     * @param value Certificate data of the HTTPS certificates, follow the 'pem' format.
     */
    @JvmName("hhbftnihifigcvqm")
    public suspend fun certificate(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param value Private key of the HTTPS certificates, follow the 'pem' format.
     */
    @JvmName("hlhmlmfrmodbkevu")
    public suspend fun privateKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    internal fun build(): CustomDomainCertConfigArgs = CustomDomainCertConfigArgs(
        certName = certName ?: throw PulumiNullFieldException("certName"),
        certificate = certificate ?: throw PulumiNullFieldException("certificate"),
        privateKey = privateKey ?: throw PulumiNullFieldException("privateKey"),
    )
}
