@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.CustomDomainRouteConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property functionName The name of the Function Compute function that requests are routed to.
 * @property methods The requests of the specified HTTP methos are routed from. Valid method: GET, POST, DELETE, HEAD, PUT and PATCH. For example, "GET, HEAD" methods indicate that only requests from GET and HEAD methods are routed.
 * @property path The path that requests are routed from.
 * @property qualifier The version or alias of the Function Compute service that requests are routed to. For example, qualifier v1 indicates that the requests are routed to the version 1 Function Compute service. For detail information about version and alias, please refer to the [developer guide](https://www.alibabacloud.com/help/doc-detail/96464.htm).
 * @property serviceName The name of the Function Compute service that requests are routed to.
 */
public data class CustomDomainRouteConfigArgs(
    public val functionName: Output<String>,
    public val methods: Output<List<String>>? = null,
    public val path: Output<String>,
    public val qualifier: Output<String>? = null,
    public val serviceName: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.CustomDomainRouteConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.CustomDomainRouteConfigArgs =
        com.pulumi.alicloud.fc.inputs.CustomDomainRouteConfigArgs.builder()
            .functionName(functionName.applyValue({ args0 -> args0 }))
            .methods(methods?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .path(path.applyValue({ args0 -> args0 }))
            .qualifier(qualifier?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomDomainRouteConfigArgs].
 */
@PulumiTagMarker
public class CustomDomainRouteConfigArgsBuilder internal constructor() {
    private var functionName: Output<String>? = null

    private var methods: Output<List<String>>? = null

    private var path: Output<String>? = null

    private var qualifier: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value The name of the Function Compute function that requests are routed to.
     */
    @JvmName("qukcmeymmooojcam")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value The requests of the specified HTTP methos are routed from. Valid method: GET, POST, DELETE, HEAD, PUT and PATCH. For example, "GET, HEAD" methods indicate that only requests from GET and HEAD methods are routed.
     */
    @JvmName("dkbftyvourufyerf")
    public suspend fun methods(`value`: Output<List<String>>) {
        this.methods = value
    }

    @JvmName("hqnhhnjofjtoidhn")
    public suspend fun methods(vararg values: Output<String>) {
        this.methods = Output.all(values.asList())
    }

    /**
     * @param values The requests of the specified HTTP methos are routed from. Valid method: GET, POST, DELETE, HEAD, PUT and PATCH. For example, "GET, HEAD" methods indicate that only requests from GET and HEAD methods are routed.
     */
    @JvmName("wpwxrwavgmokrwxk")
    public suspend fun methods(values: List<Output<String>>) {
        this.methods = Output.all(values)
    }

    /**
     * @param value The path that requests are routed from.
     */
    @JvmName("tcbtvqjjedhpxkqs")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The version or alias of the Function Compute service that requests are routed to. For example, qualifier v1 indicates that the requests are routed to the version 1 Function Compute service. For detail information about version and alias, please refer to the [developer guide](https://www.alibabacloud.com/help/doc-detail/96464.htm).
     */
    @JvmName("gjqlrpfnefvqdeuq")
    public suspend fun qualifier(`value`: Output<String>) {
        this.qualifier = value
    }

    /**
     * @param value The name of the Function Compute service that requests are routed to.
     */
    @JvmName("xaeuvxvxwhaeoywa")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The name of the Function Compute function that requests are routed to.
     */
    @JvmName("augyovynpdgyjmbh")
    public suspend fun functionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    /**
     * @param value The requests of the specified HTTP methos are routed from. Valid method: GET, POST, DELETE, HEAD, PUT and PATCH. For example, "GET, HEAD" methods indicate that only requests from GET and HEAD methods are routed.
     */
    @JvmName("spsrqbpvidbfrbnp")
    public suspend fun methods(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.methods = mapped
    }

    /**
     * @param values The requests of the specified HTTP methos are routed from. Valid method: GET, POST, DELETE, HEAD, PUT and PATCH. For example, "GET, HEAD" methods indicate that only requests from GET and HEAD methods are routed.
     */
    @JvmName("ykomaoiflhlsugrv")
    public suspend fun methods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.methods = mapped
    }

    /**
     * @param value The path that requests are routed from.
     */
    @JvmName("fgitltrdfryigmym")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value The version or alias of the Function Compute service that requests are routed to. For example, qualifier v1 indicates that the requests are routed to the version 1 Function Compute service. For detail information about version and alias, please refer to the [developer guide](https://www.alibabacloud.com/help/doc-detail/96464.htm).
     */
    @JvmName("nhtnetdopsvhkeay")
    public suspend fun qualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qualifier = mapped
    }

    /**
     * @param value The name of the Function Compute service that requests are routed to.
     */
    @JvmName("qpuoflwfymudvggy")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): CustomDomainRouteConfigArgs = CustomDomainRouteConfigArgs(
        functionName = functionName ?: throw PulumiNullFieldException("functionName"),
        methods = methods,
        path = path ?: throw PulumiNullFieldException("path"),
        qualifier = qualifier,
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
