@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.FunctionAsyncInvokeConfigDestinationConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property onFailure Configuration block with destination configuration for failed asynchronous invocations. See `on_failure` below.
 * @property onSuccess Configuration block with destination configuration for successful asynchronous invocations. See `on_success` below.
 */
public data class FunctionAsyncInvokeConfigDestinationConfigArgs(
    public val onFailure: Output<FunctionAsyncInvokeConfigDestinationConfigOnFailureArgs>? = null,
    public val onSuccess: Output<FunctionAsyncInvokeConfigDestinationConfigOnSuccessArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.FunctionAsyncInvokeConfigDestinationConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.FunctionAsyncInvokeConfigDestinationConfigArgs =
        com.pulumi.alicloud.fc.inputs.FunctionAsyncInvokeConfigDestinationConfigArgs.builder()
            .onFailure(onFailure?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .onSuccess(onSuccess?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FunctionAsyncInvokeConfigDestinationConfigArgs].
 */
@PulumiTagMarker
public class FunctionAsyncInvokeConfigDestinationConfigArgsBuilder internal constructor() {
    private var onFailure: Output<FunctionAsyncInvokeConfigDestinationConfigOnFailureArgs>? = null

    private var onSuccess: Output<FunctionAsyncInvokeConfigDestinationConfigOnSuccessArgs>? = null

    /**
     * @param value Configuration block with destination configuration for failed asynchronous invocations. See `on_failure` below.
     */
    @JvmName("tincoitqggnisftw")
    public suspend fun onFailure(`value`: Output<FunctionAsyncInvokeConfigDestinationConfigOnFailureArgs>) {
        this.onFailure = value
    }

    /**
     * @param value Configuration block with destination configuration for successful asynchronous invocations. See `on_success` below.
     */
    @JvmName("mvyafgpmnnnvqtqk")
    public suspend fun onSuccess(`value`: Output<FunctionAsyncInvokeConfigDestinationConfigOnSuccessArgs>) {
        this.onSuccess = value
    }

    /**
     * @param value Configuration block with destination configuration for failed asynchronous invocations. See `on_failure` below.
     */
    @JvmName("osybwvpfsakhtbqh")
    public suspend fun onFailure(`value`: FunctionAsyncInvokeConfigDestinationConfigOnFailureArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onFailure = mapped
    }

    /**
     * @param argument Configuration block with destination configuration for failed asynchronous invocations. See `on_failure` below.
     */
    @JvmName("dvmkpnywquyuuxev")
    public suspend fun onFailure(argument: suspend FunctionAsyncInvokeConfigDestinationConfigOnFailureArgsBuilder.() -> Unit) {
        val toBeMapped = FunctionAsyncInvokeConfigDestinationConfigOnFailureArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.onFailure = mapped
    }

    /**
     * @param value Configuration block with destination configuration for successful asynchronous invocations. See `on_success` below.
     */
    @JvmName("mukagotsxkfgygip")
    public suspend fun onSuccess(`value`: FunctionAsyncInvokeConfigDestinationConfigOnSuccessArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onSuccess = mapped
    }

    /**
     * @param argument Configuration block with destination configuration for successful asynchronous invocations. See `on_success` below.
     */
    @JvmName("ckehfqckbveurujh")
    public suspend fun onSuccess(argument: suspend FunctionAsyncInvokeConfigDestinationConfigOnSuccessArgsBuilder.() -> Unit) {
        val toBeMapped = FunctionAsyncInvokeConfigDestinationConfigOnSuccessArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.onSuccess = mapped
    }

    internal fun build(): FunctionAsyncInvokeConfigDestinationConfigArgs =
        FunctionAsyncInvokeConfigDestinationConfigArgs(
            onFailure = onFailure,
            onSuccess = onSuccess,
        )
}
